/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.axistools;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.mojo.axistools.axis.AxisPluginException;
import org.codehaus.mojo.axistools.java2wsdl.DefaultJava2WSDLPlugin;

public class Java2WSDLMojo
extends AbstractMojo {
    private File classesDirectory;
    private File outputDirectory;
    private String filename;
    private String classOfPortType;
    private String input;
    private String location;
    private String portTypeName;
    private String bindingName;
    private String serviceElementName;
    private String servicePortName;
    private String namespace;
    private String packageToNamespace;
    private ArrayList methods;
    private boolean all;
    private String outputWSDLMode;
    private String locationImport;
    private String namespaceImpl;
    private String outputImpl;
    private String implClass;
    private ArrayList excludes;
    private ArrayList stopClasses;
    private String typeMappingVersion;
    private String soapAction;
    private String style;
    private String use;
    private ArrayList extraClasses;
    private String importSchema;
    private MavenProject project;
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        DefaultJava2WSDLPlugin plugin = new DefaultJava2WSDLPlugin();
        String classpath = this.getCompileClasspath();
        plugin.setAll(this.all);
        plugin.setBindingName(this.bindingName);
        plugin.setClasspath(classpath);
        plugin.setClassOfPortType(this.classOfPortType);
        plugin.setExcludes(this.excludes);
        plugin.setExtraClasses(this.extraClasses);
        plugin.setFilename(this.filename);
        plugin.setImplClass(this.implClass);
        plugin.setImportSchema(this.importSchema);
        plugin.setInput(this.input);
        plugin.setLocation(this.location);
        plugin.setLocationImport(this.locationImport);
        plugin.setMethods(this.methods);
        plugin.setNamespace(this.namespace);
        plugin.setNamespaceImpl(this.namespaceImpl);
        plugin.setOutputDirectory(this.outputDirectory);
        plugin.setOutputImpl(this.outputImpl);
        plugin.setOutputWSDLMode(this.outputWSDLMode);
        plugin.setPackageToNamespace(this.packageToNamespace);
        plugin.setPortTypeName(this.portTypeName);
        plugin.setServiceElementName(this.serviceElementName);
        plugin.setServicePortName(this.servicePortName);
        plugin.setSoapAction(this.soapAction);
        plugin.setStopClasses(this.stopClasses);
        plugin.setStyle(this.style);
        plugin.setTypeMappingVersion(this.typeMappingVersion);
        plugin.setUse(this.use);
        plugin.setLog(this.getLog());
        plugin.setProjectHelper(this.projectHelper);
        plugin.setProject(this.project);
        try {
            plugin.execute();
        }
        catch (AxisPluginException e) {
            throw new MojoExecutionException("Error executing creating WSDL from the Java code.", (Exception)e);
        }
    }

    private String getCompileClasspath() throws MojoExecutionException {
        try {
            LinkedHashSet<String> dependencySet = new LinkedHashSet<String>();
            dependencySet.addAll(this.project.getCompileClasspathElements());
            dependencySet.add(this.classesDirectory.getAbsolutePath());
            String compileClasspath = StringUtils.join(dependencySet, (String)File.pathSeparator);
            return compileClasspath;
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }
}

