/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.antlr.plan;

import java.io.File;
import java.util.LinkedHashSet;

public class GenerationPlan {
    private final String id;
    private final File source;
    private final File generationDirectory;
    private File importVocabTokenTypesDirectory;
    private boolean outOfDate;
    private LinkedHashSet collectedSuperGrammarIds = new LinkedHashSet();

    GenerationPlan(String id, File source, File generationDirectory, String[] glibIds) {
        this.id = id;
        this.source = source;
        this.generationDirectory = generationDirectory;
        if (glibIds != null) {
            for (int i = 0; i < glibIds.length; ++i) {
                this.addSuperGrammarId(glibIds[i]);
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public File getSource() {
        return this.source;
    }

    public File getGenerationDirectory() {
        return this.generationDirectory;
    }

    void addSuperGrammarId(String id) {
        this.collectedSuperGrammarIds.add(id);
    }

    public LinkedHashSet getCollectedSuperGrammarIds() {
        return this.collectedSuperGrammarIds;
    }

    public File getImportVocabTokenTypesDirectory() {
        return this.importVocabTokenTypesDirectory;
    }

    void setImportVocabTokenTypesDirectory(File importVocabTokenTypesDirectory) {
        this.importVocabTokenTypesDirectory = importVocabTokenTypesDirectory;
    }

    public boolean isOutOfDate() {
        return this.outOfDate;
    }

    void markOutOfDate() {
        this.outOfDate = true;
    }
}

