/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugins.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.modello.model.ModelClass;
import org.codehaus.modello.model.ModelField;
import org.codehaus.modello.plugin.AbstractModelloGenerator;
import org.codehaus.modello.plugins.xml.XmlFieldMetadata;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractXmlGenerator
extends AbstractModelloGenerator {
    protected String resolveFieldTagName(ModelField field) {
        XmlFieldMetadata metadata = (XmlFieldMetadata)field.getMetadata(XmlFieldMetadata.ID);
        String tagName = AbstractXmlGenerator.uncapitalise((String)field.getName());
        if (metadata != null && StringUtils.isNotEmpty((String)metadata.getTagName())) {
            tagName = metadata.getTagName();
        }
        return tagName;
    }

    protected List getAttributeFieldsForClass(ModelClass modelClass) {
        ArrayList<ModelField> attributeFields = new ArrayList<ModelField>();
        while (modelClass != null) {
            List allFields = modelClass.getFields(this.getGeneratedVersion());
            Iterator allFieldsIt = allFields.iterator();
            while (allFieldsIt.hasNext()) {
                ModelField field = (ModelField)allFieldsIt.next();
                XmlFieldMetadata fieldMetadata = (XmlFieldMetadata)field.getMetadata(XmlFieldMetadata.ID);
                if (!fieldMetadata.isAttribute()) continue;
                attributeFields.add(field);
            }
            String superClass = modelClass.getSuperClass();
            if (superClass != null) {
                modelClass = this.getModel().getClass(superClass, this.getGeneratedVersion());
                continue;
            }
            modelClass = null;
        }
        return attributeFields;
    }

    protected boolean hasContentField(List modelFields) {
        if (modelFields == null) {
            return false;
        }
        Iterator j = modelFields.iterator();
        while (j.hasNext()) {
            ModelField field = (ModelField)j.next();
            if (!"Content".equals(field.getType())) continue;
            return true;
        }
        return false;
    }

    protected ModelField getContentField(List modelFields) {
        if (modelFields == null) {
            return null;
        }
        Iterator j = modelFields.iterator();
        while (j.hasNext()) {
            ModelField field = (ModelField)j.next();
            if (!"Content".equals(field.getType())) continue;
            return field;
        }
        return null;
    }
}

