/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.xdoc;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.codehaus.modello.ModelloException;
import org.codehaus.modello.ModelloRuntimeException;
import org.codehaus.modello.model.Model;
import org.codehaus.modello.model.ModelAssociation;
import org.codehaus.modello.model.ModelClass;
import org.codehaus.modello.model.ModelField;
import org.codehaus.modello.model.Version;
import org.codehaus.modello.model.VersionRange;
import org.codehaus.modello.plugin.model.ModelClassMetadata;
import org.codehaus.modello.plugins.xml.AbstractXmlGenerator;
import org.codehaus.modello.plugins.xml.XmlFieldMetadata;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.codehaus.plexus.util.xml.XmlStreamWriter;

public class XdocGenerator
extends AbstractXmlGenerator {
    private static final VersionRange DEFAULT_VERSION_RANGE = new VersionRange("0.0.0+");
    private Version firstVersion = DEFAULT_VERSION_RANGE.getFromVersion();
    private Version version = DEFAULT_VERSION_RANGE.getFromVersion();

    public void generate(Model model, Properties parameters) throws ModelloException {
        this.initialize(model, parameters);
        if (parameters.getProperty("modello.first.version") != null) {
            this.firstVersion = new Version(parameters.getProperty("modello.first.version"));
        }
        if (parameters.getProperty("modello.version") != null) {
            this.version = new Version(parameters.getProperty("modello.version"));
        }
        try {
            this.generateXdoc(parameters);
        }
        catch (IOException ex) {
            throw new ModelloException("Exception while generating XDoc.", (Throwable)ex);
        }
    }

    private void generateXdoc(Properties parameters) throws IOException {
        Model objectModel = this.getModel();
        File directory = this.getOutputDirectory();
        if (this.isPackageWithVersion()) {
            directory = new File(directory, this.getGeneratedVersion().toString());
        }
        if (!directory.exists()) {
            directory.mkdirs();
        }
        String xdocFileName = parameters.getProperty("modello.output.xdoc.file");
        File f = new File(directory, objectModel.getId() + ".xml");
        if (xdocFileName != null) {
            f = new File(directory, xdocFileName);
        }
        XmlStreamWriter writer = WriterFactory.newXmlWriter((File)f);
        PrettyPrintXMLWriter w = new PrettyPrintXMLWriter((Writer)writer);
        writer.write("<?xml version=\"1.0\"?>\n");
        w.startElement("document");
        w.startElement("properties");
        w.startElement("title");
        w.writeText(objectModel.getName());
        w.endElement();
        w.endElement();
        w.startElement("body");
        w.startElement("section");
        w.addAttribute("name", objectModel.getName());
        w.startElement("p");
        if (objectModel.getDescription() != null) {
            w.writeMarkup(objectModel.getDescription());
        } else {
            w.writeText("No description.");
        }
        w.endElement();
        w.startElement("source");
        StringBuffer sb = new StringBuffer();
        ModelClass root = objectModel.getClass(objectModel.getRoot(this.getGeneratedVersion()), this.getGeneratedVersion());
        sb.append(this.getModelClassDescriptor(root, null, 0));
        w.writeMarkup("\n" + sb);
        w.endElement();
        this.writeElementDescriptor((XMLWriter)w, root, null, new HashSet());
        w.endElement();
        w.endElement();
        w.endElement();
        writer.flush();
        writer.close();
    }

    private void writeElementDescriptor(XMLWriter w, ModelClass modelClass, ModelAssociation association, Set written) {
        this.writeElementDescriptor(w, modelClass, association, written, true);
    }

    private void writeElementDescriptor(XMLWriter w, ModelClass modelClass, ModelAssociation association, Set written, boolean recursive) {
        written.add(modelClass);
        String tagName = this.resolveTagName(modelClass, association);
        w.startElement("a");
        w.addAttribute("name", "class_" + tagName);
        w.endElement();
        w.startElement("subsection");
        w.addAttribute("name", tagName);
        w.startElement("p");
        if (modelClass.getDescription() != null) {
            w.writeMarkup(modelClass.getDescription());
        } else {
            w.writeMarkup("No description.");
        }
        w.endElement();
        ModelField contentField = this.getContentField(this.getFieldsForClass(modelClass));
        if (contentField != null) {
            w.startElement("p");
            w.startElement("b");
            w.writeText("Element Content : ");
            w.writeMarkup(contentField.getDescription());
            w.endElement();
            w.endElement();
        }
        ArrayList attributeFields = new ArrayList(this.getAttributeFieldsForClass(modelClass));
        ArrayList elementFields = new ArrayList(this.getFieldsForClass(modelClass));
        elementFields.removeAll(attributeFields);
        this.generateFieldsTable(w, elementFields, true);
        this.generateFieldsTable(w, attributeFields, false);
        w.endElement();
        Iterator iter = this.getFieldsForClass(modelClass).iterator();
        while (iter.hasNext()) {
            ModelField f = (ModelField)iter.next();
            if (!this.isInnerAssociation(f) || !recursive) continue;
            ModelAssociation assoc = (ModelAssociation)f;
            ModelClass fieldModelClass = this.getModel().getClass(assoc.getTo(), this.getGeneratedVersion());
            if (written.contains(f.getName())) continue;
            if (modelClass.getName().equals(fieldModelClass.getName()) && modelClass.getPackageName().equals(fieldModelClass.getPackageName())) {
                this.writeElementDescriptor(w, fieldModelClass, assoc, written, false);
                continue;
            }
            this.writeElementDescriptor(w, fieldModelClass, assoc, written);
        }
    }

    private void generateFieldsTable(XMLWriter w, List fields, boolean elementFields) {
        if (fields == null || fields.isEmpty()) {
            return;
        }
        if (fields.size() == 1 && "Content".equals(((ModelField)fields.get(0)).getType())) {
            return;
        }
        w.startElement("table");
        w.startElement("tr");
        w.startElement("th");
        w.writeText(elementFields ? "Element" : "Attribute");
        w.endElement();
        w.startElement("th");
        w.writeText("Description");
        w.endElement();
        boolean showSinceColumn = this.version.greaterThan(this.firstVersion);
        if (showSinceColumn) {
            w.startElement("th");
            w.writeText("Since");
            w.endElement();
        }
        w.endElement();
        Iterator j = fields.iterator();
        while (j.hasNext()) {
            ModelField f = (ModelField)j.next();
            if ("Content".equals(f.getType())) continue;
            XmlFieldMetadata fieldMetadata = (XmlFieldMetadata)f.getMetadata(XmlFieldMetadata.ID);
            w.startElement("tr");
            w.startElement("td");
            w.startElement("code");
            boolean flatAssociation = false;
            if (this.isInnerAssociation(f)) {
                flatAssociation = "flat".equals(fieldMetadata.getListStyle());
                ModelAssociation assoc = (ModelAssociation)f;
                ModelClass associationModelClass = this.getModel().getClass(assoc.getTo(), this.getGeneratedVersion());
                w.startElement("a");
                if (fieldMetadata.getTagName() != null) {
                    w.addAttribute("href", "#class_" + fieldMetadata.getTagName());
                } else {
                    w.addAttribute("href", "#class_" + XdocGenerator.uncapitalise((String)associationModelClass.getName()));
                }
                if (flatAssociation) {
                    if (fieldMetadata.getTagName() != null) {
                        w.writeText(XdocGenerator.uncapitalise((String)fieldMetadata.getTagName()));
                    } else {
                        w.writeText(XdocGenerator.uncapitalise((String)associationModelClass.getName()));
                    }
                } else {
                    w.writeText(f.getName());
                }
                w.endElement();
            } else {
                w.writeText(this.resolveFieldTagName(f));
            }
            w.endElement();
            w.endElement();
            w.startElement("td");
            if (flatAssociation) {
                w.writeMarkup("<b>List</b>  ");
            }
            if (f.getDescription() != null) {
                w.writeMarkup(f.getDescription());
            } else {
                w.writeText("No description.");
            }
            if (f.getDefaultValue() != null && !(f instanceof ModelAssociation)) {
                w.writeText(" The default value is ");
                w.startElement("code");
                w.writeText(f.getDefaultValue());
                w.endElement();
                w.writeText(".");
            }
            w.endElement();
            if (showSinceColumn) {
                Version fromVersion;
                w.startElement("td");
                if (f.getVersionRange() != null && (fromVersion = f.getVersionRange().getFromVersion()) != null && fromVersion.greaterThan(this.firstVersion)) {
                    w.writeMarkup(fromVersion.toString());
                }
                w.endElement();
            }
            w.endElement();
        }
        w.endElement();
    }

    private String getModelClassDescriptor(ModelClass modelClass, ModelAssociation association, int depth) {
        return this.getModelClassDescriptor(modelClass, association, depth, true);
    }

    private String getModelClassDescriptor(ModelClass modelClass, ModelAssociation association, int depth, boolean recursive) throws ModelloRuntimeException {
        ModelField f;
        Iterator iter;
        StringBuffer sb = new StringBuffer();
        XdocGenerator.appendSpacer(sb, depth);
        String tagName = this.resolveTagName(modelClass, association);
        sb.append("&lt;<a href=\"#class_").append(tagName).append("\">").append(tagName).append("</a>");
        List fields = this.getFieldsForClass(modelClass);
        List attributeFields = this.getAttributeFieldsForClass(modelClass);
        if (attributeFields.size() > 0) {
            iter = attributeFields.iterator();
            while (iter.hasNext()) {
                f = (ModelField)iter.next();
                sb.append(" ");
                sb.append(this.resolveFieldTagName(f)).append("=..");
            }
            sb.append(" ");
            fields.removeAll(attributeFields);
        }
        if (fields.size() > 0) {
            sb.append("&gt;\n");
            iter = fields.iterator();
            while (iter.hasNext()) {
                f = (ModelField)iter.next();
                if (this.isInnerAssociation(f) && recursive) {
                    boolean listStyleWrapped;
                    ModelAssociation assoc = (ModelAssociation)f;
                    XmlFieldMetadata fieldMetadata = (XmlFieldMetadata)f.getMetadata(XmlFieldMetadata.ID);
                    boolean bl = listStyleWrapped = "*".equals(assoc.getMultiplicity()) && "wrapped".equals(fieldMetadata.getListStyle());
                    if (listStyleWrapped) {
                        XdocGenerator.appendSpacer(sb, ++depth);
                        sb.append("&lt;").append(XdocGenerator.uncapitalise((String)assoc.getName())).append("&gt;\n");
                    }
                    ModelClass fieldModelClass = this.getModel().getClass(assoc.getTo(), this.getGeneratedVersion());
                    if (modelClass.getName().equals(fieldModelClass.getName()) && modelClass.getPackageName().equals(fieldModelClass.getPackageName())) {
                        sb.append(this.getModelClassDescriptor(fieldModelClass, assoc, depth + 1, false));
                    } else {
                        sb.append(this.getModelClassDescriptor(fieldModelClass, assoc, depth + 1));
                    }
                    if (!listStyleWrapped) continue;
                    XdocGenerator.appendSpacer(sb, depth);
                    sb.append("&lt;/").append(XdocGenerator.uncapitalise((String)assoc.getName())).append("&gt;\n");
                    --depth;
                    continue;
                }
                XdocGenerator.appendSpacer(sb, depth + 1);
                sb.append("&lt;").append(this.resolveFieldTagName(f)).append("/&gt;\n");
            }
            XdocGenerator.appendSpacer(sb, depth);
            sb.append("&lt;/").append(tagName).append("&gt;\n");
        } else {
            sb.append("/&gt;\n");
        }
        return sb.toString();
    }

    private String resolveTagName(ModelClass modelClass, ModelAssociation association) {
        XmlFieldMetadata fieldMetadata;
        String tagName;
        ModelClassMetadata metadata = (ModelClassMetadata)modelClass.getMetadata(ModelClassMetadata.ID);
        if (metadata == null || metadata.getTagName() == null) {
            if (association == null) {
                tagName = XdocGenerator.uncapitalise((String)modelClass.getName());
            } else {
                tagName = association.getName();
                if ("*".equals(association.getMultiplicity())) {
                    tagName = this.singular(tagName);
                }
            }
        } else {
            tagName = metadata.getTagName();
        }
        if (association != null && (fieldMetadata = (XmlFieldMetadata)association.getMetadata(XmlFieldMetadata.ID)) != null) {
            if (fieldMetadata.getAssociationTagName() != null) {
                tagName = fieldMetadata.getAssociationTagName();
            } else if (fieldMetadata.getTagName() != null) {
                tagName = fieldMetadata.getTagName();
            }
        }
        return tagName;
    }

    private static void appendSpacer(StringBuffer sb, int depth) {
        for (int i = 0; i < depth; ++i) {
            sb.append("  ");
        }
    }
}

