/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.java;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import org.codehaus.modello.ModelloException;
import org.codehaus.modello.model.BaseElement;
import org.codehaus.modello.model.Model;
import org.codehaus.modello.model.ModelAssociation;
import org.codehaus.modello.model.ModelClass;
import org.codehaus.modello.model.ModelField;
import org.codehaus.modello.model.ModelInterface;
import org.codehaus.modello.model.ModelType;
import org.codehaus.modello.plugin.AbstractModelloGenerator;
import org.codehaus.modello.plugin.java.javasource.JClass;
import org.codehaus.modello.plugin.java.javasource.JComment;
import org.codehaus.modello.plugin.java.javasource.JInterface;
import org.codehaus.modello.plugin.java.javasource.JSourceWriter;
import org.codehaus.modello.plugin.java.javasource.JStructure;
import org.codehaus.modello.plugin.java.metadata.JavaClassMetadata;
import org.codehaus.modello.plugin.java.metadata.JavaFieldMetadata;
import org.codehaus.modello.plugin.java.metadata.JavaModelMetadata;
import org.codehaus.modello.plugin.model.ModelClassMetadata;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractJavaModelloGenerator
extends AbstractModelloGenerator {
    private Optional<Integer> javaSource;
    protected boolean domAsXpp3 = true;
    protected static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";

    protected void initialize(Model model, Properties parameters) throws ModelloException {
        super.initialize(model, parameters);
        this.javaSource = Optional.ofNullable(this.getParameter(parameters, "modello.output.java.source", null)).map(Integer::valueOf);
        this.domAsXpp3 = !"false".equals(parameters.getProperty("modello.dom.xpp3"));
    }

    protected JSourceWriter newJSourceWriter(String packageName, String className) throws IOException {
        String directory = packageName.replace('.', File.separatorChar);
        File f = new File(new File(this.getOutputDirectory(), directory), className + ".java");
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        return new JSourceWriter(this.newWriter(f.toPath()));
    }

    private JComment getHeaderComment() {
        JComment comment = new JComment();
        comment.setComment(this.getHeader());
        return comment;
    }

    protected void initHeader(JClass clazz) {
        clazz.setHeader(this.getHeaderComment());
    }

    protected void initHeader(JInterface interfaze) {
        interfaze.setHeader(this.getHeaderComment());
    }

    protected final boolean hasJavaSourceSupport(int source) {
        return this.javaSource.map(i -> i >= source).orElse(false);
    }

    protected void suppressAllWarnings(Model objectModel, JStructure structure) {
        JavaModelMetadata javaModelMetadata = (JavaModelMetadata)objectModel.getMetadata(JavaModelMetadata.ID);
        if (this.hasJavaSourceSupport(5) && javaModelMetadata.isSuppressAllWarnings()) {
            structure.appendAnnotation("@SuppressWarnings( \"all\" )");
        }
    }

    protected void addModelImports(JClass jClass, BaseElement baseElem) throws ModelloException {
        String basePackageName = null;
        if (baseElem instanceof ModelType) {
            basePackageName = ((ModelType)baseElem).getPackageName(this.isPackageWithVersion(), this.getGeneratedVersion());
        }
        for (ModelInterface modelInterface : this.getModel().getInterfaces(this.getGeneratedVersion())) {
            this.addModelImport(jClass, (ModelType)modelInterface, basePackageName);
        }
        for (ModelClass modelClass : this.getClasses(this.getModel())) {
            this.addModelImport(jClass, (ModelType)modelClass, basePackageName);
        }
    }

    protected void addModelImport(JClass jClass, ModelType modelType, String basePackageName) {
        String packageName = modelType.getPackageName(this.isPackageWithVersion(), this.getGeneratedVersion());
        if (!packageName.equals(basePackageName)) {
            jClass.addImport(packageName + '.' + modelType.getName());
        }
    }

    protected String getPrefix(JavaFieldMetadata javaFieldMetadata) {
        return javaFieldMetadata.isBooleanGetter() ? "is" : "get";
    }

    protected String getDefaultValue(ModelAssociation association) {
        String value = association.getDefaultValue();
        if (this.hasJavaSourceSupport(5)) {
            value = StringUtils.replaceOnce((String)StringUtils.replaceOnce((String)value, (String)"/*", (String)""), (String)"*/", (String)"");
        }
        return value;
    }

    protected String getJavaDefaultValue(ModelField modelField) throws ModelloException {
        String type = modelField.getType();
        String value = modelField.getDefaultValue();
        if ("String".equals(type)) {
            return '\"' + this.escapeStringLiteral(value) + '\"';
        }
        if ("char".equals(type)) {
            return '\'' + this.escapeStringLiteral(value) + '\'';
        }
        if ("long".equals(type)) {
            return value + 'L';
        }
        if ("float".equals(type)) {
            return value + 'f';
        }
        if ("Date".equals(type)) {
            SimpleDateFormat format = new SimpleDateFormat(DEFAULT_DATE_FORMAT, Locale.US);
            try {
                Date date = format.parse(value);
                return "new java.util.Date( " + date.getTime() + "L )";
            }
            catch (ParseException pe) {
                throw new ModelloException("Unparseable default date: " + value, (Throwable)pe);
            }
        }
        if (value != null && value.length() > 0) {
            boolean useJava5 = this.hasJavaSourceSupport(5);
            if ("Character".equals(type) && !value.contains(type)) {
                return this.newPrimitiveWrapper(type, "'" + this.escapeStringLiteral(value) + "'", useJava5);
            }
            if ("Boolean".equals(type) && !value.contains(type)) {
                return this.newPrimitiveWrapper(type, value, true);
            }
            if ("Byte".equals(type) && !value.contains(type)) {
                return this.newPrimitiveWrapper(type, "(byte) " + value, useJava5);
            }
            if ("Short".equals(type) && !value.contains(type)) {
                return this.newPrimitiveWrapper(type, "(short) " + value, useJava5);
            }
            if ("Integer".equals(type) && !value.contains(type)) {
                return this.newPrimitiveWrapper(type, value, useJava5);
            }
            if ("Long".equals(type) && !value.contains(type)) {
                return this.newPrimitiveWrapper(type, value + 'L', useJava5);
            }
            if ("Float".equals(type) && !value.contains(type)) {
                return this.newPrimitiveWrapper(type, value + 'f', useJava5);
            }
            if ("Double".equals(type) && !value.contains(type)) {
                return this.newPrimitiveWrapper(type, value, useJava5);
            }
        }
        return value;
    }

    private String newPrimitiveWrapper(String type, String value, boolean useJava5) {
        if (useJava5) {
            return type + ".valueOf( " + value + " )";
        }
        return "new " + type + "( " + value + " )";
    }

    private String escapeStringLiteral(String str) {
        StringBuilder buffer = new StringBuilder(str.length() + 32);
        int n = str.length();
        block7: for (int i = 0; i < n; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\u0000': {
                    buffer.append("\\0");
                    continue block7;
                }
                case '\t': {
                    buffer.append("\\t");
                    continue block7;
                }
                case '\r': {
                    buffer.append("\\r");
                    continue block7;
                }
                case '\n': {
                    buffer.append("\\n");
                    continue block7;
                }
                case '\\': {
                    buffer.append("\\\\");
                    continue block7;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }

    protected String getValueChecker(String type, String value, ModelField field) throws ModelloException {
        String retVal = "boolean".equals(type) || "double".equals(type) || "float".equals(type) || "int".equals(type) || "long".equals(type) || "short".equals(type) || "byte".equals(type) || "char".equals(type) ? "if ( " + value + " != " + this.getJavaDefaultValue(field) + " )" : ("java.util.List".equals(type) || "java.util.Set".equals(type) || "java.util.Map".equals(type) || "java.util.Properties".equals(type) ? "if ( ( " + value + " != null ) && ( " + value + ".size() > 0 ) )" : ("String".equals(type) && field.getDefaultValue() != null ? "if ( ( " + value + " != null ) && !" + value + ".equals( \"" + field.getDefaultValue() + "\" ) )" : ("Date".equals(type) && field.getDefaultValue() != null ? "if ( ( " + value + " != null ) && !" + value + ".equals( " + this.getJavaDefaultValue(field) + " ) )" : "if ( " + value + " != null )")));
        return retVal;
    }

    protected List<ModelClass> getClasses(Model model) {
        ArrayList<ModelClass> modelClasses = new ArrayList<ModelClass>();
        for (ModelClass modelClass : model.getClasses(this.getGeneratedVersion())) {
            if (!this.isRelevant(modelClass)) continue;
            modelClasses.add(modelClass);
        }
        return modelClasses;
    }

    protected boolean isRelevant(ModelClass modelClass) {
        return this.isJavaEnabled(modelClass) && !this.isTrackingSupport(modelClass);
    }

    protected boolean isJavaEnabled(ModelClass modelClass) {
        JavaClassMetadata javaClassMetadata = (JavaClassMetadata)modelClass.getMetadata(JavaClassMetadata.ID);
        return javaClassMetadata.isEnabled();
    }

    protected boolean isTrackingSupport(ModelClass modelClass) {
        ModelClassMetadata modelClassMetadata = (ModelClassMetadata)modelClass.getMetadata(ModelClassMetadata.ID);
        if (StringUtils.isNotEmpty((String)modelClassMetadata.getLocationTracker())) {
            return true;
        }
        return StringUtils.isNotEmpty((String)modelClassMetadata.getSourceTracker());
    }
}

