/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.dom4j;

import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import org.codehaus.modello.ModelloException;
import org.codehaus.modello.model.Model;
import org.codehaus.modello.model.ModelAssociation;
import org.codehaus.modello.model.ModelClass;
import org.codehaus.modello.model.ModelField;
import org.codehaus.modello.plugin.AbstractModelloGenerator;
import org.codehaus.modello.plugin.java.javasource.JClass;
import org.codehaus.modello.plugin.java.javasource.JMethod;
import org.codehaus.modello.plugin.java.javasource.JParameter;
import org.codehaus.modello.plugin.java.javasource.JSourceCode;
import org.codehaus.modello.plugin.java.javasource.JSourceWriter;
import org.codehaus.modello.plugin.java.javasource.JType;
import org.codehaus.modello.plugins.xml.XmlAssociationMetadata;
import org.codehaus.modello.plugins.xml.XmlClassMetadata;
import org.codehaus.modello.plugins.xml.XmlFieldMetadata;

public class Dom4jReaderGenerator
extends AbstractModelloGenerator {
    public void generate(Model model, Properties parameters) throws ModelloException {
        this.initialize(model, parameters);
        try {
            this.generateDom4jReader();
        }
        catch (IOException ex) {
            throw new ModelloException("Exception while generating Dom4j Reader.", (Throwable)ex);
        }
    }

    private void generateDom4jReader() throws ModelloException, IOException {
        Model objectModel = this.getModel();
        String packageName = this.isPackageWithVersion() ? objectModel.getDefaultPackageName(true, this.getGeneratedVersion()) : objectModel.getDefaultPackageName(false, null);
        packageName = packageName + ".io.dom4j";
        String unmarshallerName = this.getFileName("Dom4jReader");
        JSourceWriter sourceWriter = this.newJSourceWriter(packageName, unmarshallerName);
        JClass jClass = new JClass(unmarshallerName);
        jClass.setPackageName(packageName);
        jClass.addImport("java.io.IOException");
        jClass.addImport("java.io.Reader");
        jClass.addImport("java.net.URL");
        jClass.addImport("java.util.Date");
        jClass.addImport("java.util.Locale");
        jClass.addImport("java.text.DateFormat");
        jClass.addImport("java.text.ParsePosition");
        jClass.addImport("java.util.Iterator");
        jClass.addImport("org.codehaus.plexus.util.xml.Xpp3Dom");
        jClass.addImport("org.dom4j.Attribute");
        jClass.addImport("org.dom4j.Document");
        jClass.addImport("org.dom4j.DocumentException");
        jClass.addImport("org.dom4j.Element");
        jClass.addImport("org.dom4j.Node");
        jClass.addImport("org.dom4j.io.SAXReader");
        this.addModelImports(jClass, null);
        ModelClass root = objectModel.getClass(objectModel.getRoot(this.getGeneratedVersion()), this.getGeneratedVersion());
        JMethod unmarshall = new JMethod((JType)new JClass(root.getName()), "read");
        unmarshall.addParameter(new JParameter((JType)new JClass("Reader"), "reader"));
        unmarshall.addParameter(new JParameter(JType.Boolean, "strict"));
        unmarshall.addException(new JClass("IOException"));
        unmarshall.addException(new JClass("DocumentException"));
        JSourceCode sc = unmarshall.getSourceCode();
        sc.add("SAXReader parser = new SAXReader();");
        sc.add("Document document = parser.read( reader );");
        sc.add("String encoding = document.getXMLEncoding();");
        sc.add("return parse" + root.getName() + "( \"" + this.getTagName(root) + "\", document.getRootElement(), strict, encoding );");
        jClass.addMethod(unmarshall);
        unmarshall = new JMethod((JType)new JClass(root.getName()), "read");
        unmarshall.addParameter(new JParameter((JType)new JClass("Reader"), "reader"));
        unmarshall.addException(new JClass("IOException"));
        unmarshall.addException(new JClass("DocumentException"));
        sc = unmarshall.getSourceCode();
        sc.add("return read( reader, true );");
        jClass.addMethod(unmarshall);
        unmarshall = new JMethod((JType)new JClass(root.getName()), "read");
        unmarshall.addParameter(new JParameter((JType)new JClass("URL"), "url"));
        unmarshall.addParameter(new JParameter(JType.Boolean, "strict"));
        unmarshall.addException(new JClass("IOException"));
        unmarshall.addException(new JClass("DocumentException"));
        sc = unmarshall.getSourceCode();
        sc.add("SAXReader parser = new SAXReader();");
        sc.add("Document document = parser.read( url );");
        sc.add("String encoding = document.getXMLEncoding();");
        sc.add("return parse" + root.getName() + "( \"" + this.getTagName(root) + "\", document.getRootElement(), strict, encoding );");
        jClass.addMethod(unmarshall);
        unmarshall = new JMethod((JType)new JClass(root.getName()), "read");
        unmarshall.addParameter(new JParameter((JType)new JClass("URL"), "url"));
        unmarshall.addException(new JClass("IOException"));
        unmarshall.addException(new JClass("DocumentException"));
        sc = unmarshall.getSourceCode();
        sc.add("return read( url, true );");
        jClass.addMethod(unmarshall);
        this.writeAllClassesParser(objectModel, jClass);
        this.writeHelpers(jClass);
        jClass.print(sourceWriter);
        sourceWriter.close();
    }

    private String getTagName(ModelClass root) {
        XmlClassMetadata metadata = (XmlClassMetadata)root.getMetadata(XmlClassMetadata.ID);
        String tagName = metadata.getTagName();
        if (tagName == null) {
            tagName = Dom4jReaderGenerator.uncapitalise((String)root.getName());
        }
        return tagName;
    }

    protected String getFileName(String suffix) throws ModelloException {
        String name = this.getModel().getName();
        return name + suffix;
    }

    private void writeAllClassesParser(Model objectModel, JClass jClass) {
        ModelClass root = objectModel.getClass(objectModel.getRoot(this.getGeneratedVersion()), this.getGeneratedVersion());
        Iterator i = objectModel.getClasses(this.getGeneratedVersion()).iterator();
        while (i.hasNext()) {
            ModelClass clazz = (ModelClass)i.next();
            if (root.getName().equals(clazz.getName())) {
                this.writeClassParser(clazz, jClass, true);
                continue;
            }
            this.writeClassParser(clazz, jClass, false);
        }
    }

    private void writeClassParser(ModelClass modelClass, JClass jClass, boolean rootElement) {
        String className = modelClass.getName();
        String capClassName = this.capitalise(className);
        String uncapClassName = Dom4jReaderGenerator.uncapitalise((String)className);
        JMethod unmarshall = new JMethod((JType)new JClass(className), "parse" + capClassName);
        unmarshall.addParameter(new JParameter((JType)new JClass("String"), "tagName"));
        unmarshall.addParameter(new JParameter((JType)new JClass("Element"), "element"));
        unmarshall.addParameter(new JParameter(JType.Boolean, "strict"));
        unmarshall.addParameter(new JParameter((JType)new JClass("String"), "encoding"));
        unmarshall.addException(new JClass("IOException"));
        unmarshall.addException(new JClass("DocumentException"));
        unmarshall.getModifiers().makePrivate();
        JSourceCode sc = unmarshall.getSourceCode();
        sc.add(className + " " + uncapClassName + " = new " + className + "();");
        sc.add(uncapClassName + ".setModelEncoding( encoding );");
        Iterator i = modelClass.getAllFields(this.getGeneratedVersion(), true).iterator();
        while (i.hasNext()) {
            ModelField field = (ModelField)i.next();
            XmlFieldMetadata fieldMetadata = (XmlFieldMetadata)field.getMetadata(XmlFieldMetadata.ID);
            if (!fieldMetadata.isAttribute()) continue;
            this.writePrimitiveField(field, field.getType(), uncapClassName, "set" + this.capitalise(field.getName()), sc, jClass, "element", "childElement");
        }
        if (rootElement) {
            sc.add("if ( strict )");
            sc.add("{");
            sc.indent();
            sc.add("if ( !element.getName().equals( tagName ) )");
            sc.add("{");
            sc.indent();
            sc.add("throw new DocumentException( \"Error parsing model: root element tag is '\" + element.getName() + \"' instead of '\" + tagName + \"'\" );");
            sc.unindent();
            sc.add("}");
            sc.unindent();
            sc.add("}");
        }
        sc.add("java.util.Set parsed = new java.util.HashSet();");
        sc.add("for ( Iterator i = element.nodeIterator(); i.hasNext(); )");
        sc.add("{");
        sc.indent();
        sc.add("Node node = (Node) i.next();");
        sc.add("if ( node.getNodeType() != Node.ELEMENT_NODE )");
        sc.add("{");
        sc.indent();
        sc.unindent();
        sc.add("}");
        sc.add("else");
        sc.add("{");
        sc.indent();
        sc.add("Element childElement = (Element) node;");
        String statement = "if";
        Iterator i2 = modelClass.getAllFields(this.getGeneratedVersion(), true).iterator();
        while (i2.hasNext()) {
            ModelField field = (ModelField)i2.next();
            XmlFieldMetadata fieldMetadata = (XmlFieldMetadata)field.getMetadata(XmlFieldMetadata.ID);
            if (fieldMetadata.isAttribute()) continue;
            this.processField(fieldMetadata, field, statement, sc, uncapClassName, modelClass, jClass);
            statement = "else if";
        }
        if (statement.startsWith("else")) {
            sc.add("else");
            sc.add("{");
            sc.indent();
        }
        sc.add("if ( strict )");
        sc.add("{");
        sc.indent();
        sc.add("throw new DocumentException( \"Unrecognised tag: '\" + childElement.getName() + \"'\" );");
        sc.unindent();
        sc.add("}");
        if (statement.startsWith("else")) {
            sc.unindent();
            sc.add("}");
        }
        sc.unindent();
        sc.add("}");
        sc.unindent();
        sc.add("}");
        sc.add("return " + uncapClassName + ";");
        jClass.addMethod(unmarshall);
    }

    private void processField(XmlFieldMetadata fieldMetadata, ModelField field, String statement, JSourceCode sc, String uncapClassName, ModelClass modelClass, JClass jClass) {
        String singularTagName;
        String tagName = fieldMetadata.getTagName();
        if (tagName == null) {
            tagName = field.getName();
        }
        if ((singularTagName = fieldMetadata.getAssociationTagName()) == null) {
            singularTagName = this.singular(tagName);
        }
        boolean wrappedList = "wrapped".equals(fieldMetadata.getListStyle());
        String capFieldName = this.capitalise(field.getName());
        String singularName = this.singular(field.getName());
        String optionalCheck = "";
        if (field.getAlias() != null && field.getAlias().length() > 0) {
            optionalCheck = "|| childElement.getName().equals( \"" + field.getAlias() + "\" ) ";
        }
        String tagComparison = statement + " ( childElement.getName().equals( \"" + tagName + "\" ) " + optionalCheck + " )";
        if (field instanceof ModelAssociation) {
            ModelAssociation association = (ModelAssociation)field;
            String associationName = association.getName();
            if ("1".equals(association.getMultiplicity())) {
                sc.add(tagComparison);
                sc.add("{");
                sc.indent();
                this.addCodeToCheckIfParsed(sc, tagName);
                sc.add(uncapClassName + ".set" + capFieldName + "( parse" + association.getTo() + "( \"" + tagName + "\", childElement, strict, encoding ) );");
                sc.unindent();
                sc.add("}");
            } else {
                String type = association.getType();
                if ("java.util.List".equals(type) || "java.util.Set".equals(type)) {
                    if (wrappedList) {
                        sc.add(tagComparison);
                        sc.add("{");
                        sc.indent();
                        this.addCodeToCheckIfParsed(sc, tagName);
                        sc.add(type + " " + associationName + " = " + association.getDefaultValue() + ";");
                        sc.add(uncapClassName + ".set" + capFieldName + "( " + associationName + " );");
                        sc.add("for ( Iterator j = childElement.nodeIterator(); j.hasNext(); )");
                        sc.add("{");
                        sc.indent();
                        sc.add("Node n = (Node) j.next();");
                        sc.add("if ( n.getNodeType() != Node.ELEMENT_NODE )");
                        sc.add("{");
                        sc.indent();
                        sc.unindent();
                        sc.add("}");
                        sc.add("else");
                        sc.add("{");
                        sc.indent();
                        sc.add("Element listElement = (Element) n;");
                        sc.add("if ( listElement.getName().equals( \"" + singularTagName + "\" ) )");
                        sc.add("{");
                        sc.indent();
                    } else {
                        sc.add(statement + " ( childElement.getName().equals( \"" + singularTagName + "\" ) )");
                        sc.add("{");
                        sc.indent();
                        sc.add("Element listElement = childElement;");
                        sc.add(type + " " + associationName + " = " + uncapClassName + ".get" + capFieldName + "();");
                        sc.add("if ( " + associationName + " == null )");
                        sc.add("{");
                        sc.indent();
                        sc.add(associationName + " = " + association.getDefaultValue() + ";");
                        sc.add(uncapClassName + ".set" + capFieldName + "( " + associationName + " );");
                        sc.unindent();
                        sc.add("}");
                    }
                    if (this.isClassInModel(association.getTo(), modelClass.getModel())) {
                        sc.add(associationName + ".add( parse" + association.getTo() + "( \"" + singularTagName + "\", listElement, strict, encoding ) );");
                    } else {
                        this.writePrimitiveField((ModelField)association, association.getTo(), associationName, "add", sc, jClass, "childElement", "listElement");
                    }
                    if (wrappedList) {
                        sc.unindent();
                        sc.add("}");
                        sc.add("else");
                        sc.add("{");
                        sc.indent();
                        sc.unindent();
                        sc.add("}");
                        sc.unindent();
                        sc.add("}");
                        sc.unindent();
                        sc.add("}");
                        sc.unindent();
                        sc.add("}");
                    } else {
                        sc.unindent();
                        sc.add("}");
                    }
                } else {
                    sc.add(tagComparison);
                    sc.add("{");
                    sc.indent();
                    this.addCodeToCheckIfParsed(sc, tagName);
                    XmlAssociationMetadata xmlAssociationMetadata = (XmlAssociationMetadata)association.getAssociationMetadata(XmlAssociationMetadata.ID);
                    if ("explode".equals(xmlAssociationMetadata.getMapStyle())) {
                        sc.add("for ( Iterator j = childElement.nodeIterator(); j.hasNext(); )");
                        sc.add("{");
                        sc.indent();
                        sc.add("Node n = (Node) j.next();");
                        sc.add("if ( n.getNodeType() != Node.ELEMENT_NODE )");
                        sc.add("{");
                        sc.indent();
                        sc.unindent();
                        sc.add("}");
                        sc.add("else");
                        sc.add("{");
                        sc.indent();
                        sc.add("Element listElement = (Element) n;");
                        sc.add("if ( listElement.getName().equals( \"" + singularTagName + "\" ) )");
                        sc.add("{");
                        sc.indent();
                        sc.add("String key = null;");
                        sc.add("String value = null;");
                        sc.add("//" + xmlAssociationMetadata.getMapStyle() + " mode.");
                        sc.add("for ( Iterator k = listElement.nodeIterator(); k.hasNext(); )");
                        sc.add("{");
                        sc.indent();
                        sc.add("Node nd = (Node) k.next();");
                        sc.add("if ( nd.getNodeType() != Node.ELEMENT_NODE )");
                        sc.add("{");
                        sc.indent();
                        sc.unindent();
                        sc.add("}");
                        sc.add("else");
                        sc.add("{");
                        sc.indent();
                        sc.add("Element propertyElement = (Element) nd;");
                        sc.add("if ( propertyElement.getName().equals( \"key\" ) )");
                        sc.add("{");
                        sc.indent();
                        sc.add("key = propertyElement.getText();");
                        sc.unindent();
                        sc.add("}");
                        sc.add("else if ( propertyElement.getName().equals( \"value\" ) )");
                        sc.add("{");
                        sc.indent();
                        sc.add("value = propertyElement.getText()");
                        if (fieldMetadata.isTrim()) {
                            sc.add(".trim()");
                        }
                        sc.add(";");
                        sc.unindent();
                        sc.add("}");
                        sc.add("else");
                        sc.add("{");
                        sc.indent();
                        sc.unindent();
                        sc.add("}");
                        sc.unindent();
                        sc.add("}");
                        sc.unindent();
                        sc.add("}");
                        sc.add(uncapClassName + ".add" + this.capitalise(singularName) + "( key, value );");
                        sc.unindent();
                        sc.add("}");
                        sc.unindent();
                        sc.add("}");
                        sc.unindent();
                        sc.add("}");
                    } else {
                        sc.add("for ( Iterator j = childElement.nodeIterator(); j.hasNext(); )");
                        sc.add("{");
                        sc.indent();
                        sc.add("Node n = (Node) j.next();");
                        sc.add("if ( n.getNodeType() != Node.ELEMENT_NODE )");
                        sc.add("{");
                        sc.indent();
                        sc.unindent();
                        sc.add("}");
                        sc.add("else");
                        sc.add("{");
                        sc.indent();
                        sc.add("Element listElement = (Element) n;");
                        sc.add("String key = listElement.getName();");
                        sc.add("String value = listElement.getText()");
                        if (fieldMetadata.isTrim()) {
                            sc.add(".trim()");
                        }
                        sc.add(";");
                        sc.add(uncapClassName + ".add" + this.capitalise(singularName) + "( key, value );");
                        sc.unindent();
                        sc.add("}");
                        sc.unindent();
                        sc.add("}");
                    }
                    sc.unindent();
                    sc.add("}");
                }
            }
        } else {
            sc.add(tagComparison);
            sc.add("{");
            sc.indent();
            this.addCodeToCheckIfParsed(sc, tagName);
            this.writePrimitiveField(field, field.getType(), uncapClassName, "set" + this.capitalise(field.getName()), sc, jClass, "element", "childElement");
            sc.unindent();
            sc.add("}");
        }
    }

    private void addCodeToCheckIfParsed(JSourceCode sc, String tagName) {
        sc.add("if ( parsed.contains( \"" + tagName + "\" ) )");
        sc.add("{");
        sc.indent();
        sc.add("throw new DocumentException( \"Duplicated tag: '\" + element.getName() + \"'\");");
        sc.unindent();
        sc.add("}");
        sc.add("parsed.add( \"" + tagName + "\" );");
    }

    private void writePrimitiveField(ModelField field, String type, String objectName, String setterName, JSourceCode sc, JClass jClass, String parentElementName, String childElementName) {
        XmlFieldMetadata fieldMetaData = (XmlFieldMetadata)field.getMetadata(XmlFieldMetadata.ID);
        String tagName = fieldMetaData.getTagName();
        if (tagName == null) {
            tagName = field.getName();
        }
        String parserGetter = fieldMetaData.isAttribute() ? parentElementName + ".attributeValue( \"" + tagName + "\" )" : childElementName + ".getText()";
        if (fieldMetaData.isTrim()) {
            parserGetter = "getTrimmedValue( " + parserGetter + " )";
        }
        if ("boolean".equals(type)) {
            sc.add(objectName + "." + setterName + "( getBooleanValue( " + parserGetter + ", \"" + tagName + "\" ) );");
        } else if ("char".equals(type)) {
            sc.add(objectName + "." + setterName + "( getCharacterValue( " + parserGetter + ", \"" + tagName + "\" ) );");
        } else if ("double".equals(type)) {
            sc.add(objectName + "." + setterName + "( getDoubleValue( " + parserGetter + ", \"" + tagName + "\", strict ) );");
        } else if ("float".equals(type)) {
            sc.add(objectName + "." + setterName + "( getFloatValue( " + parserGetter + ", \"" + tagName + "\", strict ) );");
        } else if ("int".equals(type)) {
            sc.add(objectName + "." + setterName + "( getIntegerValue( " + parserGetter + ", \"" + tagName + "\", strict ) );");
        } else if ("long".equals(type)) {
            sc.add(objectName + "." + setterName + "( getLongValue( " + parserGetter + ", \"" + tagName + "\", strict ) );");
        } else if ("short".equals(type)) {
            sc.add(objectName + "." + setterName + "( getShortValue( " + parserGetter + ", \"" + tagName + "\", strict ) );");
        } else if ("byte".equals(type)) {
            sc.add(objectName + "." + setterName + "( getByteValue( " + parserGetter + ", \"" + tagName + "\", strict ) );");
        } else if ("String".equals(type) || "Boolean".equals(type)) {
            sc.add(objectName + "." + setterName + "( " + parserGetter + " );");
        } else if ("Date".equals(type)) {
            sc.add("String dateFormat = " + (fieldMetaData.getFormat() != null ? "\"" + fieldMetaData.getFormat() + "\"" : "null") + ";");
            sc.add(objectName + "." + setterName + "( getDateValue( " + parserGetter + ", \"" + tagName + "\", dateFormat ) );");
        } else if ("DOM".equals(type)) {
            sc.add(objectName + "." + setterName + "( writeElementToXpp3Dom( " + childElementName + " ) );");
        } else {
            throw new IllegalArgumentException("Unknown type: " + type);
        }
    }

    private void writeHelpers(JClass jClass) {
        JMethod method = new JMethod((JType)new JClass("String"), "getTrimmedValue");
        method.addParameter(new JParameter((JType)new JClass("String"), "s"));
        JSourceCode sc = method.getSourceCode();
        sc.add("if ( s != null )");
        sc.add("{");
        sc.indent();
        sc.add("s = s.trim();");
        sc.unindent();
        sc.add("}");
        sc.add("return s;");
        jClass.addMethod(method);
        method = new JMethod(JType.Boolean, "getBooleanValue");
        method.addParameter(new JParameter((JType)new JClass("String"), "s"));
        method.addParameter(new JParameter((JType)new JClass("String"), "attribute"));
        sc = method.getSourceCode();
        sc.add("if ( s != null )");
        sc.add("{");
        sc.indent();
        sc.add("return Boolean.valueOf( s ).booleanValue();");
        sc.unindent();
        sc.add("}");
        sc.add("return false;");
        jClass.addMethod(method);
        method = new JMethod(JType.Char, "getCharacterValue");
        method.addParameter(new JParameter((JType)new JClass("String"), "s"));
        method.addParameter(new JParameter((JType)new JClass("String"), "attribute"));
        sc = method.getSourceCode();
        sc.add("if ( s != null )");
        sc.add("{");
        sc.indent();
        sc.add("return s.charAt( 0 );");
        sc.unindent();
        sc.add("}");
        sc.add("return 0;");
        jClass.addMethod(method);
        method = new JMethod(JType.Int, "getIntegerValue");
        method.addParameter(new JParameter((JType)new JClass("String"), "s"));
        method.addParameter(new JParameter((JType)new JClass("String"), "attribute"));
        method.addParameter(new JParameter(JClass.Boolean, "strict"));
        method.addException(new JClass("DocumentException"));
        sc = method.getSourceCode();
        this.convertNumericalType(sc, "Integer.valueOf( s ).intValue()", "an integer");
        jClass.addMethod(method);
        method = new JMethod(JType.Short, "getShortValue");
        method.addParameter(new JParameter((JType)new JClass("String"), "s"));
        method.addParameter(new JParameter((JType)new JClass("String"), "attribute"));
        method.addParameter(new JParameter(JClass.Boolean, "strict"));
        method.addException(new JClass("DocumentException"));
        sc = method.getSourceCode();
        this.convertNumericalType(sc, "Short.valueOf( s ).shortValue()", "a short integer");
        jClass.addMethod(method);
        method = new JMethod(JType.Byte, "getByteValue");
        method.addParameter(new JParameter((JType)new JClass("String"), "s"));
        method.addParameter(new JParameter((JType)new JClass("String"), "attribute"));
        method.addParameter(new JParameter(JClass.Boolean, "strict"));
        method.addException(new JClass("DocumentException"));
        sc = method.getSourceCode();
        this.convertNumericalType(sc, "Byte.valueOf( s ).byteValue()", "a byte");
        jClass.addMethod(method);
        method = new JMethod(JType.Long, "getLongValue");
        method.addParameter(new JParameter((JType)new JClass("String"), "s"));
        method.addParameter(new JParameter((JType)new JClass("String"), "attribute"));
        method.addParameter(new JParameter(JClass.Boolean, "strict"));
        method.addException(new JClass("DocumentException"));
        sc = method.getSourceCode();
        this.convertNumericalType(sc, "Long.valueOf( s ).longValue()", "a long integer");
        jClass.addMethod(method);
        method = new JMethod(JType.Float, "getFloatValue");
        method.addParameter(new JParameter((JType)new JClass("String"), "s"));
        method.addParameter(new JParameter((JType)new JClass("String"), "attribute"));
        method.addParameter(new JParameter(JClass.Boolean, "strict"));
        method.addException(new JClass("DocumentException"));
        sc = method.getSourceCode();
        this.convertNumericalType(sc, "Float.valueOf( s ).floatValue()", "a floating point number");
        jClass.addMethod(method);
        method = new JMethod(JType.Double, "getDoubleValue");
        method.addParameter(new JParameter((JType)new JClass("String"), "s"));
        method.addParameter(new JParameter((JType)new JClass("String"), "attribute"));
        method.addParameter(new JParameter(JClass.Boolean, "strict"));
        method.addException(new JClass("DocumentException"));
        sc = method.getSourceCode();
        this.convertNumericalType(sc, "Double.valueOf( s ).doubleValue()", "a floating point number");
        jClass.addMethod(method);
        method = new JMethod((JType)new JClass("java.util.Date"), "getDateValue");
        method.addParameter(new JParameter((JType)new JClass("String"), "s"));
        method.addParameter(new JParameter((JType)new JClass("String"), "attribute"));
        method.addParameter(new JParameter((JType)new JClass("String"), "dateFormat"));
        method.addException(new JClass("DocumentException"));
        sc = method.getSourceCode();
        sc.add("if ( s != null )");
        sc.add("{");
        sc.indent();
        sc.add("DateFormat dateParser;");
        sc.add("if ( dateFormat == null )");
        sc.add("{");
        sc.indent();
        sc.add("dateParser = DateFormat.getDateTimeInstance( DateFormat.FULL, DateFormat.FULL , Locale.US );");
        sc.add("dateParser.setLenient( true );");
        sc.unindent();
        sc.add("} else {");
        sc.indent();
        sc.add("dateParser = new java.text.SimpleDateFormat( dateFormat, Locale.US );");
        sc.unindent();
        sc.add("}");
        sc.add("try");
        sc.add("{");
        sc.indent();
        sc.add("return dateParser.parse( s );");
        sc.unindent();
        sc.add("}");
        sc.add("catch ( java.text.ParseException e )");
        sc.add("{");
        sc.indent();
        sc.add("throw new DocumentException( e.getMessage() );");
        sc.unindent();
        sc.add("}");
        sc.unindent();
        sc.add("}");
        sc.add("return null;");
        jClass.addMethod(method);
        method = new JMethod((JType)new JClass("Xpp3Dom"), "writeElementToXpp3Dom");
        method.addParameter(new JParameter((JType)new JClass("Element"), "element"));
        sc = method.getSourceCode();
        sc.add("Xpp3Dom xpp3Dom = new Xpp3Dom( element.getName() );");
        sc.add("if ( element.elements().isEmpty() && element.getText() != null )");
        sc.add("{");
        sc.indent();
        sc.add("xpp3Dom.setValue( element.getText() );");
        sc.unindent();
        sc.add("}");
        sc.add("for ( Iterator i = element.attributeIterator(); i.hasNext(); )");
        sc.add("{");
        sc.indent();
        sc.add("Attribute attribute = (Attribute) i.next();");
        sc.add("xpp3Dom.setAttribute( attribute.getName(), attribute.getValue() );");
        sc.unindent();
        sc.add("}");
        sc.add("for ( Iterator i = element.elementIterator(); i.hasNext(); )");
        sc.add("{");
        sc.indent();
        sc.add("Element child = (Element) i.next();");
        sc.add("xpp3Dom.addChild( writeElementToXpp3Dom( child ) );");
        sc.unindent();
        sc.add("}");
        sc.add("return xpp3Dom;");
        jClass.addMethod(method);
    }

    private void convertNumericalType(JSourceCode sc, String expression, String typeDesc) {
        sc.add("if ( s != null )");
        sc.add("{");
        sc.indent();
        sc.add("try");
        sc.add("{");
        sc.indent();
        sc.add("return " + expression + ";");
        sc.unindent();
        sc.add("}");
        sc.add("catch ( NumberFormatException e )");
        sc.add("{");
        sc.indent();
        sc.add("if ( strict )");
        sc.add("{");
        sc.indent();
        sc.add("throw new DocumentException( \"Unable to parse element '\" + attribute + \"', must be " + typeDesc + "\" );");
        sc.unindent();
        sc.add("}");
        sc.unindent();
        sc.add("}");
        sc.unindent();
        sc.add("}");
        sc.add("return 0;");
    }
}

