/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.maven;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.modello:modello-maven-plugin:1.0", 0);
        this.append(sb, "", 0);
        this.append(sb, "Modello Maven Plugin 1.0", 0);
        this.append(sb, "Modello Maven Plugin enables the use of Modello in Maven builds.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 13 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "converters".equals(this.goal)) {
            this.append(sb, "modello:converters", 0);
            this.append(sb, "Creates classes that can convert between different versions of the model.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "basedir", 2);
                this.append(sb, "Base directory of the project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "The encoding to use when generating Java source files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "models", 2);
                this.append(sb, "List of relative paths to mdo files containing the models.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "The output directory of the generated Java beans.", 3);
                this.append(sb, "", 0);
                this.append(sb, "packageWithVersion (Default: false)", 2);
                this.append(sb, "True if the generated package names should include the version.", 3);
                this.append(sb, "", 0);
                this.append(sb, "packagedVersions", 2);
                this.append(sb, "Additional historical versions to generate, each being packaged with the version regardless of the packageWithVersion setting.", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "The Maven project instance for the executing project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useJava5 (Default: false)", 2);
                this.append(sb, "Generate Java 5 sources, with generic collections.", 3);
                this.append(sb, "", 0);
                this.append(sb, "version", 2);
                this.append(sb, "The version of the model we will be working on.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "dom4j-reader".equals(this.goal)) {
            this.append(sb, "modello:dom4j-reader", 0);
            this.append(sb, "Creates a DOM4J reader from the model.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "basedir", 2);
                this.append(sb, "Base directory of the project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "The encoding to use when generating Java source files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "models", 2);
                this.append(sb, "List of relative paths to mdo files containing the models.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "The output directory of the generated DOM4J reader.", 3);
                this.append(sb, "", 0);
                this.append(sb, "packageWithVersion (Default: false)", 2);
                this.append(sb, "True if the generated package names should include the version.", 3);
                this.append(sb, "", 0);
                this.append(sb, "packagedVersions", 2);
                this.append(sb, "Additional historical versions to generate, each being packaged with the version regardless of the packageWithVersion setting.", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "The Maven project instance for the executing project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useJava5 (Default: false)", 2);
                this.append(sb, "Generate Java 5 sources, with generic collections.", 3);
                this.append(sb, "", 0);
                this.append(sb, "version", 2);
                this.append(sb, "The version of the model we will be working on.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "dom4j-writer".equals(this.goal)) {
            this.append(sb, "modello:dom4j-writer", 0);
            this.append(sb, "Creates a DOM4J writer from the model.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "basedir", 2);
                this.append(sb, "Base directory of the project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "The encoding to use when generating Java source files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "models", 2);
                this.append(sb, "List of relative paths to mdo files containing the models.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "The output directory of the generated DOM4J reader.", 3);
                this.append(sb, "", 0);
                this.append(sb, "packageWithVersion (Default: false)", 2);
                this.append(sb, "True if the generated package names should include the version.", 3);
                this.append(sb, "", 0);
                this.append(sb, "packagedVersions", 2);
                this.append(sb, "Additional historical versions to generate, each being packaged with the version regardless of the packageWithVersion setting.", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "The Maven project instance for the executing project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useJava5 (Default: false)", 2);
                this.append(sb, "Generate Java 5 sources, with generic collections.", 3);
                this.append(sb, "", 0);
                this.append(sb, "version", 2);
                this.append(sb, "The version of the model we will be working on.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "generate".equals(this.goal)) {
            this.append(sb, "modello:generate", 0);
            this.append(sb, "ModelloGenerateMojo - A dynamic way to use generators and modello plugins.\n\nExample Usage:\n\n<plugin>\n<groupId>org.codehaus.modello</groupId>\n<artifactId>modello-maven-plugin</artifactId>\n<version>1.0-alpha-15-SNAPSHOT</version>\n<dependencies>\n<dependency>\n<groupId>org.codehaus.modello</groupId>\n<artifactId>modello-plugin-jpa</artifactId>\n<version>1.0.0-SNAPSHOT</version>\n</dependency>\n</dependencies>\n<configuration>\n<version>1.0.0</version>\n<packageWithVersion>false</packageWithVersion>\n<models>\n<model>src/main/mdo/project-model.xml</model>\n</models>\n</configuration>\n<executions>\n<execution>\n<id>java</id>\n<goals>\n<goal>generate</goal>\n</goals>\n<configuration>\n<generatorId>java</generatorId>\n</configuration>\n</execution>\n<execution>\n<id>jpa</id>\n<goals>\n<goal>generate</goal>\n</goals>\n<configuration>\n<generatorId>jpa-mapping</generatorId>\n</configuration>\n</execution>\n</executions>\n</plugin>\n", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "basedir", 2);
                this.append(sb, "Base directory of the project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "The encoding to use when generating Java source files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generatorId (Default: java)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "models", 2);
                this.append(sb, "List of relative paths to mdo files containing the models.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "The output directory of the generated source files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "packageWithVersion (Default: false)", 2);
                this.append(sb, "True if the generated package names should include the version.", 3);
                this.append(sb, "", 0);
                this.append(sb, "packagedVersions", 2);
                this.append(sb, "Additional historical versions to generate, each being packaged with the version regardless of the packageWithVersion setting.", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "The Maven project instance for the executing project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useJava5 (Default: false)", 2);
                this.append(sb, "Generate Java 5 sources, with generic collections.", 3);
                this.append(sb, "", 0);
                this.append(sb, "version", 2);
                this.append(sb, "The version of the model we will be working on.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "modello:help", 0);
            this.append(sb, "Display help information on modello-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0modello:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "java".equals(this.goal)) {
            this.append(sb, "modello:java", 0);
            this.append(sb, "Creates Java beans from the Modello model.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "basedir", 2);
                this.append(sb, "Base directory of the project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "The encoding to use when generating Java source files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "models", 2);
                this.append(sb, "List of relative paths to mdo files containing the models.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "The output directory of the generated Java beans.", 3);
                this.append(sb, "", 0);
                this.append(sb, "packageWithVersion (Default: false)", 2);
                this.append(sb, "True if the generated package names should include the version.", 3);
                this.append(sb, "", 0);
                this.append(sb, "packagedVersions", 2);
                this.append(sb, "Additional historical versions to generate, each being packaged with the version regardless of the packageWithVersion setting.", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "The Maven project instance for the executing project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useJava5 (Default: false)", 2);
                this.append(sb, "Generate Java 5 sources, with generic collections.", 3);
                this.append(sb, "", 0);
                this.append(sb, "version", 2);
                this.append(sb, "The version of the model we will be working on.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "jdom-writer".equals(this.goal)) {
            this.append(sb, "modello:jdom-writer", 0);
            this.append(sb, "Creates a jdom writer from the model that is capable of preserving element ordering and comments. In future it should also preserve whitespace.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "basedir", 2);
                this.append(sb, "Base directory of the project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "The encoding to use when generating Java source files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "models", 2);
                this.append(sb, "List of relative paths to mdo files containing the models.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "The output directory of the generated jdom writer.", 3);
                this.append(sb, "", 0);
                this.append(sb, "packageWithVersion (Default: false)", 2);
                this.append(sb, "True if the generated package names should include the version.", 3);
                this.append(sb, "", 0);
                this.append(sb, "packagedVersions", 2);
                this.append(sb, "Additional historical versions to generate, each being packaged with the version regardless of the packageWithVersion setting.", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "The Maven project instance for the executing project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useJava5 (Default: false)", 2);
                this.append(sb, "Generate Java 5 sources, with generic collections.", 3);
                this.append(sb, "", 0);
                this.append(sb, "version", 2);
                this.append(sb, "The version of the model we will be working on.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "stax-reader".equals(this.goal)) {
            this.append(sb, "modello:stax-reader", 0);
            this.append(sb, "Creates an StAX reader from the model.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "basedir", 2);
                this.append(sb, "Base directory of the project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "The encoding to use when generating Java source files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "models", 2);
                this.append(sb, "List of relative paths to mdo files containing the models.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "The output directory of the generated StAX reader.", 3);
                this.append(sb, "", 0);
                this.append(sb, "packageWithVersion (Default: false)", 2);
                this.append(sb, "True if the generated package names should include the version.", 3);
                this.append(sb, "", 0);
                this.append(sb, "packagedVersions", 2);
                this.append(sb, "Additional historical versions to generate, each being packaged with the version regardless of the packageWithVersion setting.", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "The Maven project instance for the executing project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useJava5 (Default: false)", 2);
                this.append(sb, "Generate Java 5 sources, with generic collections.", 3);
                this.append(sb, "", 0);
                this.append(sb, "version", 2);
                this.append(sb, "The version of the model we will be working on.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "stax-writer".equals(this.goal)) {
            this.append(sb, "modello:stax-writer", 0);
            this.append(sb, "Creates an StAX writer from the model.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "basedir", 2);
                this.append(sb, "Base directory of the project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "The encoding to use when generating Java source files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "models", 2);
                this.append(sb, "List of relative paths to mdo files containing the models.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "The output directory of the generated StAX writer.", 3);
                this.append(sb, "", 0);
                this.append(sb, "packageWithVersion (Default: false)", 2);
                this.append(sb, "True if the generated package names should include the version.", 3);
                this.append(sb, "", 0);
                this.append(sb, "packagedVersions", 2);
                this.append(sb, "Additional historical versions to generate, each being packaged with the version regardless of the packageWithVersion setting.", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "The Maven project instance for the executing project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useJava5 (Default: false)", 2);
                this.append(sb, "Generate Java 5 sources, with generic collections.", 3);
                this.append(sb, "", 0);
                this.append(sb, "version", 2);
                this.append(sb, "The version of the model we will be working on.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "xdoc".equals(this.goal)) {
            this.append(sb, "modello:xdoc", 0);
            this.append(sb, "Creates documentation for the model in xdoc format.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "basedir", 2);
                this.append(sb, "Base directory of the project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "The encoding to use when generating Java source files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "firstVersion", 2);
                this.append(sb, "The first version of the model. This is used to decide whether or not to show the since column. If this is not specified, it defaults to the version of the model, which in turn means that the since column will not be shown.", 3);
                this.append(sb, "", 0);
                this.append(sb, "models", 2);
                this.append(sb, "List of relative paths to mdo files containing the models.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "The output directory of the generated documentation.", 3);
                this.append(sb, "", 0);
                this.append(sb, "packageWithVersion (Default: false)", 2);
                this.append(sb, "True if the generated package names should include the version.", 3);
                this.append(sb, "", 0);
                this.append(sb, "packagedVersions", 2);
                this.append(sb, "Additional historical versions to generate, each being packaged with the version regardless of the packageWithVersion setting.", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "The Maven project instance for the executing project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useJava5 (Default: false)", 2);
                this.append(sb, "Generate Java 5 sources, with generic collections.", 3);
                this.append(sb, "", 0);
                this.append(sb, "version", 2);
                this.append(sb, "The version of the model we will be working on.", 3);
                this.append(sb, "", 0);
                this.append(sb, "xdocFileName", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "xpp3-reader".equals(this.goal)) {
            this.append(sb, "modello:xpp3-reader", 0);
            this.append(sb, "Creates an XPP3 reader from the model.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "basedir", 2);
                this.append(sb, "Base directory of the project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "The encoding to use when generating Java source files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "models", 2);
                this.append(sb, "List of relative paths to mdo files containing the models.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "The output directory of the generated XPP reader.", 3);
                this.append(sb, "", 0);
                this.append(sb, "packageWithVersion (Default: false)", 2);
                this.append(sb, "True if the generated package names should include the version.", 3);
                this.append(sb, "", 0);
                this.append(sb, "packagedVersions", 2);
                this.append(sb, "Additional historical versions to generate, each being packaged with the version regardless of the packageWithVersion setting.", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "The Maven project instance for the executing project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useJava5 (Default: false)", 2);
                this.append(sb, "Generate Java 5 sources, with generic collections.", 3);
                this.append(sb, "", 0);
                this.append(sb, "version", 2);
                this.append(sb, "The version of the model we will be working on.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "xpp3-writer".equals(this.goal)) {
            this.append(sb, "modello:xpp3-writer", 0);
            this.append(sb, "Creates an XPP3 writer from the model.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "basedir", 2);
                this.append(sb, "Base directory of the project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "The encoding to use when generating Java source files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "models", 2);
                this.append(sb, "List of relative paths to mdo files containing the models.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "The output directory of the generated XPP writer.", 3);
                this.append(sb, "", 0);
                this.append(sb, "packageWithVersion (Default: false)", 2);
                this.append(sb, "True if the generated package names should include the version.", 3);
                this.append(sb, "", 0);
                this.append(sb, "packagedVersions", 2);
                this.append(sb, "Additional historical versions to generate, each being packaged with the version regardless of the packageWithVersion setting.", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "The Maven project instance for the executing project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useJava5 (Default: false)", 2);
                this.append(sb, "Generate Java 5 sources, with generic collections.", 3);
                this.append(sb, "", 0);
                this.append(sb, "version", 2);
                this.append(sb, "The version of the model we will be working on.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "xsd".equals(this.goal)) {
            this.append(sb, "modello:xsd", 0);
            this.append(sb, "Creates an XML schema from the model.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "basedir", 2);
                this.append(sb, "Base directory of the project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "The encoding to use when generating Java source files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "models", 2);
                this.append(sb, "List of relative paths to mdo files containing the models.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "The output directory of the generated XML Schema. Hint: if you want to publish the schema automatically with the site, configure this parameter to ${basedir}/target/generated-site/resources/xsd.", 3);
                this.append(sb, "", 0);
                this.append(sb, "packageWithVersion (Default: false)", 2);
                this.append(sb, "True if the generated package names should include the version.", 3);
                this.append(sb, "", 0);
                this.append(sb, "packagedVersions", 2);
                this.append(sb, "Additional historical versions to generate, each being packaged with the version regardless of the packageWithVersion setting.", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "The Maven project instance for the executing project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useJava5 (Default: false)", 2);
                this.append(sb, "Generate Java 5 sources, with generic collections.", 3);
                this.append(sb, "", 0);
                this.append(sb, "version", 2);
                this.append(sb, "The version of the model we will be working on.", 3);
                this.append(sb, "", 0);
                this.append(sb, "xsdFileName", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

