/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.introspect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import org.codehaus.jackson.map.introspect.Annotated;
import org.codehaus.jackson.map.introspect.AnnotationMap;
import org.codehaus.jackson.map.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotatedField
extends Annotated {
    final Field _field;
    final AnnotationMap _annotations;

    public AnnotatedField(Field field, AnnotationMap annMap) {
        this._field = field;
        this._annotations = annMap;
    }

    public void addOrOverride(Annotation a) {
        this._annotations.add(a);
    }

    @Override
    public Field getAnnotated() {
        return this._field;
    }

    @Override
    public int getModifiers() {
        return this._field.getModifiers();
    }

    @Override
    public String getName() {
        return this._field.getName();
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> acls) {
        return this._annotations.get(acls);
    }

    @Override
    public Class<?> getType() {
        return this._field.getType();
    }

    public Type getGenericType() {
        return this._field.getGenericType();
    }

    public Class<?> getDeclaringClass() {
        return this._field.getDeclaringClass();
    }

    public String getFullName() {
        return this.getDeclaringClass().getName() + "#" + this.getName();
    }

    public int getAnnotationCount() {
        return this._annotations.size();
    }

    public void fixAccess() {
        ClassUtil.checkAndFixAccess(this._field);
    }

    public String toString() {
        return "[field " + this.getName() + ", annotations: " + this._annotations + "]";
    }
}

