/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map;

import java.text.DateFormat;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.BeanDescription;
import org.codehaus.jackson.map.ClassIntrospector;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.map.introspect.AnnotatedClass;
import org.codehaus.jackson.map.util.StdDateFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializationConfig {
    protected static final int DEFAULT_FEATURE_FLAGS = Feature.collectDefaults();
    protected ClassIntrospector<? extends BeanDescription> _classIntrospector;
    protected AnnotationIntrospector _annotationIntrospector;
    protected int _featureFlags = DEFAULT_FEATURE_FLAGS;
    protected DateFormat _dateFormat = StdDateFormat.instance;
    protected JsonSerialize.Inclusion _serializationInclusion = null;

    public SerializationConfig(ClassIntrospector<? extends BeanDescription> intr, AnnotationIntrospector annIntr) {
        this._classIntrospector = intr;
        this._annotationIntrospector = annIntr;
    }

    protected SerializationConfig(SerializationConfig src) {
        this._classIntrospector = src._classIntrospector;
        this._annotationIntrospector = src._annotationIntrospector;
        this._featureFlags = src._featureFlags;
        this._dateFormat = src._dateFormat;
        this._serializationInclusion = src._serializationInclusion;
    }

    public SerializationConfig createUnshared() {
        return new SerializationConfig(this);
    }

    public void fromAnnotations(Class<?> cls) {
        JsonSerialize.Inclusion incl;
        AnnotatedClass ac = AnnotatedClass.construct(cls, this._annotationIntrospector);
        Boolean ad = this._annotationIntrospector.findGetterAutoDetection(ac);
        if (ad != null) {
            this.set(Feature.AUTO_DETECT_GETTERS, ad);
        }
        if ((incl = this._annotationIntrospector.findSerializationInclusion(ac, null)) != this._serializationInclusion) {
            this.setSerializationInclusion(incl);
        }
    }

    public final boolean isEnabled(Feature f) {
        return (this._featureFlags & f.getMask()) != 0;
    }

    public DateFormat getDateFormat() {
        return this._dateFormat;
    }

    public JsonSerialize.Inclusion getSerializationInclusion() {
        if (this._serializationInclusion != null) {
            return this._serializationInclusion;
        }
        return this.isEnabled(Feature.WRITE_NULL_PROPERTIES) ? JsonSerialize.Inclusion.ALWAYS : JsonSerialize.Inclusion.NON_NULL;
    }

    public AnnotationIntrospector getAnnotationIntrospector() {
        return this._annotationIntrospector;
    }

    public <T extends BeanDescription> T introspect(Class<?> cls) {
        return (T)this._classIntrospector.forSerialization(this, cls);
    }

    public <T extends BeanDescription> T introspectClassAnnotations(Class<?> cls) {
        return (T)this._classIntrospector.forClassAnnotations(this, cls);
    }

    public void enable(Feature f) {
        this._featureFlags |= f.getMask();
    }

    public void disable(Feature f) {
        this._featureFlags &= ~f.getMask();
    }

    public void set(Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
    }

    public void setSerializationInclusion(JsonSerialize.Inclusion props) {
        this._serializationInclusion = props;
        if (props == JsonSerialize.Inclusion.NON_NULL) {
            this.disable(Feature.WRITE_NULL_PROPERTIES);
        } else {
            this.enable(Feature.WRITE_NULL_PROPERTIES);
        }
    }

    public void setDateFormat(DateFormat df) {
        this._dateFormat = df;
        this.set(Feature.WRITE_DATES_AS_TIMESTAMPS, df == null);
    }

    public void setIntrospector(ClassIntrospector<? extends BeanDescription> i) {
        this._classIntrospector = i;
    }

    public void setAnnotationIntrospector(AnnotationIntrospector ai) {
        this._annotationIntrospector = ai;
    }

    public String toString() {
        return "[SerializationConfig: flags=0x" + Integer.toHexString(this._featureFlags) + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Feature {
        AUTO_DETECT_GETTERS(true),
        AUTO_DETECT_FIELDS(true),
        CAN_OVERRIDE_ACCESS_MODIFIERS(true),
        WRITE_NULL_PROPERTIES(true),
        WRITE_DATES_AS_TIMESTAMPS(true),
        INDENT_OUTPUT(false);

        final boolean _defaultState;

        public static int collectDefaults() {
            int flags = 0;
            for (Feature f : Feature.values()) {
                if (!f.enabledByDefault()) continue;
                flags |= f.getMask();
            }
            return flags;
        }

        private Feature(boolean defaultState) {
            this._defaultState = defaultState;
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public int getMask() {
            return 1 << this.ordinal();
        }
    }
}

