/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.jdt.groovy.model.GroovyClassFileWorkingCopy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.search.MethodReferenceMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.internal.core.search.matching.ConstructorPattern;
import org.eclipse.jdt.internal.core.util.Util;

public class ConstructorReferenceSearchRequestor
implements ITypeRequestor {
    private final SearchRequestor requestor;
    private final SearchParticipant participant;
    private final String declaringQualifiedName;
    private final String simpleName;

    public ConstructorReferenceSearchRequestor(ConstructorPattern pattern, SearchRequestor requestor, SearchParticipant participant) {
        this.requestor = requestor;
        this.participant = participant;
        this.simpleName = String.valueOf(pattern.declaringSimpleName);
        this.declaringQualifiedName = pattern.declaringQualification != null && pattern.declaringQualification.length > 0 ? String.valueOf(String.valueOf(pattern.declaringQualification)) + '.' + this.simpleName : this.simpleName;
    }

    public ITypeRequestor.VisitStatus acceptASTNode(ASTNode node, TypeLookupResult result, IJavaElement enclosingElement) {
        if (!(node instanceof ConstructorCallExpression) || node.getEnd() <= 0) {
            return ITypeRequestor.VisitStatus.CONTINUE;
        }
        ConstructorCallExpression ccexpr = (ConstructorCallExpression)node;
        ClassNode declaring = ccexpr.getType();
        if (declaring.getName().equals(this.declaringQualifiedName)) {
            IJavaElement realElement = enclosingElement.getOpenable() instanceof GroovyClassFileWorkingCopy ? ((GroovyClassFileWorkingCopy)enclosingElement.getOpenable()).convertToBinary(enclosingElement) : enclosingElement;
            MethodReferenceMatch match = null;
            match = new MethodReferenceMatch(realElement, 0, declaring.getStart(), declaring.getLength(), true, false, false, false, this.participant, realElement.getResource());
            try {
                this.requestor.acceptSearchMatch(match);
            }
            catch (CoreException e) {
                Util.log(e, "Error reporting search match inside of " + realElement + " in resource " + realElement.getResource());
            }
        }
        return ITypeRequestor.VisitStatus.CONTINUE;
    }
}

