/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.internal.compiler.ast;

import java.util.List;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTAnnotationNode;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTNode;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTResolver;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDTMethodNode
extends MethodNode
implements JDTNode {
    private MethodBinding methodBinding;
    private JDTResolver resolver;
    private int bits = 0;

    public JDTMethodNode(MethodBinding methodBinding, JDTResolver resolver, String name, int modifiers, ClassNode returnType, Parameter[] gParameters, ClassNode[] thrownExceptions, Statement object) {
        super(name, modifiers, returnType, gParameters, thrownExceptions, object);
        this.resolver = resolver;
        this.methodBinding = methodBinding;
    }

    @Override
    public void addAnnotation(AnnotationNode value) {
        System.err.println("Unexpected: Trying to add an annotation " + value.getClassNode().getName() + " to an immutable method node " + this.toString());
    }

    public void addAnnotations(List annotations) {
        this.throwImmutableException();
    }

    @Override
    public List<AnnotationNode> getAnnotations() {
        this.ensureAnnotationsInitialized();
        return super.getAnnotations();
    }

    @Override
    public List<AnnotationNode> getAnnotations(ClassNode type) {
        this.ensureAnnotationsInitialized();
        return super.getAnnotations(type);
    }

    private void ensureAnnotationsInitialized() {
        if ((this.bits & 1) == 0) {
            AnnotationBinding[] annotationBindings;
            AnnotationBinding[] annotationBindingArray = annotationBindings = this.methodBinding.getAnnotations();
            int n = annotationBindings.length;
            int n2 = 0;
            while (n2 < n) {
                AnnotationBinding annotationBinding = annotationBindingArray[n2];
                super.addAnnotation(new JDTAnnotationNode(annotationBinding, this.resolver));
                ++n2;
            }
            this.bits |= 1;
        }
    }

    private void throwImmutableException() {
        throw new IllegalStateException("JDTMethodNode is immutable");
    }

    @Override
    public JDTResolver getResolver() {
        return this.resolver;
    }

    public MethodBinding getMethodBinding() {
        return this.methodBinding;
    }

    @Override
    public Binding getJdtBinding() {
        return this.methodBinding;
    }

    @Override
    public boolean isDeprecated() {
        return this.methodBinding.isDeprecated();
    }
}

