/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import org.exolab.castor.xml.AttributeSet;
import org.exolab.castor.xml.Namespaces;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.AppInfo;
import org.exolab.castor.xml.schema.Documentation;
import org.exolab.castor.xml.schema.SchemaContext;
import org.exolab.castor.xml.schema.reader.AppInfoUnmarshaller;
import org.exolab.castor.xml.schema.reader.ComponentReader;
import org.exolab.castor.xml.schema.reader.DocumentationUnmarshaller;

public class AnnotationUnmarshaller
extends ComponentReader {
    private ComponentReader unmarshaller;
    private int depth = 0;
    private Annotation _annotation = new Annotation();

    public AnnotationUnmarshaller(SchemaContext schemaContext, AttributeSet atts) throws XMLException {
        super(schemaContext);
        if (atts != null && atts.getSize() > 0) {
            for (int i = 0; i < atts.getSize(); ++i) {
                String namespace = atts.getNamespace(i);
                if (!namespace.equals("http://www.w3.org/2001/XMLSchema")) continue;
                this.illegalAttribute(atts.getName(i));
            }
        }
    }

    public String elementName() {
        return "annotation";
    }

    public Annotation getAnnotation() {
        return this._annotation;
    }

    public Object getObject() {
        return this.getAnnotation();
    }

    public void startElement(String name, String namespace, AttributeSet atts, Namespaces nsDecls) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.startElement(name, namespace, atts, nsDecls);
            ++this.depth;
            return;
        }
        if ("appinfo".equals(name)) {
            this.unmarshaller = new AppInfoUnmarshaller(this.getSchemaContext(), atts);
        } else if ("documentation".equals(name)) {
            this.unmarshaller = new DocumentationUnmarshaller(this.getSchemaContext(), atts);
        } else {
            this.illegalElement(name);
        }
    }

    public void endElement(String name, String namespace) throws XMLException {
        if (this.unmarshaller != null && this.depth > 0) {
            this.unmarshaller.endElement(name, namespace);
            --this.depth;
            return;
        }
        this.unmarshaller.finish();
        if ("appinfo".equals(name)) {
            this._annotation.addAppInfo((AppInfo)this.unmarshaller.getObject());
        } else {
            this._annotation.addDocumentation((Documentation)this.unmarshaller.getObject());
        }
        this.unmarshaller = null;
    }

    public void characters(char[] ch, int start, int length) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.characters(ch, start, length);
        }
    }
}

