/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.services;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.votecounting.business.Choice;
import org.chorem.pollen.votecounting.business.CondorcetMethod;
import org.chorem.pollen.votecounting.business.Context;
import org.chorem.pollen.votecounting.business.Group;
import org.chorem.pollen.votecounting.business.Method;
import org.chorem.pollen.votecounting.business.NumberMethod;
import org.chorem.pollen.votecounting.business.PercentageMethod;
import org.chorem.pollen.votecounting.business.StandardMethod;
import org.chorem.pollen.votecounting.dto.ChoiceDTO;
import org.chorem.pollen.votecounting.dto.PollChoiceDTO;
import org.chorem.pollen.votecounting.dto.PollDTO;
import org.chorem.pollen.votecounting.dto.VoteCountingResultDTO;
import org.chorem.pollen.votecounting.dto.VoteToChoiceDTO;
import org.chorem.pollen.votecounting.dto.VotingGroupDTO;
import org.chorem.pollen.votecounting.dto.VotingPersonDTO;
import org.chorem.pollen.votecounting.services.ServiceVoteCounting;
import org.chorem.pollen.votecounting.utils.Utils;

public class ServiceVoteCountingImpl
implements ServiceVoteCounting {
    private String currentIdGroup = "";
    private boolean isByGroup;
    private Context context = null;
    private static final Log log = LogFactory.getLog(ServiceVoteCountingImpl.class);

    @Override
    public VoteCountingResultDTO executeVoteCounting(PollDTO poll) {
        this.isByGroup = false;
        return this.execute(poll);
    }

    @Override
    public VoteCountingResultDTO executeGroupCounting(PollDTO poll) {
        this.isByGroup = true;
        return this.execute(poll);
    }

    private VoteCountingResultDTO execute(PollDTO poll) {
        if (log.isInfoEnabled()) {
            log.info((Object)("D\u00e9pouillement (byGroup=" + this.isByGroup + ") du sondage " + poll.getPollId()));
        }
        this.createContext(poll.getVoteCounting());
        this.fillContext(poll);
        if (!this.context.executeCounting()) {
            return null;
        }
        List<ChoiceDTO> resChoices = this.context.executeStats();
        VoteCountingResultDTO result = new VoteCountingResultDTO();
        result.setNbVotes(Utils.calculateNbVotes(poll.getVotingGroups(), this.isByGroup));
        result.setTypeVoteCounting(poll.getVoteCounting());
        result.setByGroup(this.isByGroup);
        result.setIdPoll(poll.getPollId());
        result.setChoices(resChoices);
        return result;
    }

    private void createContext(int type) {
        Method method = null;
        switch (type) {
            case 0: {
                method = new StandardMethod();
                break;
            }
            case 1: {
                method = new PercentageMethod();
                break;
            }
            case 2: {
                method = new CondorcetMethod();
                break;
            }
            case 3: {
                method = new NumberMethod();
                break;
            }
            default: {
                method = new StandardMethod();
            }
        }
        this.context = new Context(method, this.isByGroup);
    }

    private void fillContext(PollDTO poll) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Ajout poll : " + poll.getPollId()));
        }
        for (PollChoiceDTO pollChoiceDTO : poll.getChoices()) {
            if (pollChoiceDTO.isHidden()) {
                this.context.addHiddenChoice(pollChoiceDTO);
                continue;
            }
            this.context.addChoice(pollChoiceDTO);
        }
        for (Object object : poll.getVotingGroups()) {
            VotingGroupDTO group = (VotingGroupDTO)object;
            this.routeGroup(group);
        }
    }

    private void routeGroup(VotingGroupDTO group) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Ajout group : " + group.getIdGroup() + " _ weight=" + group.getWeight()));
        }
        this.context.addGroup(group.getIdGroup(), group.getWeight());
        Iterator<VotingPersonDTO> i$ = group.getVotingPersons().iterator();
        while (i$.hasNext()) {
            VotingPersonDTO o;
            VotingPersonDTO person = o = i$.next();
            this.currentIdGroup = group.getIdGroup();
            this.routePerson(person);
        }
    }

    private void routePerson(VotingPersonDTO person) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Ajout person : " + person.getVotingId() + " _ weight=" + person.getWeight()));
        }
        for (VoteToChoiceDTO vote : person.getChoices()) {
            this.addVoteToContext(vote, person.getWeight(), person.getVotingId());
        }
    }

    private void addVoteToContext(VoteToChoiceDTO vote, double weight, String votingID) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Ajout vote : " + vote.getValue() + " _ choice=" + vote.getIdChoice()));
        }
        Choice choice = this.context.getChoice(vote.getIdChoice());
        Group group = choice.getGroup(this.currentIdGroup);
        group.addVote(vote.getValue(), weight, votingID);
    }
}

