/*
 * #%L
 * Pollen :: Vote Counting
 * $Id: PollType.java 3423 2012-06-05 16:50:22Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.4.5.1/pollen-votecounting/src/main/java/org/chorem/pollen/common/PollType.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.common;

import static org.nuiton.i18n.I18n.n_;

public enum PollType implements I18nAble {

    FREE(n_("pollen.pollType.free")),
    RESTRICTED(n_("pollen.pollType.restricted")),
    GROUP(n_("pollen.pollType.group"));

    private final String i18nKey;

    PollType(String i18nKey) {
        this.i18nKey = i18nKey;
    }

    @Override
    public String getI18nKey() {
        return i18nKey;
    }

    public static PollType valueOf(int ordinal) {
        PollType result = null;
        for (PollType curr : PollType.values()) {
            if (curr.ordinal() == ordinal) {
                result = curr;
                break;
            }
        }
        return result;
    }
}
