/*
 * #%L
 * Pollen :: Vote Counting
 * 
 * $Id: NumberMethod.java 3122 2012-01-30 20:43:30Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3/pollen-votecounting/src/main/java/org/chorem/pollen/votecounting/business/NumberMethod.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.votecounting.business;

import java.util.List;

import org.chorem.pollen.votecounting.dto.ChoiceDTO;

/**
 * Méthode de dépouillement pour vote de type number.
 * 
 * @version $Revision: 3122 $ $Date: 2012-01-30 21:43:30 +0100 (Mon, 30 Jan 2012) $
 * @since 1.2.2
 */
public class NumberMethod implements Method {

    /** Permet de rajouter des choix cachés */
    public static final String HIDDEN_PREFIX = "HIDDEN_";

    @Override
    public void executeCounting(List<Choice> choices, boolean byGroup) {
    
        for (Choice choice : choices) {
            double totalChoice = 0.;
            
            for (Group group : choice.getGroups()) {
                double totalGroup = 0.;
                
                for (Vote vote : group.getVotes()) {
                    double value = vote.getValue();
                    
                    if (value >= 0) {
                        if (byGroup) {
                            totalGroup += vote.getValue() * vote.getWeight() * group.getWeight();
                        } else {
                            totalGroup += vote.getValue() * vote.getWeight();
                        }
                    }
                }
                
                group.setValue(totalGroup);
                totalChoice += totalGroup;
            }
            
            choice.setValue(totalChoice);
        }
    }
    
    @Override
    public void executeStats(List<Choice> choices, boolean groupCounting,
            Choice choice, ChoiceDTO choiceDTO) {

        int nbBlankVotes = 0;
        double average = 0;
        int nbVotes = 0;
        
        for (Group group : choice.getGroups()) {
            for (Vote vote : group.getVotes()) {
                nbVotes = nbVotes + 1;
                if (vote.getValue() < 0) {
                    nbBlankVotes = nbBlankVotes + 1;
                }
            }
        }
    
        if (nbVotes - nbBlankVotes > 0) {
            average = choice.value() / (nbVotes - nbBlankVotes);
        }
        
        choiceDTO.setAverage(average);
        choiceDTO.setNbBlankVotes(nbBlankVotes);
    }
}
