/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting;

import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.votecounting.AbstractVoteCountingStrategy;
import org.chorem.pollen.votecounting.model.ChoiceScore;
import org.chorem.pollen.votecounting.model.VoteCountingResult;
import org.chorem.pollen.votecounting.model.VoteForChoice;
import org.chorem.pollen.votecounting.model.Voter;

public class CondorcetVoteCountingStrategy
extends AbstractVoteCountingStrategy {
    private static final Log log = LogFactory.getLog(CondorcetVoteCountingStrategy.class);

    public VoteCountingResult votecount(Set<Voter> voters) {
        Map scores = this.newEmptyChoiceScoreMap(voters);
        for (Voter voter : voters) {
            this.addVoterChoices(voter, scores);
        }
        VoteCountingResult result = this.orderByValues(scores.values());
        return result;
    }

    protected void addVoterChoices(Voter voter, Map<String, ChoiceScore> scores) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start count for voter " + voter.getVoterId()));
        }
        double voterWeight = voter.getWeight();
        for (VoteForChoice voteForChoiceX : voter.getVoteForChoices()) {
            String choiceIdX = voteForChoiceX.getChoiceId();
            double score = 0.0;
            for (VoteForChoice voteForChoiceY : voter.getVoteForChoices()) {
                int compare;
                if (choiceIdX.equals(voteForChoiceY.getChoiceId()) || (compare = this.voteValueComparator.compare(voteForChoiceX, voteForChoiceY)) >= 0) continue;
                score += voterWeight;
            }
            ChoiceScore choiceScore = scores.get(choiceIdX);
            choiceScore.addScoreValue(score);
        }
    }
}

