/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.service;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Date;
import java.util.Iterator;
import java.util.Optional;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyKeyEncryptionMethodGenerator;
import org.chorem.pollen.persistence.entity.PollenUserEmailAddress;
import org.chorem.pollen.services.PollenTechnicalException;
import org.chorem.pollen.services.service.PollenServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoService
extends PollenServiceSupport {
    private static final Logger log = LoggerFactory.getLogger(CryptoService.class);
    public static final String PROVIDER = "BC";
    static final SecureRandom SECURE_RANDOM = new SecureRandom();

    public PGPPublicKey getPublicKey(String email) {
        PGPPublicKey pgpPublicKey = null;
        Optional<String> publicKeyString = this.getPollenUserEmailAddressDao().forEmailAddressEquals(email).tryFindUnique().map(PollenUserEmailAddress::getPgpPublicKey);
        if (publicKeyString.isPresent()) {
            try {
                ByteArrayInputStream publicKeyInput = new ByteArrayInputStream(publicKeyString.get().getBytes());
                pgpPublicKey = this.readPublicKey(publicKeyInput);
            }
            catch (IOException | PGPException e) {
                throw new PollenTechnicalException("unable to read PGP public key for email : " + email, e);
            }
        }
        return pgpPublicKey;
    }

    protected PGPPublicKey readPublicKey(InputStream input) throws IOException, PGPException {
        PGPPublicKeyRingCollection pgpPub = new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream((InputStream)input), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        Iterator keyRingIter = pgpPub.getKeyRings();
        while (keyRingIter.hasNext()) {
            PGPPublicKeyRing keyRing = (PGPPublicKeyRing)keyRingIter.next();
            Iterator keyIter = keyRing.getPublicKeys();
            while (keyIter.hasNext()) {
                PGPPublicKey key = (PGPPublicKey)keyIter.next();
                if (!key.isEncryptionKey()) continue;
                return key;
            }
        }
        throw new IllegalArgumentException("Can't find encryption key in key ring.");
    }

    protected byte[] compressMessage(byte[] message) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        OutputStream pOut = null;
        PGPCompressedDataGenerator comData = null;
        try {
            comData = new PGPCompressedDataGenerator(1);
            try (OutputStream cos = comData.open((OutputStream)bOut);){
                PGPLiteralDataGenerator lData = new PGPLiteralDataGenerator();
                pOut = lData.open(cos, 'b', "_CONSOLE", (long)message.length, new Date());
                pOut.write(message);
            }
        }
        catch (Exception e) {
            log.error("Unexpected exception", (Throwable)e);
            throw e;
        }
        finally {
            if (pOut != null) {
                pOut.close();
            }
            if (comData != null) {
                comData.close();
            }
        }
        return bOut.toByteArray();
    }

    protected byte[] encryptMessage(byte[] message, PGPPublicKey pgpPublicKey) throws IOException, PGPException {
        byte[] compressMessage = this.compressMessage(message);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ArmoredOutputStream out = null;
        OutputStream encOut = null;
        try {
            out = new ArmoredOutputStream((OutputStream)bout);
            PGPEncryptedDataGenerator encryptedDataGenerator = this.createEncryptedDataGenerator(pgpPublicKey);
            encOut = encryptedDataGenerator.open((OutputStream)out, (long)compressMessage.length);
            encOut.write(compressMessage);
        }
        catch (Exception e) {
            log.error("Unexpected exception", (Throwable)e);
            throw e;
        }
        finally {
            if (encOut != null) {
                encOut.close();
            }
            if (out != null) {
                out.close();
            }
        }
        return bout.toByteArray();
    }

    private PGPEncryptedDataGenerator createEncryptedDataGenerator(PGPPublicKey pgpPublicKey) {
        JcePGPDataEncryptorBuilder encryptorBuilder = new JcePGPDataEncryptorBuilder(3).setSecureRandom(SECURE_RANDOM).setWithIntegrityPacket(true).setProvider(PROVIDER);
        PGPEncryptedDataGenerator encryptedDataGenerator = new PGPEncryptedDataGenerator((PGPDataEncryptorBuilder)encryptorBuilder);
        JcePublicKeyKeyEncryptionMethodGenerator method = new JcePublicKeyKeyEncryptionMethodGenerator(pgpPublicKey).setProvider(PROVIDER).setSecureRandom(SECURE_RANDOM);
        encryptedDataGenerator.addMethod((PGPKeyEncryptionMethodGenerator)method);
        return encryptedDataGenerator;
    }

    public String encryptMailIfAsKey(String body, String email) {
        PGPPublicKey publicKey = this.getPublicKey(email);
        if (publicKey != null) {
            try {
                byte[] encryptMessage = this.encryptMessage(body.getBytes(), publicKey);
                return new String(encryptMessage);
            }
            catch (IOException | PGPException e) {
                if (log.isErrorEnabled()) {
                    log.error("error on encrypte mail to email", e);
                }
                return body;
            }
        }
        return body;
    }

    public byte[] encryptMessageSymmetric(byte[] message) {
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS7Padding", PROVIDER);
            cipher.init(1, this.getSecretKey());
            return cipher.doFinal(message);
        }
        catch (GeneralSecurityException e) {
            throw new PollenTechnicalException("error on encrypt message", e);
        }
    }

    public byte[] decryptMessageSymmetric(byte[] encryptMessage) {
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS7Padding", PROVIDER);
            cipher.init(2, this.getSecretKey());
            return cipher.doFinal(encryptMessage);
        }
        catch (GeneralSecurityException e) {
            throw new PollenTechnicalException("error on decrypt message", e);
        }
    }

    protected SecretKey getSecretKey() {
        byte[] keyBytes = this.getPollenServiceConfig().getTokenSecretBytes();
        return new SecretKeySpec(keyBytes, "AES");
    }

    static {
        if (Security.getProvider(PROVIDER) == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

