/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.service.neogia;

import java.rmi.RemoteException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.dto.AccountDTO;
import org.chorem.lima.service.AccountService;
import org.chorem.lima.service.neogia.AddAccountStub;
import org.chorem.lima.service.neogia.GetAllAccountStub;
import org.chorem.lima.service.neogia.RemoveAccountStub;
import org.chorem.lima.service.neogia.UpdateAccountStub;
import org.chorem.lima.service.neogia.parser.NGLAccountToAccountDTO;
import org.chorem.lima.service.neogia.util.NeogiaUtil;
import org.ofbiz.webservice.proxies.AddAccountDocument;
import org.ofbiz.webservice.proxies.GetAllAccountResponseDocument;
import org.ofbiz.webservice.proxies.RemoveAccountDocument;
import org.ofbiz.webservice.proxies.UpdateAccountDocument;
import org.ofbiz.webservice.wrappers.xsd.GenericValueNGlAccount;

public class NeogiaAccountService
implements AccountService {
    protected static final Log log = LogFactory.getLog(NeogiaAccountService.class);

    public AccountDTO getAllAccount() {
        try {
            GetAllAccountStub stub = new GetAllAccountStub();
            GetAllAccountResponseDocument response = stub.getAllAccount();
            GenericValueNGlAccount[] array = response.getGetAllAccountResponse().getReturnArray();
            return new NGLAccountToAccountDTO().loadArray(array);
        }
        catch (RemoteException ex) {
            log.fatal((Object)"Can't get all accounts.", (Throwable)ex);
            return null;
        }
    }

    public String addAccount(AccountDTO account) {
        try {
            if (log.isDebugEnabled()) {
                log.info((Object)"addAccount : ");
            }
            AddAccountStub stub = new AddAccountStub();
            AddAccountDocument document = AddAccountDocument.Factory.newInstance();
            AddAccountDocument.AddAccount element = AddAccountDocument.AddAccount.Factory.newInstance();
            element.setIdNumber(account.getIdNumber());
            element.setDescription(account.getDescription());
            element.setLowLevelCode(NeogiaUtil.getLowLevelCode(account));
            element.setTreePath(NeogiaUtil.getTreePath(account));
            document.setAddAccount(element);
            stub.addAccount(document);
            return "success";
        }
        catch (RemoteException ex) {
            log.fatal((Object)"Can't add an account.", (Throwable)ex);
            return "error";
        }
    }

    public String updateAccount(AccountDTO account) {
        try {
            if (log.isDebugEnabled()) {
                log.info((Object)"updateAccount : ");
            }
            UpdateAccountStub stub = new UpdateAccountStub();
            UpdateAccountDocument document = UpdateAccountDocument.Factory.newInstance();
            UpdateAccountDocument.UpdateAccount element = UpdateAccountDocument.UpdateAccount.Factory.newInstance();
            element.setIdNumber(account.getIdNumber());
            element.setDescription(account.getDescription());
            document.setUpdateAccount(element);
            stub.updateAccount(document);
            if (log.isDebugEnabled()) {
                log.debug((Object)("account " + account.getIdNumber() + " updated"));
            }
            return "success";
        }
        catch (RemoteException ex) {
            log.fatal((Object)"Can't update an account.", (Throwable)ex);
            return "error";
        }
    }

    public String removeAccount(AccountDTO account) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"removeAccount : ");
            }
            RemoveAccountStub stub = new RemoveAccountStub();
            RemoveAccountDocument document = RemoveAccountDocument.Factory.newInstance();
            RemoveAccountDocument.RemoveAccount element = RemoveAccountDocument.RemoveAccount.Factory.newInstance();
            element.setAccount(account.getIdNumber());
            document.setRemoveAccount(element);
            stub.removeAccount(document);
            if (log.isDebugEnabled()) {
                log.debug((Object)("account " + account.getIdNumber() + " removed"));
            }
            return "success";
        }
        catch (RemoteException ex) {
            log.fatal((Object)"Can't remove an account.", (Throwable)ex);
            return "error";
        }
    }
}

