/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core.api;

import org.cache2k.config.ConfigSection;
import org.cache2k.config.CustomizationReferenceSupplier;
import org.cache2k.config.CustomizationSupplier;
import org.cache2k.config.SectionBuilder;
import org.cache2k.core.StandardCommonMetrics;
import org.cache2k.core.api.CommonMetrics;
import org.cache2k.core.concurrency.ThreadFactoryProvider;

public class InternalConfig
implements ConfigSection<InternalConfig, Builder> {
    private static final CommonMetrics.Updater METRICS_BLACKHOLE = new CommonMetrics.BlackHole();
    private int evictionSegmentCount = -1;
    private CustomizationSupplier<ThreadFactoryProvider> threadFactoryProvider = new CustomizationReferenceSupplier((Object)ThreadFactoryProvider.DEFAULT);
    private CustomizationSupplier<CommonMetrics.Updater> commonMetrics = buildContext -> {
        if (buildContext.getConfig().isDisableStatistics()) {
            return METRICS_BLACKHOLE;
        }
        return new StandardCommonMetrics();
    };

    public CustomizationSupplier<ThreadFactoryProvider> getThreadFactoryProvider() {
        return this.threadFactoryProvider;
    }

    public void setThreadFactoryProvider(CustomizationSupplier<ThreadFactoryProvider> v) {
        this.threadFactoryProvider = v;
    }

    public int getEvictionSegmentCount() {
        return this.evictionSegmentCount;
    }

    public void setEvictionSegmentCount(int evictionSegmentCount) {
        this.evictionSegmentCount = evictionSegmentCount;
    }

    public CustomizationSupplier<CommonMetrics.Updater> getCommonMetrics() {
        return this.commonMetrics;
    }

    public void setCommonMetrics(CustomizationSupplier<CommonMetrics.Updater> commonMetrics) {
        this.commonMetrics = commonMetrics;
    }

    public Builder builder() {
        return new Builder(this);
    }

    public static class Builder
    implements SectionBuilder<Builder, InternalConfig> {
        private final InternalConfig cfg;

        public Builder(InternalConfig cfg) {
            this.cfg = cfg;
        }

        public Builder evictionSegmentCount(int v) {
            this.cfg.setEvictionSegmentCount(v);
            return this;
        }

        public Builder threadFactoryProvider(ThreadFactoryProvider v) {
            this.cfg.setThreadFactoryProvider((CustomizationSupplier<ThreadFactoryProvider>)new CustomizationReferenceSupplier((Object)v));
            return this;
        }

        public Builder commonMetrics(CommonMetrics.Updater v) {
            this.cfg.setCommonMetrics((CustomizationSupplier<CommonMetrics.Updater>)new CustomizationReferenceSupplier((Object)v));
            return this;
        }

        public InternalConfig config() {
            return this.cfg;
        }
    }
}

