/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.config;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import org.cache2k.Cache2kBuilder;
import org.cache2k.DataAware;
import org.cache2k.annotation.NonNull;
import org.cache2k.annotation.Nullable;
import org.cache2k.config.CacheType;
import org.cache2k.config.CacheWrapper;
import org.cache2k.config.ConfigBean;
import org.cache2k.config.ConfigSection;
import org.cache2k.config.ConfigWithSections;
import org.cache2k.config.CustomizationSupplier;
import org.cache2k.config.Feature;
import org.cache2k.config.SectionContainer;
import org.cache2k.event.CacheEntryOperationListener;
import org.cache2k.event.CacheLifecycleListener;
import org.cache2k.expiry.ExpiryPolicy;
import org.cache2k.io.AdvancedCacheLoader;
import org.cache2k.io.AsyncCacheLoader;
import org.cache2k.io.CacheLoader;
import org.cache2k.io.CacheWriter;
import org.cache2k.io.ExceptionPropagator;
import org.cache2k.io.ResiliencePolicy;
import org.cache2k.operation.Scheduler;
import org.cache2k.operation.TimeReference;
import org.cache2k.operation.Weigher;

public class Cache2kConfig<K, V>
implements ConfigBean<Cache2kConfig<K, V>, Cache2kBuilder<K, V>>,
DataAware<K, V>,
ConfigWithSections {
    public static final Duration EXPIRY_ETERNAL = Duration.ofMillis(Long.MAX_VALUE);
    public static final long DEFAULT_ENTRY_CAPACITY = 1802L;
    public static final int UNSET_INT = -1;
    public static final long UNSET_LONG = -1L;
    private boolean storeByReference;
    @Nullable
    private String name;
    private boolean nameWasGenerated;
    @Nullable
    private CacheType<K> keyType;
    @Nullable
    private CacheType<V> valueType;
    private long entryCapacity = -1L;
    @Nullable
    private Duration expireAfterWrite = null;
    @Nullable
    private Duration idleScanTime = null;
    @Nullable
    private Duration timerLag = null;
    private long maximumWeight = -1L;
    private int loaderThreadCount;
    private boolean eternal = false;
    private boolean keepDataAfterExpired = false;
    private boolean sharpExpiry = false;
    private boolean strictEviction = false;
    private boolean refreshAhead = false;
    private boolean permitNullValues = false;
    private boolean recordModificationTime = false;
    private boolean boostConcurrency = false;
    private boolean disableStatistics = false;
    private boolean disableMonitoring = false;
    private boolean externalConfigurationPresent = false;
    @Nullable
    private CustomizationSupplier<? extends Executor> loaderExecutor;
    @Nullable
    private CustomizationSupplier<? extends Executor> refreshExecutor;
    @Nullable
    private CustomizationSupplier<? extends Executor> asyncListenerExecutor;
    @Nullable
    private CustomizationSupplier<? extends Executor> executor;
    @Nullable
    private CustomizationSupplier<? extends ExpiryPolicy<? super K, ? super V>> expiryPolicy;
    @Nullable
    private CustomizationSupplier<? extends TimeReference> timeReference;
    @Nullable
    private CustomizationSupplier<? extends Scheduler> scheduler;
    @Nullable
    private CustomizationSupplier<? extends ResiliencePolicy<? super K, ? super V>> resiliencePolicy;
    @Nullable
    private CustomizationSupplier<? extends CacheWriter<K, V>> writer;
    @Nullable
    private CustomizationSupplier<? extends CacheLoader<K, V>> loader;
    @Nullable
    private CustomizationSupplier<? extends AdvancedCacheLoader<K, V>> advancedLoader;
    @Nullable
    private CustomizationSupplier<? extends AsyncCacheLoader<K, V>> asyncLoader;
    @Nullable
    private CustomizationSupplier<? extends ExceptionPropagator<? super K, ? super V>> exceptionPropagator;
    @Nullable
    private CustomizationSupplier<? extends Weigher<K, V>> weigher;
    @Nullable
    private Collection<CustomizationSupplier<CacheEntryOperationListener<K, V>>> listeners;
    @Nullable
    private Collection<CustomizationSupplier<CacheEntryOperationListener<K, V>>> asyncListeners;
    @Nullable
    private Collection<CustomizationSupplier<? extends CacheLifecycleListener>> lifecycleListeners;
    @Nullable
    private Set<Feature> features;
    @Nullable
    private SectionContainer sections;
    @Nullable
    private CacheWrapper traceCacheWrapper;
    @Nullable
    private CacheWrapper cacheWrapper;

    public static <K, V> Cache2kConfig<K, V> of(Class<K> keyType, Class<V> valueType) {
        Cache2kConfig<K, V> c = new Cache2kConfig<K, V>();
        c.setKeyType(CacheType.of(keyType));
        c.setValueType(CacheType.of(valueType));
        return c;
    }

    public static <K, V> Cache2kConfig<K, V> of(CacheType<K> keyType, CacheType<V> valueType) {
        Cache2kConfig<K, V> c = new Cache2kConfig<K, V>();
        c.setKeyType(keyType);
        c.setValueType(valueType);
        return c;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(@Nullable String name) {
        this.name = name;
    }

    public boolean isNameWasGenerated() {
        return this.nameWasGenerated;
    }

    public void setNameWasGenerated(boolean v) {
        this.nameWasGenerated = v;
    }

    public long getEntryCapacity() {
        return this.entryCapacity;
    }

    public void setEntryCapacity(long v) {
        this.entryCapacity = v;
    }

    public boolean isRefreshAhead() {
        return this.refreshAhead;
    }

    public void setRefreshAhead(boolean v) {
        this.refreshAhead = v;
    }

    @Nullable
    public CacheType<K> getKeyType() {
        return this.keyType;
    }

    public void setKeyType(@Nullable CacheType<K> v) {
        if (v == null) {
            this.valueType = null;
            return;
        }
        if (v.isArray()) {
            throw new IllegalArgumentException("Arrays are not supported for keys");
        }
        this.keyType = v;
    }

    @Nullable
    public CacheType<V> getValueType() {
        return this.valueType;
    }

    public void setValueType(@Nullable CacheType<V> v) {
        if (v == null) {
            this.valueType = null;
            return;
        }
        if (v.isArray()) {
            throw new IllegalArgumentException("Arrays are not supported for values");
        }
        this.valueType = v;
    }

    @Nullable
    public Duration getExpireAfterWrite() {
        return this.expireAfterWrite;
    }

    public void setExpireAfterWrite(@Nullable Duration v) {
        this.expireAfterWrite = this.durationCheckAndSanitize(v);
    }

    @Nullable
    public Duration getIdleScanTime() {
        return this.idleScanTime;
    }

    public void setIdleScanTime(@Nullable Duration v) {
        if (v != null && Duration.ZERO.compareTo(v) >= 0) {
            throw new IllegalArgumentException("idleScanTime must be greater than 0");
        }
        this.idleScanTime = this.durationCheckAndSanitize(v);
    }

    public boolean isEternal() {
        return this.eternal;
    }

    public void setEternal(boolean v) {
        this.eternal = v;
    }

    @Nullable
    public Duration getTimerLag() {
        return this.timerLag;
    }

    public void setTimerLag(@Nullable Duration v) {
        this.timerLag = this.durationCheckAndSanitize(v);
    }

    public boolean isKeepDataAfterExpired() {
        return this.keepDataAfterExpired;
    }

    public long getMaximumWeight() {
        return this.maximumWeight;
    }

    public void setMaximumWeight(long v) {
        this.maximumWeight = v;
    }

    public void setKeepDataAfterExpired(boolean v) {
        this.keepDataAfterExpired = v;
    }

    public boolean isSharpExpiry() {
        return this.sharpExpiry;
    }

    public void setSharpExpiry(boolean v) {
        this.sharpExpiry = v;
    }

    public boolean isExternalConfigurationPresent() {
        return this.externalConfigurationPresent;
    }

    public void setExternalConfigurationPresent(boolean v) {
        this.externalConfigurationPresent = v;
    }

    @Override
    public SectionContainer getSections() {
        if (this.sections == null) {
            this.sections = new SectionContainer();
        }
        return this.sections;
    }

    public void setSections(Collection<ConfigSection<?, ?>> c) {
        this.getSections().addAll(c);
    }

    @Nullable
    public CustomizationSupplier<? extends CacheLoader<K, V>> getLoader() {
        return this.loader;
    }

    public void setLoader(@Nullable CustomizationSupplier<? extends CacheLoader<K, V>> v) {
        this.loader = v;
    }

    @Nullable
    public CustomizationSupplier<? extends AdvancedCacheLoader<K, V>> getAdvancedLoader() {
        return this.advancedLoader;
    }

    public void setAdvancedLoader(@Nullable CustomizationSupplier<? extends AdvancedCacheLoader<K, V>> v) {
        this.advancedLoader = v;
    }

    @Nullable
    public CustomizationSupplier<? extends AsyncCacheLoader<K, V>> getAsyncLoader() {
        return this.asyncLoader;
    }

    public void setAsyncLoader(@Nullable CustomizationSupplier<? extends AsyncCacheLoader<K, V>> v) {
        this.asyncLoader = v;
    }

    public int getLoaderThreadCount() {
        return this.loaderThreadCount;
    }

    public void setLoaderThreadCount(int v) {
        this.loaderThreadCount = v;
    }

    @Nullable
    public CustomizationSupplier<? extends ExpiryPolicy<? super K, ? super V>> getExpiryPolicy() {
        return this.expiryPolicy;
    }

    public void setExpiryPolicy(@Nullable CustomizationSupplier<? extends ExpiryPolicy<? super K, ? super V>> v) {
        this.expiryPolicy = v;
    }

    @Nullable
    public CustomizationSupplier<? extends CacheWriter<K, V>> getWriter() {
        return this.writer;
    }

    public void setWriter(@Nullable CustomizationSupplier<? extends CacheWriter<K, V>> v) {
        this.writer = v;
    }

    public boolean isStoreByReference() {
        return this.storeByReference;
    }

    public void setStoreByReference(boolean v) {
        this.storeByReference = v;
    }

    @Nullable
    public CustomizationSupplier<? extends ExceptionPropagator<? super K, ? super V>> getExceptionPropagator() {
        return this.exceptionPropagator;
    }

    public void setExceptionPropagator(@Nullable CustomizationSupplier<? extends ExceptionPropagator<? super K, ? super V>> v) {
        this.exceptionPropagator = v;
    }

    @NonNull
    public Collection<CustomizationSupplier<CacheEntryOperationListener<K, V>>> getListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList<CustomizationSupplier<CacheEntryOperationListener<K, V>>>();
        }
        return this.listeners;
    }

    public boolean hasListeners() {
        return this.listeners != null && !this.listeners.isEmpty();
    }

    public void setListeners(Collection<CustomizationSupplier<CacheEntryOperationListener<K, V>>> c) {
        this.getListeners().addAll(c);
    }

    @NonNull
    public Collection<CustomizationSupplier<CacheEntryOperationListener<K, V>>> getAsyncListeners() {
        if (this.asyncListeners == null) {
            this.asyncListeners = new ArrayList<CustomizationSupplier<CacheEntryOperationListener<K, V>>>();
        }
        return this.asyncListeners;
    }

    public boolean hasAsyncListeners() {
        return this.asyncListeners != null && !this.asyncListeners.isEmpty();
    }

    public void setAsyncListeners(Collection<CustomizationSupplier<CacheEntryOperationListener<K, V>>> c) {
        this.getAsyncListeners().addAll(c);
    }

    @NonNull
    public Collection<CustomizationSupplier<? extends CacheLifecycleListener>> getLifecycleListeners() {
        if (this.lifecycleListeners == null) {
            this.lifecycleListeners = new ArrayList<CustomizationSupplier<? extends CacheLifecycleListener>>();
        }
        return this.lifecycleListeners;
    }

    public boolean hasLifecycleListeners() {
        return this.lifecycleListeners != null && !this.lifecycleListeners.isEmpty();
    }

    public void setLifecycleListeners(@NonNull Collection<CustomizationSupplier<? extends CacheLifecycleListener>> c) {
        this.getLifecycleListeners().addAll(c);
    }

    @NonNull
    public Set<Feature> getFeatures() {
        if (this.features == null) {
            this.features = new HashSet<Feature>();
        }
        return this.features;
    }

    public boolean hasFeatures() {
        return this.features != null && !this.features.isEmpty();
    }

    public void setFeatures(@NonNull Set<? extends Feature> v) {
        this.getFeatures().addAll(v);
    }

    @Nullable
    public CustomizationSupplier<? extends ResiliencePolicy<? super K, ? super V>> getResiliencePolicy() {
        return this.resiliencePolicy;
    }

    public void setResiliencePolicy(@Nullable CustomizationSupplier<? extends ResiliencePolicy<? super K, ? super V>> v) {
        this.resiliencePolicy = v;
    }

    public boolean isStrictEviction() {
        return this.strictEviction;
    }

    public void setStrictEviction(boolean v) {
        this.strictEviction = v;
    }

    public boolean isPermitNullValues() {
        return this.permitNullValues;
    }

    public void setPermitNullValues(boolean v) {
        this.permitNullValues = v;
    }

    public boolean isDisableStatistics() {
        return this.disableStatistics;
    }

    public void setDisableStatistics(boolean v) {
        this.disableStatistics = v;
    }

    @Nullable
    public CustomizationSupplier<? extends Executor> getLoaderExecutor() {
        return this.loaderExecutor;
    }

    public void setLoaderExecutor(@Nullable CustomizationSupplier<? extends Executor> v) {
        this.loaderExecutor = v;
    }

    public boolean isRecordModificationTime() {
        return this.recordModificationTime;
    }

    public void setRecordModificationTime(boolean v) {
        this.recordModificationTime = v;
    }

    @Nullable
    public CustomizationSupplier<? extends Executor> getRefreshExecutor() {
        return this.refreshExecutor;
    }

    public void setRefreshExecutor(@Nullable CustomizationSupplier<? extends Executor> v) {
        this.refreshExecutor = v;
    }

    @Nullable
    public CustomizationSupplier<? extends Executor> getExecutor() {
        return this.executor;
    }

    public void setExecutor(@Nullable CustomizationSupplier<? extends Executor> v) {
        this.executor = v;
    }

    @Nullable
    public CustomizationSupplier<? extends Executor> getAsyncListenerExecutor() {
        return this.asyncListenerExecutor;
    }

    public void setAsyncListenerExecutor(@Nullable CustomizationSupplier<? extends Executor> v) {
        this.asyncListenerExecutor = v;
    }

    @Nullable
    public CustomizationSupplier<? extends Weigher<K, V>> getWeigher() {
        return this.weigher;
    }

    public void setWeigher(@Nullable CustomizationSupplier<? extends Weigher<K, V>> v) {
        this.weigher = v;
    }

    @Nullable
    public CustomizationSupplier<? extends Scheduler> getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(CustomizationSupplier<? extends Scheduler> scheduler) {
        this.scheduler = scheduler;
    }

    @Nullable
    public CustomizationSupplier<? extends TimeReference> getTimeReference() {
        return this.timeReference;
    }

    public void setTimeReference(CustomizationSupplier<? extends TimeReference> timeReference) {
        this.timeReference = timeReference;
    }

    public boolean isBoostConcurrency() {
        return this.boostConcurrency;
    }

    public void setBoostConcurrency(boolean v) {
        this.boostConcurrency = v;
    }

    public boolean isDisableMonitoring() {
        return this.disableMonitoring;
    }

    public void setDisableMonitoring(boolean disableMonitoring) {
        this.disableMonitoring = disableMonitoring;
    }

    @Nullable
    public CacheWrapper getTraceCacheWrapper() {
        return this.traceCacheWrapper;
    }

    public void setTraceCacheWrapper(@Nullable CacheWrapper traceCacheWrapper) {
        this.traceCacheWrapper = traceCacheWrapper;
    }

    @Nullable
    public CacheWrapper getCacheWrapper() {
        return this.cacheWrapper;
    }

    public void setCacheWrapper(@Nullable CacheWrapper cacheWrapper) {
        this.cacheWrapper = cacheWrapper;
    }

    @Nullable
    private Duration durationCheckAndSanitize(@Nullable Duration v) {
        if (v == null) {
            return null;
        }
        if (v.isNegative()) {
            throw new IllegalArgumentException("Duration must be positive");
        }
        if (EXPIRY_ETERNAL.compareTo(v) <= 0) {
            v = EXPIRY_ETERNAL;
        }
        return v;
    }

    @Override
    public Cache2kBuilder<K, V> builder() {
        return Cache2kBuilder.of(this);
    }
}

