/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.InputStream;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.InvalidFrameID3Exception;
import org.blinkenlights.jid3.io.TextEncoding;
import org.blinkenlights.jid3.util.ID3Visitor;
import org.blinkenlights.jid3.v2.TextInformationID3V2Frame;

public class TDLYTextInformationID3V2Frame
extends TextInformationID3V2Frame {
    private int m_iPlaylistDelayMillis;

    public TDLYTextInformationID3V2Frame(int iPlaylistDelayMillis) throws ID3Exception {
        super(Integer.toString(iPlaylistDelayMillis));
        if (iPlaylistDelayMillis < 0) {
            throw new ID3Exception("Playlist delay cannot be negative.");
        }
        this.m_iPlaylistDelayMillis = iPlaylistDelayMillis;
    }

    public TDLYTextInformationID3V2Frame(InputStream oIS) throws ID3Exception {
        super(oIS);
        try {
            this.m_iPlaylistDelayMillis = Integer.parseInt(this.m_sInformation);
        }
        catch (Exception e) {
            throw new InvalidFrameID3Exception("Encountered corrupt TDLY playlist delay frame.", e);
        }
    }

    public void accept(ID3Visitor oID3Visitor) {
        oID3Visitor.visitTDLYTextInformationID3V2Frame(this);
    }

    public void setPlaylistDelay(int iPlaylistDelayMillis) throws ID3Exception {
        if (iPlaylistDelayMillis < 0) {
            throw new ID3Exception("Playlist delay cannot be negative.");
        }
        this.m_iPlaylistDelayMillis = iPlaylistDelayMillis;
        this.m_oTextEncoding = TextEncoding.getDefaultTextEncoding();
        this.m_sInformation = Integer.toString(iPlaylistDelayMillis);
    }

    public int getPlaylistDelay() {
        return this.m_iPlaylistDelayMillis;
    }

    protected byte[] getFrameId() {
        return "TDLY".getBytes();
    }

    public String toString() {
        return "Playlist delay: [" + this.m_sInformation + "]";
    }

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof TDLYTextInformationID3V2Frame)) {
            return false;
        }
        TDLYTextInformationID3V2Frame oOtherTDLY = (TDLYTextInformationID3V2Frame)oOther;
        return this.m_iPlaylistDelayMillis == oOtherTDLY.m_iPlaylistDelayMillis && this.m_oTextEncoding.equals(oOtherTDLY.m_oTextEncoding) && this.m_sInformation.equals(oOtherTDLY.m_sInformation);
    }
}

