/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.InputStream;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.ID3Tag;
import org.blinkenlights.jid3.InvalidFrameID3Exception;
import org.blinkenlights.jid3.io.TextEncoding;
import org.blinkenlights.jid3.util.ID3Visitor;
import org.blinkenlights.jid3.v2.ContentType;
import org.blinkenlights.jid3.v2.TextInformationID3V2Frame;

public class TCONTextInformationID3V2Frame
extends TextInformationID3V2Frame {
    private ContentType m_oContentType = null;

    public TCONTextInformationID3V2Frame(ContentType oContentType) {
        super("");
        this.m_oContentType = oContentType;
        this.m_sInformation = oContentType.toString();
    }

    public TCONTextInformationID3V2Frame(InputStream oIS) throws ID3Exception {
        super(oIS);
        try {
            this.m_oContentType = this.convertStringToContentType(this.m_sInformation);
        }
        catch (Exception e) {
            throw new InvalidFrameID3Exception("Encountered a corrupt TCON year frame.", e);
        }
    }

    public void accept(ID3Visitor oID3Visitor) {
        oID3Visitor.visitTCONTextInformationID3V2Frame(this);
    }

    protected byte[] getFrameId() {
        return "TCON".getBytes();
    }

    public String toString() {
        return "Content type: [" + this.m_sInformation + "]";
    }

    public ContentType setContentType(ContentType oContentType) {
        ContentType oOldContentType = this.m_oContentType;
        this.m_oContentType = oContentType;
        this.m_oTextEncoding = TextEncoding.getDefaultTextEncoding();
        this.m_sInformation = oContentType.toString();
        return oOldContentType;
    }

    public ContentType getContentType() {
        return this.m_oContentType;
    }

    private ContentType convertStringToContentType(String sContentType) throws ID3Exception {
        ContentType oContentType = new ContentType();
        try {
            String sPiece = null;
            while ((sPiece = this.getNextPiece(sContentType)).length() > 0) {
                block12: {
                    if (sPiece.charAt(0) != '(' || sPiece.startsWith("((")) {
                        oContentType.setRefinement(sPiece);
                    } else if (sPiece.toUpperCase().equals("(CR)")) {
                        oContentType.setIsCover(true);
                    } else if (sPiece.toUpperCase().equals("(RX)")) {
                        oContentType.setIsRemix(true);
                    } else {
                        String sGenreValue = sPiece.substring(1, sPiece.length() - 1);
                        int iGenreValue = Integer.parseInt(sGenreValue);
                        try {
                            ContentType.Genre oGenre = ContentType.Genre.lookupGenre(iGenreValue);
                            oContentType.setGenre(oGenre);
                        }
                        catch (Exception e) {
                            if (!ID3Tag.usingStrict()) break block12;
                            throw e;
                        }
                    }
                }
                sContentType = sContentType.substring(sPiece.length());
            }
        }
        catch (ID3Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new ID3Exception("Encountered corrupt content type value in tag.", e);
        }
        return oContentType;
    }

    private String getNextPiece(String sContentType) {
        if (sContentType.length() == 0) {
            return "";
        }
        if (sContentType.charAt(0) != '(' || sContentType.startsWith("((")) {
            return sContentType;
        }
        return sContentType.substring(0, sContentType.indexOf(41) + 1);
    }

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof TCONTextInformationID3V2Frame)) {
            return false;
        }
        TCONTextInformationID3V2Frame oOtherTCON = (TCONTextInformationID3V2Frame)oOther;
        return this.m_oContentType.equals(oOtherTCON.m_oContentType) && this.m_oTextEncoding.equals(oOtherTCON.m_oTextEncoding) && this.m_sInformation.equals(oOtherTCON.m_sInformation);
    }
}

