/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.IOException;
import java.io.InputStream;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.InvalidFrameID3Exception;
import org.blinkenlights.jid3.io.ID3DataInputStream;
import org.blinkenlights.jid3.io.ID3DataOutputStream;
import org.blinkenlights.jid3.util.ID3Visitor;
import org.blinkenlights.jid3.v2.ID3V2Frame;

public class RVRBID3V2Frame
extends ID3V2Frame {
    private int m_iReverbLeftMS;
    private int m_iReverbRightMS;
    private int m_iReverbBouncesLeft;
    private int m_iReverbBouncesRight;
    private int m_iReverbFeedbackLeftToLeft;
    private int m_iReverbFeedbackLeftToRight;
    private int m_iReverbFeedbackRightToRight;
    private int m_iReverbFeedbackRightToLeft;
    private int m_iPremixLeftToRight;
    private int m_iPremixRightToLeft;

    public RVRBID3V2Frame(int iReverbLeftMS, int iReverbRightMS, int iReverbBouncesLeft, int iReverbBouncesRight, int iReverbFeedbackLeftToLeft, int iReverbFeedbackLeftToRight, int iReverbFeedbackRightToRight, int iReverbFeedbackRightToLeft, int iPremixLeftToRight, int iPremixRightToLeft) throws ID3Exception {
        if (iReverbLeftMS < 0 || iReverbLeftMS > 65535) {
            throw new ID3Exception("Reverb left milliseconds must be an unsigned 16-bit value in RVRB frame.");
        }
        this.m_iReverbLeftMS = iReverbLeftMS;
        if (iReverbRightMS < 0 || iReverbRightMS > 65535) {
            throw new ID3Exception("Reverb right milliseconds must be an unsigned 16-bit value in RVRB frame.");
        }
        this.m_iReverbRightMS = iReverbRightMS;
        if (iReverbBouncesLeft < 0 || iReverbBouncesLeft > 255) {
            throw new ID3Exception("Reverb bounces left value must be between 0 and 255 in RVRB frame.");
        }
        this.m_iReverbBouncesLeft = iReverbBouncesLeft;
        if (iReverbBouncesRight < 0 || iReverbBouncesRight > 255) {
            throw new ID3Exception("Reverb bounces right value must be between 0 and 255 in RVRB frame.");
        }
        this.m_iReverbBouncesRight = iReverbBouncesRight;
        if (iReverbFeedbackLeftToLeft < 0 || iReverbFeedbackLeftToLeft > 255) {
            throw new ID3Exception("Reverb feedback left to left value must be between 0 and 255 in RVRB frame.");
        }
        this.m_iReverbFeedbackLeftToLeft = iReverbFeedbackLeftToLeft;
        if (iReverbFeedbackLeftToRight < 0 || iReverbFeedbackLeftToRight > 255) {
            throw new ID3Exception("Reverb feedback left to right value must be between 0 and 255 in RVRB frame.");
        }
        this.m_iReverbFeedbackLeftToRight = iReverbFeedbackLeftToRight;
        if (iReverbFeedbackRightToLeft < 0 || iReverbFeedbackRightToLeft > 255) {
            throw new ID3Exception("Reverb feedback right to left value must be between 0 and 255 in RVRB frame.");
        }
        this.m_iReverbFeedbackRightToLeft = iReverbFeedbackRightToLeft;
        if (iReverbFeedbackRightToRight < 0 || iReverbFeedbackRightToRight > 255) {
            throw new ID3Exception("Reverb feedback right to right value must be between 0 and 255 in RVRB frame.");
        }
        this.m_iReverbFeedbackRightToRight = iReverbFeedbackRightToRight;
        if (iPremixLeftToRight < 0 || iPremixLeftToRight > 255) {
            throw new ID3Exception("Premix left to right value must be between 0 and 255 in RVRB frame.");
        }
        this.m_iPremixLeftToRight = iPremixLeftToRight;
        if (iPremixRightToLeft < 0 || iPremixRightToLeft > 255) {
            throw new ID3Exception("Premix right to left value must be between 0 and 255 in RVRB frame.");
        }
        this.m_iPremixRightToLeft = iPremixRightToLeft;
    }

    public RVRBID3V2Frame(InputStream oIS) throws ID3Exception {
        try {
            ID3DataInputStream oFrameDataID3DIS = new ID3DataInputStream(oIS);
            this.m_iReverbLeftMS = oFrameDataID3DIS.readBEUnsigned16();
            this.m_iReverbRightMS = oFrameDataID3DIS.readBEUnsigned16();
            this.m_iReverbBouncesLeft = oFrameDataID3DIS.readUnsignedByte();
            this.m_iReverbBouncesRight = oFrameDataID3DIS.readUnsignedByte();
            this.m_iReverbFeedbackLeftToLeft = oFrameDataID3DIS.readUnsignedByte();
            this.m_iReverbFeedbackLeftToRight = oFrameDataID3DIS.readUnsignedByte();
            this.m_iReverbFeedbackRightToRight = oFrameDataID3DIS.readUnsignedByte();
            this.m_iReverbFeedbackRightToLeft = oFrameDataID3DIS.readUnsignedByte();
            this.m_iPremixLeftToRight = oFrameDataID3DIS.readUnsignedByte();
            this.m_iPremixRightToLeft = oFrameDataID3DIS.readUnsignedByte();
        }
        catch (Exception e) {
            throw new InvalidFrameID3Exception(e);
        }
    }

    public void accept(ID3Visitor oID3Visitor) {
        oID3Visitor.visitRVRBID3V2Frame(this);
    }

    public void setReverbDetails(int iReverbLeftMS, int iReverbRightMS, int iReverbBouncesLeft, int iReverbBouncesRight, int iReverbFeedbackLeftToLeft, int iReverbFeedbackLeftToRight, int iReverbFeedbackRightToRight, int iReverbFeedbackRightToLeft, int iPremixLeftToRight, int iPremixRightToLeft) throws ID3Exception {
        if (iReverbLeftMS < 0 || iReverbLeftMS > 65535) {
            throw new ID3Exception("Reverb left milliseconds must be an unsigned 16-bit value in RVRB frame.");
        }
        this.m_iReverbLeftMS = iReverbLeftMS;
        if (iReverbRightMS < 0 || iReverbRightMS > 65535) {
            throw new ID3Exception("Reverb right milliseconds must be an unsigned 16-bit value in RVRB frame.");
        }
        this.m_iReverbRightMS = iReverbRightMS;
        if (iReverbBouncesLeft < 0 || iReverbBouncesLeft > 255) {
            throw new ID3Exception("Reverb bounces left value must be between 0 and 255 in RVRB frame.");
        }
        this.m_iReverbBouncesLeft = iReverbBouncesLeft;
        if (iReverbBouncesRight < 0 || iReverbBouncesRight > 255) {
            throw new ID3Exception("Reverb bounces right value must be between 0 and 255 in RVRB frame.");
        }
        this.m_iReverbBouncesRight = iReverbBouncesRight;
        if (iReverbFeedbackLeftToLeft < 0 || iReverbFeedbackLeftToLeft > 255) {
            throw new ID3Exception("Reverb feedback left to left value must be between 0 and 255 in RVRB frame.");
        }
        this.m_iReverbFeedbackLeftToLeft = iReverbFeedbackLeftToLeft;
        if (iReverbFeedbackLeftToRight < 0 || iReverbFeedbackLeftToRight > 255) {
            throw new ID3Exception("Reverb feedback left to right value must be between 0 and 255 in RVRB frame.");
        }
        this.m_iReverbFeedbackLeftToRight = iReverbFeedbackLeftToRight;
        if (iReverbFeedbackRightToLeft < 0 || iReverbFeedbackRightToLeft > 255) {
            throw new ID3Exception("Reverb feedback right to left value must be between 0 and 255 in RVRB frame.");
        }
        this.m_iReverbFeedbackRightToLeft = iReverbFeedbackRightToLeft;
        if (iReverbFeedbackRightToRight < 0 || iReverbFeedbackRightToRight > 255) {
            throw new ID3Exception("Reverb feedback right to right value must be between 0 and 255 in RVRB frame.");
        }
        this.m_iReverbFeedbackRightToRight = iReverbFeedbackRightToRight;
        if (iPremixLeftToRight < 0 || iPremixLeftToRight > 255) {
            throw new ID3Exception("Premix left to right value must be between 0 and 255 in RVRB frame.");
        }
        this.m_iPremixLeftToRight = iPremixLeftToRight;
        if (iPremixRightToLeft < 0 || iPremixRightToLeft > 255) {
            throw new ID3Exception("Premix right to left value must be between 0 and 255 in RVRB frame.");
        }
        this.m_iPremixRightToLeft = iPremixRightToLeft;
    }

    public int getReverbLeftMS() {
        return this.m_iReverbLeftMS;
    }

    public int getReverbRightMS() {
        return this.m_iReverbRightMS;
    }

    public int getReverbBouncesLeft() {
        return this.m_iReverbBouncesLeft;
    }

    public int getReverbBouncesRight() {
        return this.m_iReverbBouncesRight;
    }

    public int getReverbFeedbackLeftToLeft() {
        return this.m_iReverbFeedbackLeftToLeft;
    }

    public int getReverbFeedbackLeftToRight() {
        return this.m_iReverbFeedbackLeftToRight;
    }

    public int getReverbFeedbackRightToRight() {
        return this.m_iReverbFeedbackRightToRight;
    }

    public int getReverbFeedbackRightToLeft() {
        return this.m_iReverbFeedbackRightToLeft;
    }

    public int getPremixLeftToRight() {
        return this.m_iPremixLeftToRight;
    }

    public int getPremixRightToLeft() {
        return this.m_iPremixRightToLeft;
    }

    protected byte[] getFrameId() {
        return "RVRB".getBytes();
    }

    public String toString() {
        return "Reverb: Reverb Left (ms)=[" + this.m_iReverbLeftMS + "], Reverb Right (ms)=" + this.m_iReverbRightMS + "], Reverb Bounces Left=[" + this.m_iReverbBouncesLeft + "], Reverb Bounches right=[" + this.m_iReverbBouncesRight + "], Reverb Feedback Left To Left=[" + this.m_iReverbFeedbackLeftToLeft + "], Reverb Feedback Left To Right=[" + this.m_iReverbFeedbackLeftToRight + "], Reverb Feedback Right To Right=[" + this.m_iReverbFeedbackRightToRight + "], Reverb Feedback Right To Left=[" + this.m_iReverbFeedbackRightToLeft + "], Premix Left To Right=[" + this.m_iPremixLeftToRight + "], Premix Right To Left=[" + this.m_iPremixRightToLeft + "]";
    }

    protected void writeBody(ID3DataOutputStream oIDOS) throws IOException {
        oIDOS.writeBEUnsigned16(this.m_iReverbLeftMS);
        oIDOS.writeBEUnsigned16(this.m_iReverbRightMS);
        oIDOS.writeUnsignedByte(this.m_iReverbBouncesLeft);
        oIDOS.writeUnsignedByte(this.m_iReverbBouncesRight);
        oIDOS.writeUnsignedByte(this.m_iReverbFeedbackLeftToLeft);
        oIDOS.writeUnsignedByte(this.m_iReverbFeedbackLeftToRight);
        oIDOS.writeUnsignedByte(this.m_iReverbFeedbackRightToRight);
        oIDOS.writeUnsignedByte(this.m_iReverbFeedbackRightToLeft);
        oIDOS.writeUnsignedByte(this.m_iPremixLeftToRight);
        oIDOS.writeUnsignedByte(this.m_iPremixRightToLeft);
    }

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof RVRBID3V2Frame)) {
            return false;
        }
        RVRBID3V2Frame oOtherRVRB = (RVRBID3V2Frame)oOther;
        return this.m_iReverbLeftMS == oOtherRVRB.m_iReverbLeftMS && this.m_iReverbRightMS == oOtherRVRB.m_iReverbRightMS && this.m_iReverbBouncesLeft == oOtherRVRB.m_iReverbBouncesLeft && this.m_iReverbBouncesRight == oOtherRVRB.m_iReverbBouncesRight && this.m_iReverbFeedbackLeftToLeft == oOtherRVRB.m_iReverbFeedbackLeftToLeft && this.m_iReverbFeedbackLeftToRight == oOtherRVRB.m_iReverbFeedbackLeftToRight && this.m_iReverbFeedbackRightToRight == oOtherRVRB.m_iReverbFeedbackRightToRight && this.m_iReverbFeedbackRightToLeft == oOtherRVRB.m_iReverbFeedbackRightToLeft && this.m_iPremixLeftToRight == oOtherRVRB.m_iPremixLeftToRight && this.m_iPremixRightToLeft == oOtherRVRB.m_iPremixRightToLeft;
    }
}

