/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.InvalidFrameID3Exception;
import org.blinkenlights.jid3.io.ID3DataInputStream;
import org.blinkenlights.jid3.io.ID3DataOutputStream;
import org.blinkenlights.jid3.util.ID3Util;
import org.blinkenlights.jid3.util.ID3Visitor;
import org.blinkenlights.jid3.v2.ID3V2Frame;

public class AENCID3V2Frame
extends ID3V2Frame {
    private String m_sOwnerIdentifier = null;
    private int m_iPreviewStartFrame;
    private int m_iPreviewLengthFrames;
    private byte[] m_abyEncryptionInfo = null;

    public AENCID3V2Frame(String sOwnerIdentifier, int iPreviewStartFrame, int iPreviewLengthFrames, byte[] abyEncryptionInfo) throws ID3Exception {
        this.m_sOwnerIdentifier = sOwnerIdentifier;
        if (this.m_sOwnerIdentifier == null) {
            this.m_sOwnerIdentifier = "";
        }
        if (iPreviewStartFrame < 0 || iPreviewStartFrame > 65535) {
            throw new ID3Exception("Preview start frame must be unsigned 16-bit integer values.");
        }
        this.m_iPreviewStartFrame = iPreviewStartFrame;
        if (iPreviewLengthFrames < 0 || iPreviewLengthFrames > 65535) {
            throw new ID3Exception("Preview length in frames must be unsinged 16-bit integer values.");
        }
        this.m_iPreviewLengthFrames = iPreviewLengthFrames;
        this.m_abyEncryptionInfo = abyEncryptionInfo;
        if (this.m_abyEncryptionInfo == null) {
            this.m_abyEncryptionInfo = new byte[0];
        }
    }

    public AENCID3V2Frame(InputStream oIS) throws ID3Exception {
        try {
            int iOwnerIdentifierByte;
            ID3DataInputStream oFrameDataID3DIS = new ID3DataInputStream(oIS);
            ByteArrayOutputStream oOwnerIdentifierBAOS = new ByteArrayOutputStream();
            do {
                if ((iOwnerIdentifierByte = oFrameDataID3DIS.readUnsignedByte()) == 0) continue;
                oOwnerIdentifierBAOS.write(iOwnerIdentifierByte);
            } while (iOwnerIdentifierByte != 0);
            if (oOwnerIdentifierBAOS.size() > 0) {
                byte[] abyOwnerIdentifier = oOwnerIdentifierBAOS.toByteArray();
                this.m_sOwnerIdentifier = new String(abyOwnerIdentifier);
            }
            this.m_iPreviewStartFrame = oFrameDataID3DIS.readBEUnsigned16();
            this.m_iPreviewLengthFrames = oFrameDataID3DIS.readBEUnsigned16();
            this.m_abyEncryptionInfo = new byte[oFrameDataID3DIS.available()];
            oFrameDataID3DIS.readFully(this.m_abyEncryptionInfo);
        }
        catch (Exception e) {
            throw new InvalidFrameID3Exception(e);
        }
    }

    public void accept(ID3Visitor oID3Visitor) {
        oID3Visitor.visitAENCID3V2Frame(this);
    }

    public void setOwnerIdentifier(String sOwnerIdentifier) throws ID3Exception {
        String sOrigOwnerIdentifier = this.m_sOwnerIdentifier;
        this.m_sOwnerIdentifier = sOwnerIdentifier;
        if (this.m_sOwnerIdentifier == null) {
            this.m_sOwnerIdentifier = "";
        }
        try {
            this.notifyID3Observers();
        }
        catch (ID3Exception e) {
            this.m_sOwnerIdentifier = sOrigOwnerIdentifier;
            throw e;
        }
    }

    public String getOwnerIdentifier() {
        return this.m_sOwnerIdentifier;
    }

    public void setPreviewRange(int iPreviewStartFrame, int iPreviewLengthFrames) throws ID3Exception {
        if (iPreviewStartFrame < 0 || iPreviewStartFrame > 65535 || iPreviewLengthFrames < 0 || iPreviewLengthFrames > 65535) {
            throw new ID3Exception("Preview start frame and frames length must be unsigned 16-bit integer values.");
        }
        this.m_iPreviewStartFrame = iPreviewStartFrame;
        this.m_iPreviewLengthFrames = iPreviewLengthFrames;
    }

    public int getPreviewStartFrame() {
        return this.m_iPreviewStartFrame;
    }

    public int getPreviewFramesLength() {
        return this.m_iPreviewLengthFrames;
    }

    public void setEncryptionInfo(byte[] abyEncryptionInfo) {
        this.m_abyEncryptionInfo = abyEncryptionInfo;
        if (this.m_abyEncryptionInfo == null) {
            this.m_abyEncryptionInfo = new byte[0];
        }
    }

    public byte[] getEncryptionInfo() {
        return this.m_abyEncryptionInfo;
    }

    protected byte[] getFrameId() {
        return "AENC".getBytes();
    }

    public String toString() {
        return "Audio encryption: Owner identifier=[" + this.m_sOwnerIdentifier + "], Preview start frame = " + this.m_iPreviewStartFrame + ", Preview length = " + this.m_iPreviewLengthFrames + ", Encryption info=[" + ID3Util.convertBytesToHexString(this.m_abyEncryptionInfo, true) + "]";
    }

    protected void writeBody(ID3DataOutputStream oIDOS) throws IOException {
        oIDOS.write(this.m_sOwnerIdentifier.getBytes());
        oIDOS.writeUnsignedByte(0);
        oIDOS.writeBEUnsigned16(this.m_iPreviewStartFrame);
        oIDOS.writeBEUnsigned16(this.m_iPreviewLengthFrames);
        oIDOS.write(this.m_abyEncryptionInfo);
    }

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof AENCID3V2Frame)) {
            return false;
        }
        AENCID3V2Frame oOtherAENC = (AENCID3V2Frame)oOther;
        return this.m_sOwnerIdentifier.equals(oOtherAENC.m_sOwnerIdentifier) && this.m_iPreviewStartFrame == oOtherAENC.m_iPreviewStartFrame && this.m_iPreviewLengthFrames == oOtherAENC.m_iPreviewLengthFrames && Arrays.equals(this.m_abyEncryptionInfo, oOtherAENC.m_abyEncryptionInfo);
    }
}

