/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.Date;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.blinkenlights.jid3.ID3Tag;
import org.blinkenlights.jid3.v1.ID3V1_0Tag;
import org.blinkenlights.jid3.v1.ID3V1_1Tag;
import org.blinkenlights.jid3.v2.ID3V2_3_0Tag;

public class ID3Util {
    private static final String LICENSE = "Copyright (C)2003-2005 Paul Grebenc\n\nThis library is free software; you can redistribute it and/or\nmodify it under the terms of the GNU Lesser General Public\nLicense as published by the Free Software Foundation; either\nversion 2.1 of the License, or (at your option) any later version.\n\nThis library is distributed in the hope that it will be useful,\nbut WITHOUT ANY WARRANTY; without even the implied warranty of\nMERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\nLesser General Public License for more details.\n\nYou should have received a copy of the GNU Lesser General Public\nLicense along with this library; if not, write to the Free Software\nFoundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA";

    public static String getVersion() {
        try {
            InputStream oPropIS = ID3Util.class.getResourceAsStream("/jid3.properties");
            Properties oProperties = new Properties();
            oProperties.load(oPropIS);
            String sVersion = oProperties.getProperty("jid3.version");
            URL oJID3URL = ID3Util.class.getResource("/jid3.properties");
            String sJarFile = oJID3URL.toExternalForm();
            sJarFile = sJarFile.replaceFirst("^jar:/?/?", "");
            sJarFile = sJarFile.replaceFirst("^file:", "");
            sJarFile = sJarFile.replaceFirst("!.*$", "");
            JarFile oJarFile = new JarFile(sJarFile);
            JarEntry oJarEntry = oJarFile.getJarEntry("jid3.properties");
            long lLastModified = oJarEntry.getTime();
            Date oDate = new Date(lLastModified);
            return sVersion + " (" + oDate.toString() + ")";
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    public static String getLicense() {
        return LICENSE;
    }

    public static void main(String[] args) {
        System.out.println("JID3 library version " + ID3Util.getVersion() + "\n\n" + ID3Util.getLicense());
    }

    public static void printTags(ID3Tag[] aoID3Tag) throws Exception {
        System.out.println("Number of tag sets: " + aoID3Tag.length);
        for (int i = 0; i < aoID3Tag.length; ++i) {
            if (aoID3Tag[i] instanceof ID3V1_0Tag) {
                System.out.println("ID3V1_0Tag:");
                System.out.println(aoID3Tag[i].toString());
                continue;
            }
            if (aoID3Tag[i] instanceof ID3V1_1Tag) {
                System.out.println("ID3V1_1Tag:");
                System.out.println(aoID3Tag[i].toString());
                continue;
            }
            if (!(aoID3Tag[i] instanceof ID3V2_3_0Tag)) continue;
            System.out.println("ID3V2_3_0Tag:");
            System.out.println(aoID3Tag[i].toString());
        }
    }

    public static boolean requiresUnsynchronization(byte[] abySource) {
        for (int i = 0; i < abySource.length - 1; ++i) {
            if ((abySource[i] & 0xFF) != 255 || (abySource[i + 1] & 0xFF) < 224) continue;
            return true;
        }
        return false;
    }

    public static byte[] unsynchronize(byte[] abySource) {
        ByteArrayInputStream oBAIS = new ByteArrayInputStream(abySource);
        ByteArrayOutputStream oBAOS = new ByteArrayOutputStream();
        boolean bUnsynchronizationUsed = false;
        while (oBAIS.available() > 0) {
            int iVal = oBAIS.read();
            oBAOS.write(iVal);
            if (iVal != 255 || oBAIS.available() <= 0) continue;
            oBAIS.mark(1);
            int iNextVal = oBAIS.read();
            if (iNextVal >= 224) {
                oBAOS.write(0);
                oBAOS.write(iNextVal);
                bUnsynchronizationUsed = true;
                continue;
            }
            oBAIS.reset();
        }
        if (bUnsynchronizationUsed && (abySource[abySource.length - 1] & 0xFF) == 255) {
            oBAOS.write(0);
        }
        return oBAOS.toByteArray();
    }

    public static byte[] deunsynchronize(byte[] abySource) {
        ByteArrayInputStream oBAIS = new ByteArrayInputStream(abySource);
        ByteArrayOutputStream oBAOS = new ByteArrayOutputStream();
        while (oBAIS.available() > 0) {
            int iVal = oBAIS.read();
            oBAOS.write(iVal);
            if (iVal != 255) continue;
            oBAIS.read();
        }
        return oBAOS.toByteArray();
    }

    public static String convertBytesToHexString(byte[] abyRawBytes, boolean bIncludeColons) {
        StringBuffer sbBuffer = new StringBuffer();
        for (int iNum = 0; iNum < abyRawBytes.length; ++iNum) {
            int iVal = abyRawBytes[iNum] < 0 ? abyRawBytes[iNum] + 256 : abyRawBytes[iNum];
            String sHexVal = Integer.toHexString(iVal);
            if (sHexVal.length() == 1) {
                sbBuffer.append("0");
            }
            sbBuffer.append(Integer.toHexString(iVal));
            if (!bIncludeColons || iNum >= abyRawBytes.length - 1) continue;
            sbBuffer.append(":");
        }
        return sbBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(String sSource, String sDestination) throws Exception {
        FileInputStream oFIS = null;
        FileOutputStream oFOS = null;
        try {
            int iNumRead;
            oFIS = new FileInputStream(sSource);
            oFOS = new FileOutputStream(sDestination);
            byte[] abyBuffer = new byte[16384];
            while ((iNumRead = oFIS.read(abyBuffer)) != -1) {
                oFOS.write(abyBuffer, 0, iNumRead);
            }
            oFOS.flush();
        }
        finally {
            try {
                oFIS.close();
            }
            catch (Exception e) {}
            try {
                oFOS.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compare(String sFileOne, String sFileTwo) throws Exception {
        File oOneFile = new File(sFileOne);
        File oTwoFile = new File(sFileTwo);
        if (oOneFile.length() != oTwoFile.length()) {
            throw new Exception("File lengths differ.");
        }
        FileInputStream oFIS1 = new FileInputStream(oOneFile);
        FileInputStream oFIS2 = new FileInputStream(oTwoFile);
        try {
            int c;
            int i = 0;
            while ((c = oFIS1.read()) != -1) {
                if (oFIS2.read() != c) {
                    throw new Exception("File contents differ at position " + i + ".");
                }
                ++i;
            }
        }
        finally {
            oFIS1.close();
            oFIS2.close();
        }
    }

    public static byte[] convertFrhedToByteArray(String sInput) throws Exception {
        int iChar;
        ByteArrayOutputStream oBAOS = new ByteArrayOutputStream();
        StringReader oSR = new StringReader(sInput);
        while ((iChar = oSR.read()) != -1) {
            char c = (char)iChar;
            if (c == '\\') {
                iChar = oSR.read();
                oBAOS.write(iChar);
                continue;
            }
            if (c == '<') {
                StringBuffer sbEncoding = new StringBuffer();
                while ((iChar = oSR.read()) != 58) {
                    sbEncoding.append((char)iChar);
                }
                String sEncoding = sbEncoding.toString();
                if (sEncoding.equals("bh")) {
                    StringBuffer sbValue = new StringBuffer();
                    while ((iChar = oSR.read()) != 62) {
                        sbValue.append((char)iChar);
                    }
                    String sValue = sbValue.toString();
                    oBAOS.write(Integer.parseInt(sValue, 16));
                    continue;
                }
                throw new Exception("Unknown encoding type: " + sEncoding);
            }
            oBAOS.write(iChar);
        }
        return oBAOS.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compareFilePrefix(File oFile, byte[] abyExpected) throws Exception {
        BufferedInputStream oBIS = new BufferedInputStream(new FileInputStream(oFile));
        try {
            ByteArrayOutputStream oBAOS = new ByteArrayOutputStream();
            ByteArrayInputStream oBAIS = new ByteArrayInputStream(abyExpected);
            for (int i = 0; i < abyExpected.length; ++i) {
                int iFileByte = ((InputStream)oBIS).read();
                oBAOS.write(iFileByte);
                int iExpectedByte = oBAIS.read();
                if (iFileByte == iExpectedByte) continue;
                throw new Exception("File contents [" + ID3Util.convertBytesToHexString(oBAOS.toByteArray(), true) + "] do not match expected bytes [" + ID3Util.convertBytesToHexString(abyExpected, true) + "].");
            }
        }
        finally {
            ((InputStream)oBIS).close();
        }
    }
}

