/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.maven.plugin.tomcat7.run;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.apache.tomcat.maven:tomcat7-maven-plugin:2.0-rev1355866_cl", 0);
        this.append(sb, "", 0);
        this.append(sb, "Apache Tomcat Maven Plugin :: Tomcat 7.x", 0);
        this.append(sb, "The Tomcat Maven Plugin provides goals to manipulate WAR projects within the Tomcat 7.x servlet container.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 10 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "deploy".equals(this.goal)) {
            this.append(sb, "tomcat7:deploy", 0);
            this.append(sb, "Deploy a WAR to Tomcat.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "charset (Default: ISO-8859-1)", 2);
                this.append(sb, "The URL encoding charset to use when communicating with Tomcat manager.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${maven.tomcat.charset}", 3);
                this.append(sb, "", 0);
                this.append(sb, "contextFile", 2);
                this.append(sb, "The path of the Tomcat context XML file. This is not used for war deployment mode.", 3);
                this.append(sb, "Expression: ${project.build.directory}/${project.build.finalName}/META-INF/context.xml", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignorePackaging (Default: false)", 2);
                this.append(sb, "If set to true ignore if packaging of project is not 'war'.", 3);
                this.append(sb, "Expression: ${tomcat.ignorePackaging}", 3);
                this.append(sb, "", 0);
                this.append(sb, "mode (Default: war)", 2);
                this.append(sb, "The deployment mode to use. This must be either war to deploy the war, context to deploy the context XML file, or both to deploy the war with the context XML file.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${maven.tomcat.mode}", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The password to use for deployment", 3);
                this.append(sb, "Expression: ${tomcat.password}", 3);
                this.append(sb, "", 0);
                this.append(sb, "path (Default: /${project.artifactId})", 2);
                this.append(sb, "The webapp context path to use for the web application being run. This must always start with a forward-slash ('/').", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${maven.tomcat.path}", 3);
                this.append(sb, "", 0);
                this.append(sb, "server", 2);
                this.append(sb, "The server id in settings.xml to use when authenticating with Tomcat manager, or null to use defaults of username admin and no password.", 3);
                this.append(sb, "Expression: ${maven.tomcat.server}", 3);
                this.append(sb, "", 0);
                this.append(sb, "tag", 2);
                this.append(sb, "The Tomcat webapp tag name to use.", 3);
                this.append(sb, "Expression: ${maven.tomcat.tag}", 3);
                this.append(sb, "", 0);
                this.append(sb, "update (Default: false)", 2);
                this.append(sb, "Whether Tomcat should automatically undeploy webapps that already exist when deploying.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${maven.tomcat.update}", 3);
                this.append(sb, "", 0);
                this.append(sb, "url (Default: http://localhost:8080/manager/text)", 2);
                this.append(sb, "The full URL of the Tomcat manager instance to use.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${maven.tomcat.url}", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The tomcat username to use for deployment", 3);
                this.append(sb, "Expression: ${tomcat.username}", 3);
                this.append(sb, "", 0);
                this.append(sb, "warFile", 2);
                this.append(sb, "The path of the WAR file to deploy.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${project.build.directory}/${project.build.finalName}.war", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "deploy-only".equals(this.goal)) {
            this.append(sb, "tomcat7:deploy-only", 0);
            this.append(sb, "Deploy a WAR to Tomcat without forking the package lifecycle", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "charset (Default: ISO-8859-1)", 2);
                this.append(sb, "The URL encoding charset to use when communicating with Tomcat manager.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${maven.tomcat.charset}", 3);
                this.append(sb, "", 0);
                this.append(sb, "contextFile", 2);
                this.append(sb, "The path of the Tomcat context XML file. This is not used for war deployment mode.", 3);
                this.append(sb, "Expression: ${project.build.directory}/${project.build.finalName}/META-INF/context.xml", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignorePackaging (Default: false)", 2);
                this.append(sb, "If set to true ignore if packaging of project is not 'war'.", 3);
                this.append(sb, "Expression: ${tomcat.ignorePackaging}", 3);
                this.append(sb, "", 0);
                this.append(sb, "mode (Default: war)", 2);
                this.append(sb, "The deployment mode to use. This must be either war to deploy the war, context to deploy the context XML file, or both to deploy the war with the context XML file.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${maven.tomcat.mode}", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The password to use for deployment", 3);
                this.append(sb, "Expression: ${tomcat.password}", 3);
                this.append(sb, "", 0);
                this.append(sb, "path (Default: /${project.artifactId})", 2);
                this.append(sb, "The webapp context path to use for the web application being run. This must always start with a forward-slash ('/').", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${maven.tomcat.path}", 3);
                this.append(sb, "", 0);
                this.append(sb, "server", 2);
                this.append(sb, "The server id in settings.xml to use when authenticating with Tomcat manager, or null to use defaults of username admin and no password.", 3);
                this.append(sb, "Expression: ${maven.tomcat.server}", 3);
                this.append(sb, "", 0);
                this.append(sb, "tag", 2);
                this.append(sb, "The Tomcat webapp tag name to use.", 3);
                this.append(sb, "Expression: ${maven.tomcat.tag}", 3);
                this.append(sb, "", 0);
                this.append(sb, "update (Default: false)", 2);
                this.append(sb, "Whether Tomcat should automatically undeploy webapps that already exist when deploying.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${maven.tomcat.update}", 3);
                this.append(sb, "", 0);
                this.append(sb, "url (Default: http://localhost:8080/manager/text)", 2);
                this.append(sb, "The full URL of the Tomcat manager instance to use.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${maven.tomcat.url}", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The tomcat username to use for deployment", 3);
                this.append(sb, "Expression: ${tomcat.username}", 3);
                this.append(sb, "", 0);
                this.append(sb, "warFile", 2);
                this.append(sb, "The path of the WAR file to deploy.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${project.build.directory}/${project.build.finalName}.war", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "exec-war".equals(this.goal)) {
            this.append(sb, "tomcat7:exec-war", 0);
            this.append(sb, "This mojo will create a self executable jar file containing all tomcat classes.\n\nSo you will be able to use only: java -jar createjar.jar to run your webapp without need to install an Apache Tomcat instance.\n\nMore details here: http://tomcat.apache.org/maven-plugin-2.0-beta-1/executable-war-jar.html\n", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "accessLogValveFormat (Default: %h %l %u %t )", 2);
                this.append(sb, "see http://tomcat.apache.org/tomcat-7.0-doc/config/valve.html", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${maven.tomcat.exec.war.accessLogValveFormat}", 3);
                this.append(sb, "", 0);
                this.append(sb, "attachArtifact (Default: true)", 2);
                this.append(sb, "Attach or not the generated artifact to the build (use true if you want to install or deploy it)", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${maven.tomcat.exec.war.attachArtifact}", 3);
                this.append(sb, "", 0);
                this.append(sb, "attachArtifactClassifier (Default: exec-war)", 2);
                this.append(sb, "the classifier to use for the attached/generated artifact", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${maven.tomcat.exec.war.attachArtifactClassifier}", 3);
                this.append(sb, "", 0);
                this.append(sb, "attachArtifactClassifierType (Default: jar)", 2);
                this.append(sb, "the type to use for the attached/generated artifact", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${maven.tomcat.exec.war.attachArtifactType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "buildDirectory (Default: ${project.build.directory})", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectorHttpProtocol (Default: HTTP/1.1)", 2);
                this.append(sb, "which connector protocol to use HTTP/1.1 or org.apache.coyote.http11.Http11NioProtocol", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${maven.tomcat.exec.war.connectorHttpProtocol}", 3);
                this.append(sb, "", 0);
                this.append(sb, "enableNaming (Default: false)", 2);
                this.append(sb, "to enable naming when starting tomcat", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${maven.tomcat.exec.war.enableNaming}", 3);
                this.append(sb, "", 0);
                this.append(sb, "extraDependencies", 2);
                this.append(sb, "list of extra dependencies to add in the standalone tomcat jar: your jdbc driver, mail.jar etc.. Those dependencies will be in root classloader.", 3);
                this.append(sb, "", 0);
                this.append(sb, "extraResources", 2);
                this.append(sb, "list of extra resources to add in the standalone tomcat jar: your logger configuration etc", 3);
                this.append(sb, "", 0);
                this.append(sb, "finalName (Default: ${project.artifactId}-${project.version}-war-exec.jar)", 2);
                this.append(sb, "Name of the generated exec JAR.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${tomcat.jar.finalName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "mainClass (Default: org.apache.tomcat.maven.runner.Tomcat7RunnerCli)", 2);
                this.append(sb, "Main class to use for starting the standalone jar.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${maven.tomcat.exec.war.mainClass}", 3);
                this.append(sb, "", 0);
                this.append(sb, "path (Default: ${project.artifactId})", 2);
                this.append(sb, "The webapp context path to use for the web application being run. The name to store webapp in exec jar. Do not use /", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${maven.tomcat.path}", 3);
                this.append(sb, "", 0);
                this.append(sb, "pluginArtifacts (Default: ${plugin.artifacts})", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "pluginWorkDirectory (Default: ${project.build.directory}/tomcat7-maven-plugin-exec)", 2);
                this.append(sb, "Path under buildDirectory where this mojo may do temporary work.", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverXml (Default: src/main/tomcatconf/server.xml)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Expression: ${maven.tomcat.exec.war.serverXml}", 3);
                this.append(sb, "", 0);
                this.append(sb, "tomcatConfigurationFilesDirectory (Default: src/main/tomcatconf)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Expression: ${maven.tomcat.exec.war.tomcatConf}", 3);
                this.append(sb, "", 0);
                this.append(sb, "warRunDependencies", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "exec-war-only".equals(this.goal)) {
            this.append(sb, "tomcat7:exec-war-only", 0);
            this.append(sb, "(no description available)", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "accessLogValveFormat (Default: %h %l %u %t )", 2);
                this.append(sb, "see http://tomcat.apache.org/tomcat-7.0-doc/config/valve.html", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${maven.tomcat.exec.war.accessLogValveFormat}", 3);
                this.append(sb, "", 0);
                this.append(sb, "attachArtifact (Default: true)", 2);
                this.append(sb, "Attach or not the generated artifact to the build (use true if you want to install or deploy it)", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${maven.tomcat.exec.war.attachArtifact}", 3);
                this.append(sb, "", 0);
                this.append(sb, "attachArtifactClassifier (Default: exec-war)", 2);
                this.append(sb, "the classifier to use for the attached/generated artifact", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${maven.tomcat.exec.war.attachArtifactClassifier}", 3);
                this.append(sb, "", 0);
                this.append(sb, "attachArtifactClassifierType (Default: jar)", 2);
                this.append(sb, "the type to use for the attached/generated artifact", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${maven.tomcat.exec.war.attachArtifactType}", 3);
                this.append(sb, "", 0);
                this.append(sb, "buildDirectory (Default: ${project.build.directory})", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "connectorHttpProtocol (Default: HTTP/1.1)", 2);
                this.append(sb, "which connector protocol to use HTTP/1.1 or org.apache.coyote.http11.Http11NioProtocol", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${maven.tomcat.exec.war.connectorHttpProtocol}", 3);
                this.append(sb, "", 0);
                this.append(sb, "enableNaming (Default: false)", 2);
                this.append(sb, "to enable naming when starting tomcat", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${maven.tomcat.exec.war.enableNaming}", 3);
                this.append(sb, "", 0);
                this.append(sb, "extraDependencies", 2);
                this.append(sb, "list of extra dependencies to add in the standalone tomcat jar: your jdbc driver, mail.jar etc.. Those dependencies will be in root classloader.", 3);
                this.append(sb, "", 0);
                this.append(sb, "extraResources", 2);
                this.append(sb, "list of extra resources to add in the standalone tomcat jar: your logger configuration etc", 3);
                this.append(sb, "", 0);
                this.append(sb, "finalName (Default: ${project.artifactId}-${project.version}-war-exec.jar)", 2);
                this.append(sb, "Name of the generated exec JAR.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${tomcat.jar.finalName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "mainClass (Default: org.apache.tomcat.maven.runner.Tomcat7RunnerCli)", 2);
                this.append(sb, "Main class to use for starting the standalone jar.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${maven.tomcat.exec.war.mainClass}", 3);
                this.append(sb, "", 0);
                this.append(sb, "path (Default: ${project.artifactId})", 2);
                this.append(sb, "The webapp context path to use for the web application being run. The name to store webapp in exec jar. Do not use /", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${maven.tomcat.path}", 3);
                this.append(sb, "", 0);
                this.append(sb, "pluginArtifacts (Default: ${plugin.artifacts})", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "pluginWorkDirectory (Default: ${project.build.directory}/tomcat7-maven-plugin-exec)", 2);
                this.append(sb, "Path under buildDirectory where this mojo may do temporary work.", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverXml (Default: src/main/tomcatconf/server.xml)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Expression: ${maven.tomcat.exec.war.serverXml}", 3);
                this.append(sb, "", 0);
                this.append(sb, "tomcatConfigurationFilesDirectory (Default: src/main/tomcatconf)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Expression: ${maven.tomcat.exec.war.tomcatConf}", 3);
                this.append(sb, "", 0);
                this.append(sb, "warRunDependencies", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "tomcat7:help", 0);
            this.append(sb, "Display help information on tomcat7-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0tomcat7:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "run".equals(this.goal)) {
            this.append(sb, "tomcat7:run", 0);
            this.append(sb, "Runs the current project as a dynamic web application using an embedded Tomcat server.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "addContextWarDependencies (Default: false)", 2);
                this.append(sb, "Deprecated. use webapps instead", 3);
                this.append(sb, "", 0);
                this.append(sb, "Will create a tomcat context for each dependencies of war type with 'scope' set to 'tomcat'. In other words, dependencies with:\n\u00a0\u00a0\u00a0<type>war</type>\n\u00a0\u00a0\u00a0<scope>tomcat</scope>\nTo preserve backward compatibility it's false by default.", 3);
                this.append(sb, "Expression: ${maven.tomcat.addContextWarDependencies}", 3);
                this.append(sb, "", 0);
                this.append(sb, "additionalClasspathDirs", 2);
                this.append(sb, "Additional optional directories to add to the embedded tomcat classpath.", 3);
                this.append(sb, "", 0);
                this.append(sb, "additionalConfigFilesDir (Default: ${basedir}/src/main/tomcatconf)", 2);
                this.append(sb, "The directory contains additional configuration Files that copied in the Tomcat conf Directory.", 3);
                this.append(sb, "Expression: ${maven.tomcat.additionalConfigFilesDir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "addWarDependenciesInClassloader (Default: true)", 2);
                this.append(sb, "will add /WEB-INF/lib/*.jar and /WEB-INF/classes from war dependencies in the webappclassloader", 3);
                this.append(sb, "Expression: ${maven.tomcat.addWarDependenciesInClassloader}", 3);
                this.append(sb, "", 0);
                this.append(sb, "ajpPort (Default: 0)", 2);
                this.append(sb, "The AJP port to run the Tomcat server on. By default it's 0 this means won't be started. The ajp connector will be started only for value > 0. Will be exposed as System props and session.executionProperties with key tomcat.maven.ajp.port", 3);
                this.append(sb, "Expression: ${maven.tomcat.ajp.port}", 3);
                this.append(sb, "", 0);
                this.append(sb, "ajpProtocol (Default: org.apache.coyote.ajp.AjpProtocol)", 2);
                this.append(sb, "The AJP protocol to run the Tomcat server on. By default it's ajp. NOTE The ajp connector will be started only if ajpPort > 0. possible values are:\n-\torg.apache.coyote.ajp.AjpProtocol - new blocking Java connector that supports an executor\n-\torg.apache.coyote.ajp.AjpAprProtocol - the APR/native connector.\n", 3);
                this.append(sb, "Expression: ${maven.tomcat.ajp.protocol}", 3);
                this.append(sb, "", 0);
                this.append(sb, "backgroundProcessorDelay (Default: -1)", 2);
                this.append(sb, "represents the delay in seconds between each classPathScanning change invocation", 3);
                this.append(sb, "Expression: ${maven.tomcat.backgroundProcessorDelay}", 3);
                this.append(sb, "", 0);
                this.append(sb, "classLoaderClass", 2);
                this.append(sb, "Class loader class to set.", 3);
                this.append(sb, "", 0);
                this.append(sb, "configurationDir", 2);
                this.append(sb, "The directory to create the Tomcat server configuration under.", 3);
                this.append(sb, "Expression: ${project.build.directory}/tomcat", 3);
                this.append(sb, "", 0);
                this.append(sb, "contextFile", 2);
                this.append(sb, "The path of the Tomcat context XML file.\n\nSince release 2.0, the file is filtered as a maven resource so you can use interpolation tokens ${ }\n", 3);
                this.append(sb, "Expression: ${maven.tomcat.contextFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "contextReloadable (Default: false)", 2);
                this.append(sb, "Force context scanning if you don't use a context file with reloadable = 'true'. The other way to use contextReloadable is to add attribute reloadable = 'true' in your context file.", 3);
                this.append(sb, "Expression: ${maven.tomcat.contextReloadable}", 3);
                this.append(sb, "", 0);
                this.append(sb, "delegate (Default: true)", 2);
                this.append(sb, "Set the 'follow standard delegation model' flag used to configure our ClassLoader.", 3);
                this.append(sb, "Expression: ${tomcat.delegate}", 3);
                this.append(sb, "", 0);
                this.append(sb, "fork (Default: false)", 2);
                this.append(sb, "Set this to true to allow Maven to continue to execute after invoking the run goal.", 3);
                this.append(sb, "Expression: ${maven.tomcat.fork}", 3);
                this.append(sb, "", 0);
                this.append(sb, "httpsPort (Default: 0)", 2);
                this.append(sb, "The https port to run the Tomcat server on. By default it's 0 this means won't be started. The https connector will be started only for value > 0. Will be exposed as System props and session.executionProperties with key tomcat.maven.https.port", 3);
                this.append(sb, "Expression: ${maven.tomcat.httpsPort}", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignorePackaging (Default: false)", 2);
                this.append(sb, "If set to true ignore if packaging of project is not 'war'.", 3);
                this.append(sb, "Expression: ${tomcat.ignorePackaging}", 3);
                this.append(sb, "", 0);
                this.append(sb, "keystoreFile", 2);
                this.append(sb, "Override the default keystoreFile for the HTTPS connector (if enabled)", 3);
                this.append(sb, "", 0);
                this.append(sb, "keystorePass", 2);
                this.append(sb, "Override the default keystorePass for the HTTPS connector (if enabled)", 3);
                this.append(sb, "", 0);
                this.append(sb, "keystoreType (Default: JKS)", 2);
                this.append(sb, "Override the type of keystore file to be used for the server certificate. If not specified, the default value is 'JKS'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "path (Default: /${project.artifactId})", 2);
                this.append(sb, "The webapp context path to use for the web application being run. This must always start with a forward-slash ('/').", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${maven.tomcat.path}", 3);
                this.append(sb, "", 0);
                this.append(sb, "pluginArtifacts", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${plugin.artifacts}", 3);
                this.append(sb, "", 0);
                this.append(sb, "port (Default: 8080)", 2);
                this.append(sb, "The port to run the Tomcat server on. Will be exposed as System props and session.executionProperties with key tomcat.maven.http.port", 3);
                this.append(sb, "Expression: ${maven.tomcat.port}", 3);
                this.append(sb, "", 0);
                this.append(sb, "propertiesPortFilePath", 2);
                this.append(sb, "Will dump port in a properties file (see ports for property names). If empty no file generated", 3);
                this.append(sb, "Expression: ${maven.tomcat.propertiesPortFilePath}", 3);
                this.append(sb, "", 0);
                this.append(sb, "protocol (Default: HTTP/1.1)", 2);
                this.append(sb, "The protocol to run the Tomcat server on. By default it's HTTP/1.1.", 3);
                this.append(sb, "Expression: ${maven.tomcat.protocol}", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverXml", 2);
                this.append(sb, "server.xml to use Note if you use this you must configure in this file your webapp paths.", 3);
                this.append(sb, "Expression: ${maven.tomcat.serverXml}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Skip execution", 3);
                this.append(sb, "Expression: ${maven.tomcat.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "staticContextDocbase", 2);
                this.append(sb, "The static context docroot base fully qualified path if null static context won't be added", 3);
                this.append(sb, "Expression: ${maven.tomcat.staticContextDocbase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "staticContextPath (Default: /)", 2);
                this.append(sb, "The static context", 3);
                this.append(sb, "Expression: ${maven.tomcat.staticContextPath}", 3);
                this.append(sb, "", 0);
                this.append(sb, "systemProperties", 2);
                this.append(sb, "List of System properties to pass to the Tomcat Server.", 3);
                this.append(sb, "", 0);
                this.append(sb, "tomcatLoggingFile", 2);
                this.append(sb, "The path of the Tomcat logging configuration.", 3);
                this.append(sb, "Expression: ${maven.tomcat.tomcatLogging.file}", 3);
                this.append(sb, "", 0);
                this.append(sb, "tomcatUsers", 2);
                this.append(sb, "The path of the Tomcat users XML file.", 3);
                this.append(sb, "Expression: ${maven.tomcat.tomcatUsers.file}", 3);
                this.append(sb, "", 0);
                this.append(sb, "tomcatWebXml", 2);
                this.append(sb, "overriding the providing web.xml to run tomcat", 3);
                this.append(sb, "Expression: ${maven.tomcat.webXml}", 3);
                this.append(sb, "", 0);
                this.append(sb, "uriEncoding (Default: ISO-8859-1)", 2);
                this.append(sb, "The character encoding to use for decoding URIs.", 3);
                this.append(sb, "Expression: ${maven.tomcat.uriEncoding}", 3);
                this.append(sb, "", 0);
                this.append(sb, "useNaming (Default: true)", 2);
                this.append(sb, "Enables or disables naming support for the embedded Tomcat server.\n\nNote: This setting is ignored if you provide a server.xml for your Tomcat. Instead please configure naming in the server.xml.\n", 3);
                this.append(sb, "Expression: ${maven.tomcat.useNaming}", 3);
                this.append(sb, "", 0);
                this.append(sb, "useSeparateTomcatClassLoader (Default: false)", 2);
                this.append(sb, "if true a new classLoader separated from maven core will be created to start tomcat.", 3);
                this.append(sb, "Expression: ${tomcat.useSeparateTomcatClassLoader}", 3);
                this.append(sb, "", 0);
                this.append(sb, "useTestClasspath (Default: false)", 2);
                this.append(sb, "will use the test classpath rather than the compile one and will add test dependencies too", 3);
                this.append(sb, "Expression: ${maven.tomcat.useTestClasspath}", 3);
                this.append(sb, "", 0);
                this.append(sb, "warSourceDirectory (Default: ${basedir}/src/main/webapp)", 2);
                this.append(sb, "The web resources directory for the web application being run.", 3);
                this.append(sb, "Expression: ${tomcat.warSourceDirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "webapps", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "run-war".equals(this.goal)) {
            this.append(sb, "tomcat7:run-war", 0);
            this.append(sb, "Runs the current project as a packaged web application using an embedded Tomcat server.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "addContextWarDependencies (Default: false)", 2);
                this.append(sb, "Deprecated. use webapps instead", 3);
                this.append(sb, "", 0);
                this.append(sb, "Will create a tomcat context for each dependencies of war type with 'scope' set to 'tomcat'. In other words, dependencies with:\n\u00a0\u00a0\u00a0<type>war</type>\n\u00a0\u00a0\u00a0<scope>tomcat</scope>\nTo preserve backward compatibility it's false by default.", 3);
                this.append(sb, "Expression: ${maven.tomcat.addContextWarDependencies}", 3);
                this.append(sb, "", 0);
                this.append(sb, "additionalConfigFilesDir (Default: ${basedir}/src/main/tomcatconf)", 2);
                this.append(sb, "The directory contains additional configuration Files that copied in the Tomcat conf Directory.", 3);
                this.append(sb, "Expression: ${maven.tomcat.additionalConfigFilesDir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "ajpPort (Default: 0)", 2);
                this.append(sb, "The AJP port to run the Tomcat server on. By default it's 0 this means won't be started. The ajp connector will be started only for value > 0. Will be exposed as System props and session.executionProperties with key tomcat.maven.ajp.port", 3);
                this.append(sb, "Expression: ${maven.tomcat.ajp.port}", 3);
                this.append(sb, "", 0);
                this.append(sb, "ajpProtocol (Default: org.apache.coyote.ajp.AjpProtocol)", 2);
                this.append(sb, "The AJP protocol to run the Tomcat server on. By default it's ajp. NOTE The ajp connector will be started only if ajpPort > 0. possible values are:\n-\torg.apache.coyote.ajp.AjpProtocol - new blocking Java connector that supports an executor\n-\torg.apache.coyote.ajp.AjpAprProtocol - the APR/native connector.\n", 3);
                this.append(sb, "Expression: ${maven.tomcat.ajp.protocol}", 3);
                this.append(sb, "", 0);
                this.append(sb, "classLoaderClass", 2);
                this.append(sb, "Class loader class to set.", 3);
                this.append(sb, "", 0);
                this.append(sb, "configurationDir", 2);
                this.append(sb, "The directory to create the Tomcat server configuration under.", 3);
                this.append(sb, "Expression: ${project.build.directory}/tomcat", 3);
                this.append(sb, "", 0);
                this.append(sb, "contextFile", 2);
                this.append(sb, "The path of the Tomcat context XML file.", 3);
                this.append(sb, "Expression: ${project.build.directory}/${project.build.finalName}/META-INF/context.xml", 3);
                this.append(sb, "", 0);
                this.append(sb, "contextReloadable (Default: false)", 2);
                this.append(sb, "Force context scanning if you don't use a context file with reloadable = 'true'. The other way to use contextReloadable is to add attribute reloadable = 'true' in your context file.", 3);
                this.append(sb, "Expression: ${maven.tomcat.contextReloadable}", 3);
                this.append(sb, "", 0);
                this.append(sb, "fork (Default: false)", 2);
                this.append(sb, "Set this to true to allow Maven to continue to execute after invoking the run goal.", 3);
                this.append(sb, "Expression: ${maven.tomcat.fork}", 3);
                this.append(sb, "", 0);
                this.append(sb, "httpsPort (Default: 0)", 2);
                this.append(sb, "The https port to run the Tomcat server on. By default it's 0 this means won't be started. The https connector will be started only for value > 0. Will be exposed as System props and session.executionProperties with key tomcat.maven.https.port", 3);
                this.append(sb, "Expression: ${maven.tomcat.httpsPort}", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignorePackaging (Default: false)", 2);
                this.append(sb, "If set to true ignore if packaging of project is not 'war'.", 3);
                this.append(sb, "Expression: ${tomcat.ignorePackaging}", 3);
                this.append(sb, "", 0);
                this.append(sb, "keystoreFile", 2);
                this.append(sb, "Override the default keystoreFile for the HTTPS connector (if enabled)", 3);
                this.append(sb, "", 0);
                this.append(sb, "keystorePass", 2);
                this.append(sb, "Override the default keystorePass for the HTTPS connector (if enabled)", 3);
                this.append(sb, "", 0);
                this.append(sb, "keystoreType (Default: JKS)", 2);
                this.append(sb, "Override the type of keystore file to be used for the server certificate. If not specified, the default value is 'JKS'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "path (Default: /${project.artifactId})", 2);
                this.append(sb, "The webapp context path to use for the web application being run. This must always start with a forward-slash ('/').", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${maven.tomcat.path}", 3);
                this.append(sb, "", 0);
                this.append(sb, "pluginArtifacts", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${plugin.artifacts}", 3);
                this.append(sb, "", 0);
                this.append(sb, "port (Default: 8080)", 2);
                this.append(sb, "The port to run the Tomcat server on. Will be exposed as System props and session.executionProperties with key tomcat.maven.http.port", 3);
                this.append(sb, "Expression: ${maven.tomcat.port}", 3);
                this.append(sb, "", 0);
                this.append(sb, "propertiesPortFilePath", 2);
                this.append(sb, "Will dump port in a properties file (see ports for property names). If empty no file generated", 3);
                this.append(sb, "Expression: ${maven.tomcat.propertiesPortFilePath}", 3);
                this.append(sb, "", 0);
                this.append(sb, "protocol (Default: HTTP/1.1)", 2);
                this.append(sb, "The protocol to run the Tomcat server on. By default it's HTTP/1.1.", 3);
                this.append(sb, "Expression: ${maven.tomcat.protocol}", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverXml", 2);
                this.append(sb, "server.xml to use Note if you use this you must configure in this file your webapp paths.", 3);
                this.append(sb, "Expression: ${maven.tomcat.serverXml}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Skip execution", 3);
                this.append(sb, "Expression: ${maven.tomcat.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "staticContextDocbase", 2);
                this.append(sb, "The static context docroot base fully qualified path if null static context won't be added", 3);
                this.append(sb, "Expression: ${maven.tomcat.staticContextDocbase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "staticContextPath (Default: /)", 2);
                this.append(sb, "The static context", 3);
                this.append(sb, "Expression: ${maven.tomcat.staticContextPath}", 3);
                this.append(sb, "", 0);
                this.append(sb, "systemProperties", 2);
                this.append(sb, "List of System properties to pass to the Tomcat Server.", 3);
                this.append(sb, "", 0);
                this.append(sb, "tomcatLoggingFile", 2);
                this.append(sb, "The path of the Tomcat logging configuration.", 3);
                this.append(sb, "Expression: ${maven.tomcat.tomcatLogging.file}", 3);
                this.append(sb, "", 0);
                this.append(sb, "tomcatUsers", 2);
                this.append(sb, "The path of the Tomcat users XML file.", 3);
                this.append(sb, "Expression: ${maven.tomcat.tomcatUsers.file}", 3);
                this.append(sb, "", 0);
                this.append(sb, "tomcatWebXml", 2);
                this.append(sb, "overriding the providing web.xml to run tomcat", 3);
                this.append(sb, "Expression: ${maven.tomcat.webXml}", 3);
                this.append(sb, "", 0);
                this.append(sb, "uriEncoding (Default: ISO-8859-1)", 2);
                this.append(sb, "The character encoding to use for decoding URIs.", 3);
                this.append(sb, "Expression: ${maven.tomcat.uriEncoding}", 3);
                this.append(sb, "", 0);
                this.append(sb, "useNaming (Default: true)", 2);
                this.append(sb, "Enables or disables naming support for the embedded Tomcat server.\n\nNote: This setting is ignored if you provide a server.xml for your Tomcat. Instead please configure naming in the server.xml.\n", 3);
                this.append(sb, "Expression: ${maven.tomcat.useNaming}", 3);
                this.append(sb, "", 0);
                this.append(sb, "useSeparateTomcatClassLoader (Default: false)", 2);
                this.append(sb, "if true a new classLoader separated from maven core will be created to start tomcat.", 3);
                this.append(sb, "Expression: ${tomcat.useSeparateTomcatClassLoader}", 3);
                this.append(sb, "", 0);
                this.append(sb, "warDirectory", 2);
                this.append(sb, "The path of the exploded WAR directory to run.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${project.build.directory}/${project.build.finalName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "webapps", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "run-war-only".equals(this.goal)) {
            this.append(sb, "tomcat7:run-war-only", 0);
            this.append(sb, "Runs the current project as a packaged web application using an embedded Tomcat server without forking the package cycle.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "addContextWarDependencies (Default: false)", 2);
                this.append(sb, "Deprecated. use webapps instead", 3);
                this.append(sb, "", 0);
                this.append(sb, "Will create a tomcat context for each dependencies of war type with 'scope' set to 'tomcat'. In other words, dependencies with:\n\u00a0\u00a0\u00a0<type>war</type>\n\u00a0\u00a0\u00a0<scope>tomcat</scope>\nTo preserve backward compatibility it's false by default.", 3);
                this.append(sb, "Expression: ${maven.tomcat.addContextWarDependencies}", 3);
                this.append(sb, "", 0);
                this.append(sb, "additionalConfigFilesDir (Default: ${basedir}/src/main/tomcatconf)", 2);
                this.append(sb, "The directory contains additional configuration Files that copied in the Tomcat conf Directory.", 3);
                this.append(sb, "Expression: ${maven.tomcat.additionalConfigFilesDir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "ajpPort (Default: 0)", 2);
                this.append(sb, "The AJP port to run the Tomcat server on. By default it's 0 this means won't be started. The ajp connector will be started only for value > 0. Will be exposed as System props and session.executionProperties with key tomcat.maven.ajp.port", 3);
                this.append(sb, "Expression: ${maven.tomcat.ajp.port}", 3);
                this.append(sb, "", 0);
                this.append(sb, "ajpProtocol (Default: org.apache.coyote.ajp.AjpProtocol)", 2);
                this.append(sb, "The AJP protocol to run the Tomcat server on. By default it's ajp. NOTE The ajp connector will be started only if ajpPort > 0. possible values are:\n-\torg.apache.coyote.ajp.AjpProtocol - new blocking Java connector that supports an executor\n-\torg.apache.coyote.ajp.AjpAprProtocol - the APR/native connector.\n", 3);
                this.append(sb, "Expression: ${maven.tomcat.ajp.protocol}", 3);
                this.append(sb, "", 0);
                this.append(sb, "classLoaderClass", 2);
                this.append(sb, "Class loader class to set.", 3);
                this.append(sb, "", 0);
                this.append(sb, "configurationDir", 2);
                this.append(sb, "The directory to create the Tomcat server configuration under.", 3);
                this.append(sb, "Expression: ${project.build.directory}/tomcat", 3);
                this.append(sb, "", 0);
                this.append(sb, "contextFile", 2);
                this.append(sb, "The path of the Tomcat context XML file.", 3);
                this.append(sb, "Expression: ${project.build.directory}/${project.build.finalName}/META-INF/context.xml", 3);
                this.append(sb, "", 0);
                this.append(sb, "contextReloadable (Default: false)", 2);
                this.append(sb, "Force context scanning if you don't use a context file with reloadable = 'true'. The other way to use contextReloadable is to add attribute reloadable = 'true' in your context file.", 3);
                this.append(sb, "Expression: ${maven.tomcat.contextReloadable}", 3);
                this.append(sb, "", 0);
                this.append(sb, "fork (Default: false)", 2);
                this.append(sb, "Set this to true to allow Maven to continue to execute after invoking the run goal.", 3);
                this.append(sb, "Expression: ${maven.tomcat.fork}", 3);
                this.append(sb, "", 0);
                this.append(sb, "httpsPort (Default: 0)", 2);
                this.append(sb, "The https port to run the Tomcat server on. By default it's 0 this means won't be started. The https connector will be started only for value > 0. Will be exposed as System props and session.executionProperties with key tomcat.maven.https.port", 3);
                this.append(sb, "Expression: ${maven.tomcat.httpsPort}", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignorePackaging (Default: false)", 2);
                this.append(sb, "If set to true ignore if packaging of project is not 'war'.", 3);
                this.append(sb, "Expression: ${tomcat.ignorePackaging}", 3);
                this.append(sb, "", 0);
                this.append(sb, "keystoreFile", 2);
                this.append(sb, "Override the default keystoreFile for the HTTPS connector (if enabled)", 3);
                this.append(sb, "", 0);
                this.append(sb, "keystorePass", 2);
                this.append(sb, "Override the default keystorePass for the HTTPS connector (if enabled)", 3);
                this.append(sb, "", 0);
                this.append(sb, "keystoreType (Default: JKS)", 2);
                this.append(sb, "Override the type of keystore file to be used for the server certificate. If not specified, the default value is 'JKS'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "path (Default: /${project.artifactId})", 2);
                this.append(sb, "The webapp context path to use for the web application being run. This must always start with a forward-slash ('/').", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${maven.tomcat.path}", 3);
                this.append(sb, "", 0);
                this.append(sb, "pluginArtifacts", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${plugin.artifacts}", 3);
                this.append(sb, "", 0);
                this.append(sb, "port (Default: 8080)", 2);
                this.append(sb, "The port to run the Tomcat server on. Will be exposed as System props and session.executionProperties with key tomcat.maven.http.port", 3);
                this.append(sb, "Expression: ${maven.tomcat.port}", 3);
                this.append(sb, "", 0);
                this.append(sb, "propertiesPortFilePath", 2);
                this.append(sb, "Will dump port in a properties file (see ports for property names). If empty no file generated", 3);
                this.append(sb, "Expression: ${maven.tomcat.propertiesPortFilePath}", 3);
                this.append(sb, "", 0);
                this.append(sb, "protocol (Default: HTTP/1.1)", 2);
                this.append(sb, "The protocol to run the Tomcat server on. By default it's HTTP/1.1.", 3);
                this.append(sb, "Expression: ${maven.tomcat.protocol}", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverXml", 2);
                this.append(sb, "server.xml to use Note if you use this you must configure in this file your webapp paths.", 3);
                this.append(sb, "Expression: ${maven.tomcat.serverXml}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Skip execution", 3);
                this.append(sb, "Expression: ${maven.tomcat.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "staticContextDocbase", 2);
                this.append(sb, "The static context docroot base fully qualified path if null static context won't be added", 3);
                this.append(sb, "Expression: ${maven.tomcat.staticContextDocbase}", 3);
                this.append(sb, "", 0);
                this.append(sb, "staticContextPath (Default: /)", 2);
                this.append(sb, "The static context", 3);
                this.append(sb, "Expression: ${maven.tomcat.staticContextPath}", 3);
                this.append(sb, "", 0);
                this.append(sb, "systemProperties", 2);
                this.append(sb, "List of System properties to pass to the Tomcat Server.", 3);
                this.append(sb, "", 0);
                this.append(sb, "tomcatLoggingFile", 2);
                this.append(sb, "The path of the Tomcat logging configuration.", 3);
                this.append(sb, "Expression: ${maven.tomcat.tomcatLogging.file}", 3);
                this.append(sb, "", 0);
                this.append(sb, "tomcatUsers", 2);
                this.append(sb, "The path of the Tomcat users XML file.", 3);
                this.append(sb, "Expression: ${maven.tomcat.tomcatUsers.file}", 3);
                this.append(sb, "", 0);
                this.append(sb, "tomcatWebXml", 2);
                this.append(sb, "overriding the providing web.xml to run tomcat", 3);
                this.append(sb, "Expression: ${maven.tomcat.webXml}", 3);
                this.append(sb, "", 0);
                this.append(sb, "uriEncoding (Default: ISO-8859-1)", 2);
                this.append(sb, "The character encoding to use for decoding URIs.", 3);
                this.append(sb, "Expression: ${maven.tomcat.uriEncoding}", 3);
                this.append(sb, "", 0);
                this.append(sb, "useNaming (Default: true)", 2);
                this.append(sb, "Enables or disables naming support for the embedded Tomcat server.\n\nNote: This setting is ignored if you provide a server.xml for your Tomcat. Instead please configure naming in the server.xml.\n", 3);
                this.append(sb, "Expression: ${maven.tomcat.useNaming}", 3);
                this.append(sb, "", 0);
                this.append(sb, "useSeparateTomcatClassLoader (Default: false)", 2);
                this.append(sb, "if true a new classLoader separated from maven core will be created to start tomcat.", 3);
                this.append(sb, "Expression: ${tomcat.useSeparateTomcatClassLoader}", 3);
                this.append(sb, "", 0);
                this.append(sb, "warDirectory", 2);
                this.append(sb, "The path of the exploded WAR directory to run.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${project.build.directory}/${project.build.finalName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "webapps", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "shutdown".equals(this.goal)) {
            this.append(sb, "tomcat7:shutdown", 0);
            this.append(sb, "Shuts down all possibly started embedded tomcat servers. This will be automatically down through a shutdown hook or you may call this Mojo to shut them down explictly.\n\nBy default the shutdown goal is not bound to any phase. For integration tests you might want to bind it to post-integration-test.\n", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "path (Default: /${project.artifactId})", 2);
                this.append(sb, "The webapp context path to use for the web application being run. This must always start with a forward-slash ('/').", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${maven.tomcat.path}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Skip execution", 3);
                this.append(sb, "Expression: ${maven.tomcat.skipShutdown}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipErrorOnShutdown (Default: false)", 2);
                this.append(sb, "Ignore error when shutdown", 3);
                this.append(sb, "Expression: ${maven.tomcat.skipErrorOnShutdown}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "undeploy".equals(this.goal)) {
            this.append(sb, "tomcat7:undeploy", 0);
            this.append(sb, "Undeploy a WAR from Tomcat.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "charset (Default: ISO-8859-1)", 2);
                this.append(sb, "The URL encoding charset to use when communicating with Tomcat manager.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${maven.tomcat.charset}", 3);
                this.append(sb, "", 0);
                this.append(sb, "failOnError (Default: true)", 2);
                this.append(sb, "Whether to fail the build if the web application cannot be undeployed.", 3);
                this.append(sb, "Expression: ${maven.tomcat.failOnError}", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The password to use for deployment", 3);
                this.append(sb, "Expression: ${tomcat.password}", 3);
                this.append(sb, "", 0);
                this.append(sb, "path (Default: /${project.artifactId})", 2);
                this.append(sb, "The webapp context path to use for the web application being run. This must always start with a forward-slash ('/').", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${maven.tomcat.path}", 3);
                this.append(sb, "", 0);
                this.append(sb, "server", 2);
                this.append(sb, "The server id in settings.xml to use when authenticating with Tomcat manager, or null to use defaults of username admin and no password.", 3);
                this.append(sb, "Expression: ${maven.tomcat.server}", 3);
                this.append(sb, "", 0);
                this.append(sb, "url (Default: http://localhost:8080/manager/text)", 2);
                this.append(sb, "The full URL of the Tomcat manager instance to use.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${maven.tomcat.url}", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "The tomcat username to use for deployment", 3);
                this.append(sb, "Expression: ${tomcat.username}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

