/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.CometEvent;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.StringManager;

public class CometEventImpl
implements CometEvent {
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.connector");
    protected Request request = null;
    protected Response response = null;
    protected CometEvent.EventType eventType = CometEvent.EventType.BEGIN;
    protected CometEvent.EventSubType eventSubType = null;

    public CometEventImpl(Request request, Response response) {
        this.request = request;
        this.response = response;
    }

    public void clear() {
        this.request = null;
        this.response = null;
    }

    public void setEventType(CometEvent.EventType eventType) {
        this.eventType = eventType;
    }

    public void setEventSubType(CometEvent.EventSubType eventSubType) {
        this.eventSubType = eventSubType;
    }

    public void close() throws IOException {
        if (this.request == null) {
            throw new IllegalStateException(sm.getString("cometEvent.nullRequest"));
        }
        boolean iscomet = this.request.isComet();
        this.request.setComet(false);
        this.response.finishResponse();
        if (iscomet) {
            this.request.cometClose();
        }
    }

    public CometEvent.EventSubType getEventSubType() {
        return this.eventSubType;
    }

    public CometEvent.EventType getEventType() {
        return this.eventType;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.request.getRequest();
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.response.getResponse();
    }

    public void setTimeout(int timeout) throws IOException, ServletException, UnsupportedOperationException {
        if (this.request.getAttribute("org.apache.tomcat.comet.timeout.support") == Boolean.TRUE) {
            this.request.setAttribute("org.apache.tomcat.comet.timeout", new Integer(timeout));
            if (this.request.isComet()) {
                this.request.setCometTimeout(timeout);
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }
}

