/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.yuicompressor;

import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.Writer;
import java.util.Set;
import org.apache.tapestry5.internal.yuicompressor.AbstractMinimizer;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.services.assets.StreamableResource;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaScriptResourceMinimizer
extends AbstractMinimizer {
    private final Logger logger;
    private static final int RANGE = 5;

    public JavaScriptResourceMinimizer(Logger logger, OperationTracker tracker) {
        super(logger, tracker, "JavaScript");
        this.logger = logger;
    }

    @Override
    protected void doMinimize(StreamableResource resource, Writer output) throws IOException {
        final Set errorLines = CollectionFactory.newSet();
        ErrorReporter errorReporter = new ErrorReporter(){

            private String format(String message, int line, int lineOffset) {
                if (line < 0) {
                    return message;
                }
                return String.format("(%d:%d): %s", line, lineOffset, message);
            }

            public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
                errorLines.add(line);
                JavaScriptResourceMinimizer.this.logger.warn(this.format(message, line, lineOffset));
            }

            public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
                this.error(message, sourceName, line, lineSource, lineOffset);
                return new EvaluatorException(message);
            }

            public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
                errorLines.add(line);
                JavaScriptResourceMinimizer.this.logger.error(this.format(message, line, lineOffset));
            }
        };
        Reader reader = this.toReader(resource);
        try {
            JavaScriptCompressor compressor = new JavaScriptCompressor(reader, errorReporter);
            compressor.compress(output, -1, true, false, false, false);
        }
        catch (EvaluatorException ex) {
            this.logInputLines(resource, errorLines);
            this.recoverFromException((Exception)((Object)ex), resource, output);
        }
        catch (Exception ex) {
            this.recoverFromException(ex, resource, output);
        }
        reader.close();
    }

    private void recoverFromException(Exception ex, StreamableResource resource, Writer output) throws IOException {
        this.logger.error(String.format("Exception minimizing %s: %s", resource.getDescription(), InternalUtils.toMessage((Throwable)ex)), (Throwable)ex);
        this.streamUnminimized(resource, output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void streamUnminimized(StreamableResource resource, Writer output) throws IOException {
        Reader reader = this.toReader(resource);
        char[] buffer = new char[5000];
        try {
            int length;
            while ((length = reader.read(buffer)) >= 0) {
                output.write(buffer, 0, length);
            }
        }
        finally {
            reader.close();
        }
    }

    private void logInputLines(StreamableResource resource, Set<Integer> lines) {
        this.logger.error(String.format("Errors in resource %s:", resource.getDescription()));
        int last = -1;
        try {
            String line;
            LineNumberReader lnr = new LineNumberReader(this.toReader(resource));
            while ((line = lnr.readLine()) != null) {
                int lineNumber = lnr.getLineNumber();
                Where where = this.where(lineNumber, lines);
                if (where == Where.FAR) continue;
                if (last > 0 && last + 1 != lineNumber) {
                    this.logger.error("");
                }
                String formatted = String.format("%s%6d %s", where == Where.EXACT ? "*" : " ", lineNumber, line);
                this.logger.error(formatted);
                last = lineNumber;
            }
            lnr.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    private Where where(int lineNumber, Set<Integer> lines) {
        if (lines.contains(lineNumber)) {
            return Where.EXACT;
        }
        for (int line : lines) {
            if (Math.abs(lineNumber - line) >= 5) continue;
            return Where.NEAR;
        }
        return Where.FAR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Where {
        EXACT,
        NEAR,
        FAR;

    }
}

