/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.tags;

import java.io.IOException;
import javax.portlet.WindowState;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.driver.config.DriverConfiguration;
import org.apache.pluto.driver.core.PortalRequestContext;
import org.apache.pluto.driver.tags.PortletTag;
import org.apache.pluto.driver.tags.ToolTips;
import org.apache.pluto.driver.url.PortalURL;
import org.apache.taglibs.standard.lang.support.ExpressionEvaluatorManager;

public class PortletWindowStateAnchorTag
extends BodyTagSupport {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$pluto$driver$tags$PortletWindowStateAnchorTag == null ? (class$org$apache$pluto$driver$tags$PortletWindowStateAnchorTag = PortletWindowStateAnchorTag.class$("org.apache.pluto.driver.tags.PortletWindowStateAnchorTag")) : class$org$apache$pluto$driver$tags$PortletWindowStateAnchorTag));
    private String state;
    private String portletId;
    private String evaluatedPortletId;
    static /* synthetic */ Class class$org$apache$pluto$driver$tags$PortletWindowStateAnchorTag;
    static /* synthetic */ Class class$org$apache$pluto$driver$tags$PortletTag;
    static /* synthetic */ Class class$java$lang$String;

    public int doStartTag() throws JspException {
        PortletTag parentTag = (PortletTag)TagSupport.findAncestorWithClass((Tag)this, (Class)(class$org$apache$pluto$driver$tags$PortletTag == null ? (class$org$apache$pluto$driver$tags$PortletTag = PortletWindowStateAnchorTag.class$("org.apache.pluto.driver.tags.PortletTag")) : class$org$apache$pluto$driver$tags$PortletTag));
        if (parentTag == null) {
            throw new JspException("Portlet window controls may only reside within a pluto:portlet tag.");
        }
        this.portletId = parentTag.getPortletId();
        this.evaluatePortletId();
        ServletContext servletContext = ((TagSupport)this).pageContext.getServletContext();
        DriverConfiguration driverConfig = (DriverConfiguration)servletContext.getAttribute("driverConfig");
        if (this.isWindowStateAllowed(driverConfig, this.state)) {
            PortalRequestContext portalEnv = PortalRequestContext.getContext((HttpServletRequest)((TagSupport)this).pageContext.getRequest());
            PortalURL portalUrl = portalEnv.createPortalURL();
            portalUrl.setWindowState(this.evaluatedPortletId, new WindowState(this.state));
            StringBuffer tag = new StringBuffer();
            tag.append("<a title=\"");
            tag.append(ToolTips.forWindowState(new WindowState(this.state)));
            tag.append("\" ");
            tag.append("href=\"" + ((Object)portalUrl).toString() + "\">");
            tag.append("<span class=\"" + this.state + "\">");
            tag.append("</span></a>");
            try {
                JspWriter out = ((TagSupport)this).pageContext.getOut();
                out.print(tag.toString());
            }
            catch (IOException ex) {
                throw new JspException((Throwable)ex);
            }
        }
        return 1;
    }

    String getEvaluatedPortletId() {
        return this.evaluatedPortletId;
    }

    private void evaluatePortletId() throws JspException {
        Object obj = ExpressionEvaluatorManager.evaluate((String)"portletId", (String)this.portletId, (Class)(class$java$lang$String == null ? (class$java$lang$String = PortletWindowStateAnchorTag.class$("java.lang.String")) : class$java$lang$String), (Tag)this, (PageContext)((TagSupport)this).pageContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Evaluated portletId to: " + obj));
        }
        this.evaluatedPortletId = (String)obj;
    }

    public String getWindowState() {
        return this.state;
    }

    public void setWindowState(String state) {
        this.state = state;
    }

    private boolean isWindowStateAllowed(DriverConfiguration config, String state) {
        LOG.debug((Object)("Testing if PortletWindowConfig [" + this.getEvaluatedPortletId() + "] supports window state [" + state + "]"));
        return config.isWindowStateSupported(this.getEvaluatedPortletId(), state);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

