/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import opennlp.tools.chunker.ChunkSample;
import opennlp.tools.parser.Parse;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.ObjectStream;

public class ChunkSampleStream
extends FilterObjectStream<Parse, ChunkSample> {
    public ChunkSampleStream(ObjectStream<Parse> in) {
        super(in);
    }

    private static void getInitialChunks(Parse p, List<Parse> ichunks) {
        if (p.isPosTag()) {
            ichunks.add(p);
        } else {
            Parse[] kids = p.getChildren();
            boolean allKidsAreTags = true;
            for (Parse kid : kids) {
                if (kid.isPosTag()) continue;
                allKidsAreTags = false;
                break;
            }
            if (allKidsAreTags) {
                ichunks.add(p);
            } else {
                for (Parse kid : kids) {
                    ChunkSampleStream.getInitialChunks(kid, ichunks);
                }
            }
        }
    }

    public static Parse[] getInitialChunks(Parse p) {
        ArrayList<Parse> chunks = new ArrayList<Parse>();
        ChunkSampleStream.getInitialChunks(p, chunks);
        return chunks.toArray(new Parse[chunks.size()]);
    }

    @Override
    public ChunkSample read() throws IOException {
        Parse parse = (Parse)this.samples.read();
        if (parse != null) {
            Parse[] chunks = ChunkSampleStream.getInitialChunks(parse);
            ArrayList<String> toks = new ArrayList<String>();
            ArrayList<String> tags = new ArrayList<String>();
            ArrayList<Object> preds = new ArrayList<Object>();
            for (Parse c : chunks) {
                Parse[] kids;
                if (c.isPosTag()) {
                    toks.add(c.getCoveredText());
                    tags.add(c.getType());
                    preds.add("O");
                    continue;
                }
                boolean start = true;
                String ctype = c.getType();
                for (Parse tok : kids = c.getChildren()) {
                    toks.add(tok.getCoveredText());
                    tags.add(tok.getType());
                    if (start) {
                        preds.add("S-" + ctype);
                        start = false;
                        continue;
                    }
                    preds.add("C-" + ctype);
                }
            }
            return new ChunkSample(toks.toArray(new String[toks.size()]), tags.toArray(new String[tags.size()]), preds.toArray(new String[preds.size()]));
        }
        return null;
    }
}

