/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.ejbd;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.openejb.client.ClusterMetaData;
import org.apache.openejb.client.ClusterRequest;
import org.apache.openejb.client.ClusterResponse;
import org.apache.openejb.server.DiscoveryListener;
import org.apache.openejb.server.ejbd.EjbDaemon;
import org.apache.openejb.util.Exceptions;
import org.apache.openejb.util.Join;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class ClusterRequestHandler
implements DiscoveryListener {
    private static final Logger logger = Logger.getInstance((LogCategory)LogCategory.OPENEJB_SERVER_REMOTE.createChild("cluster"), ClusterRequestHandler.class);
    private final Data data = new Data();

    public ClusterRequestHandler(EjbDaemon daemon) {
    }

    public void processRequest(ObjectInputStream in, ObjectOutputStream out) throws IOException {
        ClusterRequest req = new ClusterRequest();
        ClusterResponse res = new ClusterResponse();
        try {
            req.readExternal((ObjectInput)in);
        }
        catch (IOException e) {
            res.setFailure((Throwable)e);
            this.sendErrorResponse("Cannot read ClusterRequest", e, res, out);
            throw e;
        }
        catch (ClassNotFoundException e) {
            res.setFailure((Throwable)e);
            this.sendErrorResponse("Cannot read ClusterRequest", e, res, out);
            throw (IOException)new IOException().initCause(e);
        }
        ClusterMetaData currentClusterMetaData = this.data.current();
        if (req.getClusterMetaDataVersion() < currentClusterMetaData.getVersion()) {
            if (logger.isDebugEnabled()) {
                Object[] locations = currentClusterMetaData.getLocations();
                if (locations.length < 10) {
                    logger.debug("Sending client updated cluster locations: [" + Join.join((String)", ", (Object[])locations) + "]");
                } else {
                    logger.debug("Sending client updated cluster locations: " + locations.length + " locations total");
                }
            }
            res.setUpdatedMetaData(currentClusterMetaData);
        } else {
            res.setCurrent();
        }
        try {
            res.writeExternal((ObjectOutput)out);
        }
        catch (IOException e) {
            logger.error("Failed to write to ClusterResponse", (Throwable)e);
            throw e;
        }
    }

    private void sendErrorResponse(String message, Throwable t, ClusterResponse res, ObjectOutputStream out) throws IOException {
        logger.fatal(message, t);
        t = new IOException("The server has encountered a fatal error: " + message + " " + t).initCause(t);
        try {
            res.writeExternal((ObjectOutput)out);
        }
        catch (IOException ie) {
            String m = "Failed to write to ClusterResponse";
            logger.error(m, (Throwable)ie);
            throw Exceptions.newIOException((String)m, (Throwable)ie);
        }
    }

    public void serviceAdded(URI uri) {
        try {
            URI type = uri;
            URI service = this.unwrap(type);
            if ("ejb".equals(type.getScheme())) {
                logger.info("Peer discovered: " + service.toString());
                this.data.add(service);
            }
        }
        catch (URISyntaxException e) {
            logger.error("serviceAdded: Invalid service URI format.  Expected <group>:<type>:<serverURI> but found '" + uri.toString() + "'");
        }
    }

    private URI unwrap(URI uri) throws URISyntaxException {
        return new URI(uri.getSchemeSpecificPart());
    }

    public void serviceRemoved(URI uri) {
        try {
            URI type = uri;
            URI service = this.unwrap(type);
            if ("ejb".equals(type.getScheme())) {
                logger.info("Peer removed: " + service.toString());
                this.data.remove(service);
            }
        }
        catch (URISyntaxException e) {
            logger.error("serviceAdded: Invalid service URI format.  Expected <group>:<type>:<serverURI> but found '" + uri.toString() + "'");
        }
    }

    private static class Data {
        private ClusterMetaData current;
        private ReadWriteLock sync = new ReentrantReadWriteLock();
        private final Set set = new LinkedHashSet();

        public Data() {
            this.current = new ClusterMetaData(0L, new URI[0]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(URI o) {
            Lock lock = this.sync.writeLock();
            lock.lock();
            ClusterMetaData nextVersion = null;
            try {
                if (this.set.add(o)) {
                    nextVersion = Data.newClusterMetaData(this.set, this.current);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                if (nextVersion != null) {
                    this.current = nextVersion;
                }
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Object o) {
            Lock lock = this.sync.writeLock();
            lock.lock();
            ClusterMetaData nextVersion = null;
            try {
                if (this.set.remove(o)) {
                    nextVersion = Data.newClusterMetaData(this.set, this.current);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                if (nextVersion != null) {
                    this.current = nextVersion;
                }
                lock.unlock();
            }
        }

        private static ClusterMetaData newClusterMetaData(Set set, ClusterMetaData current) {
            URI[] locations = new URI[set.size()];
            set.toArray(locations);
            return new ClusterMetaData(System.currentTimeMillis(), locations);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ClusterMetaData current() {
            Lock lock = this.sync.readLock();
            lock.lock();
            try {
                ClusterMetaData clusterMetaData = this.current;
                return clusterMetaData;
            }
            finally {
                lock.unlock();
            }
        }
    }
}

