/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.Handle;
import org.apache.openejb.client.ApplicationException;
import org.apache.openejb.client.ClientMetaData;
import org.apache.openejb.client.ClientRuntimeException;
import org.apache.openejb.client.EJBHomeHandle;
import org.apache.openejb.client.EJBHomeProxy;
import org.apache.openejb.client.EJBHomeProxyHandle;
import org.apache.openejb.client.EJBInvocationHandler;
import org.apache.openejb.client.EJBMetaDataImpl;
import org.apache.openejb.client.EJBObjectHandler;
import org.apache.openejb.client.EJBRequest;
import org.apache.openejb.client.EJBResponse;
import org.apache.openejb.client.EntityEJBHomeHandler;
import org.apache.openejb.client.JNDIContext;
import org.apache.openejb.client.RequestMethodCode;
import org.apache.openejb.client.ServerMetaData;
import org.apache.openejb.client.SingletonEJBHomeHandler;
import org.apache.openejb.client.StatefulEJBHomeHandler;
import org.apache.openejb.client.StatelessEJBHomeHandler;
import org.apache.openejb.client.SystemError;
import org.apache.openejb.client.SystemException;
import org.apache.openejb.client.ThrowableArtifact;
import org.apache.openejb.client.proxy.InvocationHandler;
import org.apache.openejb.client.proxy.ProxyManager;

public abstract class EJBHomeHandler
extends EJBInvocationHandler
implements Externalizable {
    private static final long serialVersionUID = 4212515330775330214L;
    protected static final Method GETEJBMETADATA = EJBHomeHandler.getMethod(EJBHome.class, "getEJBMetaData", null);
    protected static final Method GETHOMEHANDLE = EJBHomeHandler.getMethod(EJBHome.class, "getHomeHandle", null);
    protected static final Method REMOVE_W_KEY = EJBHomeHandler.getMethod(EJBHome.class, "remove", Object.class);
    protected static final Method REMOVE_W_HAND = EJBHomeHandler.getMethod(EJBHome.class, "remove", Handle.class);
    protected static final Method GETHANDLER = EJBHomeHandler.getMethod(EJBHomeProxy.class, "getEJBHomeHandler", null);

    public EJBHomeHandler() {
    }

    public EJBHomeHandler(EJBMetaDataImpl ejb, ServerMetaData server, ClientMetaData client, JNDIContext.AuthenticationInfo auth) {
        super(ejb, server, client, auth);
    }

    public static EJBHomeHandler createEJBHomeHandler(EJBMetaDataImpl ejb, ServerMetaData server, ClientMetaData client, JNDIContext.AuthenticationInfo auth) {
        switch (ejb.type) {
            case 8: 
            case 9: {
                return new EntityEJBHomeHandler(ejb, server, client, auth);
            }
            case 6: {
                return new StatefulEJBHomeHandler(ejb, server, client, auth);
            }
            case 7: {
                return new StatelessEJBHomeHandler(ejb, server, client, auth);
            }
            case 10: {
                return new SingletonEJBHomeHandler(ejb, server, client, auth);
            }
        }
        throw new IllegalStateException("Uknown bean type code '" + ejb.type + "' : " + ejb.toString());
    }

    public EJBHomeProxy createEJBHomeProxy() {
        try {
            Class[] interfaces = new Class[]{this.ejb.homeClass, EJBHomeProxy.class};
            return (EJBHomeProxy)ProxyManager.newProxyInstance(interfaces, (InvocationHandler)this);
        }
        catch (IllegalAccessException e) {
            throw new ClientRuntimeException("Unable to create proxy for " + this.ejb.homeClass, e);
        }
    }

    @Override
    protected Object _invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        try {
            if (method.getDeclaringClass() == Object.class) {
                if (method.equals(TOSTRING)) {
                    return "proxy=" + this;
                }
                if (method.equals(EQUALS)) {
                    return Boolean.FALSE;
                }
                if (method.equals(HASHCODE)) {
                    return this.hashCode();
                }
                throw new UnsupportedOperationException("Unkown method: " + method);
            }
            if (method.getDeclaringClass() == EJBHomeProxy.class) {
                if (method.equals(GETHANDLER)) {
                    return this;
                }
                if (methodName.equals("writeReplace")) {
                    return new EJBHomeProxyHandle(this);
                }
                if (methodName.equals("readResolve")) {
                    throw new UnsupportedOperationException("Unkown method: " + method);
                }
                throw new UnsupportedOperationException("Unkown method: " + method);
            }
            if (methodName.startsWith("create")) {
                return this.create(method, args, proxy);
            }
            if (methodName.startsWith("find")) {
                return this.findX(method, args, proxy);
            }
            if (method.equals(GETEJBMETADATA)) {
                return this.getEJBMetaData(method, args, proxy);
            }
            if (method.equals(GETHOMEHANDLE)) {
                return this.getHomeHandle(method, args, proxy);
            }
            if (method.equals(REMOVE_W_HAND)) {
                return this.removeWithHandle(method, args, proxy);
            }
            if (method.equals(REMOVE_W_KEY)) {
                return this.removeByPrimaryKey(method, args, proxy);
            }
            return this.homeMethod(method, args, proxy);
        }
        catch (SystemException e) {
            this.invalidateReference();
            throw this.convertException(EJBHomeHandler.getCause(e), method);
        }
        catch (ApplicationException ae) {
            throw this.convertException(EJBHomeHandler.getCause(ae), method);
        }
        catch (SystemError se) {
            this.invalidateReference();
            if (this.remote) {
                throw new RemoteException("Container has suffered a SystemException", EJBHomeHandler.getCause(se));
            }
            throw new EJBException("Container has suffered a SystemException").initCause(EJBHomeHandler.getCause(se));
        }
        catch (Throwable oe) {
            if (this.remote) {
                throw new RemoteException("Unknown Client Exception", oe);
            }
            throw new EJBException("Unknown Client Exception").initCause(oe);
        }
    }

    public Object homeMethod(Method method, Object[] args, Object proxy) throws Throwable {
        EJBRequest req = new EJBRequest(RequestMethodCode.EJB_HOME_METHOD, this.ejb, method, args, null, this.client.getSerializer());
        EJBResponse res = this.request(req);
        switch (res.getResponseCode()) {
            case 11: {
                throw new SystemError((ThrowableArtifact)res.getResult());
            }
            case 10: {
                throw new SystemException((ThrowableArtifact)res.getResult());
            }
            case 9: {
                throw new ApplicationException((ThrowableArtifact)res.getResult());
            }
            case 4: {
                return res.getResult();
            }
        }
        throw new RemoteException("Received invalid response code from server: " + res.getResponseCode());
    }

    protected Object create(Method method, Object[] args, Object proxy) throws Throwable {
        EJBRequest req = new EJBRequest(RequestMethodCode.EJB_HOME_CREATE, this.ejb, method, args, null, this.client.getSerializer());
        EJBResponse res = this.request(req);
        switch (res.getResponseCode()) {
            case 11: {
                throw new SystemError((ThrowableArtifact)res.getResult());
            }
            case 10: {
                throw new SystemException((ThrowableArtifact)res.getResult());
            }
            case 9: {
                throw new ApplicationException((ThrowableArtifact)res.getResult());
            }
            case 4: {
                Object primKey = res.getResult();
                EJBObjectHandler handler = EJBObjectHandler.createEJBObjectHandler(this.ejb, this.server, this.client, primKey, this.authenticationInfo);
                handler.setEJBHomeProxy((EJBHomeProxy)proxy);
                return handler.createEJBObjectProxy();
            }
        }
        throw new RemoteException("Received invalid response code from server: " + res.getResponseCode());
    }

    protected abstract Object findX(Method var1, Object[] var2, Object var3) throws Throwable;

    protected Object getEJBMetaData(Method method, Object[] args, Object proxy) throws Throwable {
        return this.ejb;
    }

    protected Object getHomeHandle(Method method, Object[] args, Object proxy) throws Throwable {
        return new EJBHomeHandle((EJBHomeProxy)proxy);
    }

    protected abstract Object removeWithHandle(Method var1, Object[] var2, Object var3) throws Throwable;

    protected abstract Object removeByPrimaryKey(Method var1, Object[] var2, Object var3) throws Throwable;

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }
}

