/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.openejb.client.ClusterMetaData;
import org.apache.openejb.client.ClusterRequest;
import org.apache.openejb.client.ClusterResponse;
import org.apache.openejb.client.Connection;
import org.apache.openejb.client.ConnectionManager;
import org.apache.openejb.client.EJBResponse;
import org.apache.openejb.client.EjbObjectInputStream;
import org.apache.openejb.client.EventLogger;
import org.apache.openejb.client.Exceptions;
import org.apache.openejb.client.Observers;
import org.apache.openejb.client.Options;
import org.apache.openejb.client.ProtocolMetaData;
import org.apache.openejb.client.RemoteFailoverException;
import org.apache.openejb.client.Request;
import org.apache.openejb.client.Response;
import org.apache.openejb.client.RetryException;
import org.apache.openejb.client.ServerMetaData;
import org.apache.openejb.client.ThrowableArtifact;
import org.apache.openejb.client.event.ClientVersion;
import org.apache.openejb.client.event.ClusterMetaDataUpdated;
import org.apache.openejb.client.event.ObserverAdded;
import org.apache.openejb.client.event.RequestFailed;
import org.apache.openejb.client.event.RetryConditionAdded;
import org.apache.openejb.client.event.RetryConditionRemoved;
import org.apache.openejb.client.event.RetryingRequest;
import org.apache.openejb.client.event.ServerAdded;
import org.apache.openejb.client.event.ServerRemoved;

public class Client {
    public static final String OPENEJB_CLIENT_RETRY_CONDITION_MAX = "openejb.client.retry.condition.max";
    private static final String OPENEJB_CLIENT_COMPATIBILITY_VERSION = "openejb.client.protocol.version";
    private static final Logger logger = Logger.getLogger("OpenEJB.client");
    private boolean FINEST = logger.isLoggable(Level.FINEST);
    private boolean FINER = logger.isLoggable(Level.FINER);
    public static final ThreadLocal<Set<URI>> failed = new ThreadLocal();
    private static final ProtocolMetaData PROTOCOL_META_DATA = new ProtocolMetaData();
    private static final int maxConditionRetry = Integer.parseInt(System.getProperty("openejb.client.retry.condition.max", "20"));
    private static Client client = new Client();
    private static final ProtocolMetaData COMPATIBLE_META_DATA;
    private List<Class<? extends Throwable>> retryConditions = new CopyOnWriteArrayList<Class<? extends Throwable>>();
    private boolean retry = false;
    private final Observers observers = new Observers();
    private static final Map<ServerMetaData, Context> contexts;

    public Client() {
        String retryValue = System.getProperty("openejb.client.requestretry", this.getRetry() + "");
        this.retry = Boolean.valueOf(retryValue);
        this.observers.addObserver(new EventLogger());
        this.observers.fireEvent(new ClientVersion());
    }

    public static void addEventObserver(Object observer) {
        if (observer == null) {
            throw new IllegalArgumentException("observer cannot be null");
        }
        if (Client.client.observers.addObserver(observer)) {
            Client.fireEvent(new ObserverAdded(observer));
        }
    }

    public static void removeEventObserver(Object observer) {
        if (observer == null) {
            throw new IllegalArgumentException("observer cannot be null");
        }
        if (Client.client.observers.removeObserver(observer)) {
            Client.fireEvent(new ObserverAdded(observer));
        }
    }

    public static void fireEvent(Object event) {
        Client.client.observers.fireEvent(event);
    }

    public static boolean addRetryCondition(Class<? extends Throwable> throwable) {
        if (throwable == null) {
            throw new IllegalArgumentException("throwable cannot be null");
        }
        boolean add = Client.client.retryConditions.add(throwable);
        if (add) {
            Client.fireEvent(new RetryConditionAdded(throwable));
        }
        return add;
    }

    public static boolean removeRetryCondition(Class<? extends Throwable> throwable) {
        if (throwable == null) {
            throw new IllegalArgumentException("throwable cannot be null");
        }
        boolean remove = Client.client.retryConditions.remove(throwable);
        if (remove) {
            Client.fireEvent(new RetryConditionRemoved(throwable));
        }
        return remove;
    }

    public static void setClient(Client client) {
        if (client == null) {
            throw new IllegalArgumentException("client cannot be null");
        }
        Client.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Response request(Request req, Response res, ServerMetaData server) throws RemoteException {
        try {
            Response response = client.processRequest(req, res, server);
            return response;
        }
        finally {
            failed.remove();
        }
    }

    protected Response processRequest(Request req, Response res, ServerMetaData server) throws RemoteException {
        block80: {
            Connection conn;
            if (server == null) {
                throw new IllegalArgumentException("Server instance cannot be null");
            }
            long start = System.nanoTime();
            ClusterMetaData cluster = Client.getClusterMetaData(server);
            ProtocolMetaData protocolRequest = null != COMPATIBLE_META_DATA ? COMPATIBLE_META_DATA : PROTOCOL_META_DATA;
            try {
                conn = ConnectionManager.getConnection(cluster, server, req);
            }
            catch (IOException e) {
                throw new RemoteException("Unable to connect", e);
            }
            OutputStream out = null;
            InputStream in = null;
            try {
                ThrowableArtifact artifact;
                EJBResponse ejbResponse;
                EjbObjectInputStream objectIn;
                ObjectOutputStream objectOut;
                try {
                    out = conn.getOutputStream();
                }
                catch (IOException e) {
                    throw Exceptions.newIOException("Cannot open output stream to server: ", e);
                }
                try {
                    protocolRequest.writeExternal(out);
                    out.flush();
                }
                catch (IOException e) {
                    throw Exceptions.newIOException("Cannot write the protocol metadata to the server: ", e);
                }
                try {
                    objectOut = new ObjectOutputStream(out);
                }
                catch (IOException e) {
                    throw Exceptions.newIOException("Cannot open object output stream to server: ", e);
                }
                try {
                    server.setMetaData(protocolRequest);
                    server.writeExternal(objectOut);
                }
                catch (IOException e) {
                    throw Exceptions.newIOException("Cannot write the ServerMetaData to the server: ", e);
                }
                try {
                    ClusterRequest clusterRequest = new ClusterRequest(cluster);
                    clusterRequest.setMetaData(protocolRequest);
                    objectOut.write(clusterRequest.getRequestType().getCode());
                    clusterRequest.writeExternal(objectOut);
                }
                catch (Throwable e) {
                    throw Exceptions.newIOException("Cannot write the ClusterMetaData to the server: ", e);
                }
                try {
                    objectOut.write(req.getRequestType().getCode());
                }
                catch (IOException e) {
                    throw Exceptions.newIOException("Cannot write the request type to the server: ", e);
                }
                try {
                    req.setMetaData(protocolRequest);
                    req.writeExternal(objectOut);
                    objectOut.flush();
                    out.flush();
                }
                catch (NotSerializableException e) {
                    throw new IllegalArgumentException("Object is not serializable: " + e.getMessage());
                }
                catch (IOException e) {
                    throw Exceptions.newIOException("Cannot write the request to the server: " + e.getMessage(), e);
                }
                try {
                    in = conn.getInputStream();
                }
                catch (IOException e) {
                    throw Exceptions.newIOException("Cannot open input stream to server: ", e);
                }
                ProtocolMetaData protocolResponse = new ProtocolMetaData();
                try {
                    protocolResponse.readExternal(in);
                }
                catch (EOFException e) {
                    throw Exceptions.newIOException("Prematurely reached the end of the stream.  " + protocolResponse.getSpec() + " : " + e.getMessage(), e);
                }
                catch (IOException e) {
                    throw Exceptions.newIOException("Cannot determine server protocol version: Received " + protocolResponse.getSpec() + " : " + e.getMessage(), e);
                }
                try {
                    objectIn = new EjbObjectInputStream(in);
                }
                catch (IOException e) {
                    throw Exceptions.newIOException("Cannot open object input stream to server (" + protocolResponse.getSpec() + ") : " + e.getMessage(), e);
                }
                try {
                    ClusterResponse clusterResponse = new ClusterResponse();
                    clusterResponse.setMetaData(protocolResponse);
                    clusterResponse.readExternal(objectIn);
                    switch (clusterResponse.getResponseCode()) {
                        case UPDATE: {
                            Client.setClusterMetaData(server, clusterResponse.getUpdatedMetaData());
                            break;
                        }
                        case FAILURE: {
                            throw clusterResponse.getFailure();
                        }
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new RemoteException("Cannot read the cluster response from the server.  The class for an object being returned is not located in this system:", e);
                }
                catch (IOException e) {
                    throw Exceptions.newIOException("Cannot read the cluster response from the server (" + protocolResponse.getSpec() + ") : " + e.getMessage(), e);
                }
                catch (Throwable e) {
                    throw new RemoteException("Error reading cluster response from server (" + protocolResponse.getSpec() + ") : " + e.getMessage(), e);
                }
                try {
                    res.setMetaData(protocolResponse);
                    res.readExternal(objectIn);
                }
                catch (ClassNotFoundException e) {
                    throw new RemoteException("Cannot read the response from the server.  The class for an object being returned is not located in this system:", e);
                }
                catch (IOException e) {
                    throw Exceptions.newIOException("Cannot read the response from the server (" + protocolResponse.getSpec() + ") : " + e.getMessage(), e);
                }
                catch (Throwable e) {
                    throw new RemoteException("Error reading response from server (" + protocolResponse.getSpec() + ") : " + e.getMessage(), e);
                }
                if (this.retryConditions.size() > 0 && res instanceof EJBResponse && (ejbResponse = (EJBResponse)res).getResult() instanceof ThrowableArtifact && this.retryConditions.contains((artifact = (ThrowableArtifact)ejbResponse.getResult()).getThrowable().getClass())) {
                    throw new RetryException(res);
                }
                if (this.FINEST) {
                    long time = System.nanoTime() - start;
                    String message = String.format("Invocation %sns - %s - Request(%s) - Response(%s)", time, conn.getURI(), req, res);
                    logger.log(Level.FINEST, message);
                }
            }
            catch (RemoteException e) {
                throw e;
            }
            catch (IOException e) {
                URI uri = conn.getURI();
                Set<URI> failed = Client.getFailed();
                Client.fireEvent(new RequestFailed(uri, req, e));
                if (this.FINER) {
                    logger.log(Level.FINER, "Add Failed " + uri.toString());
                }
                failed.add(uri);
                conn.discard();
                if (!(e instanceof RetryException) && !this.getRetry()) break block80;
                try {
                    Client.fireEvent(new RetryingRequest(req, server));
                    this.processRequest(req, res, server);
                }
                catch (RemoteFailoverException re) {
                    throw re;
                }
                catch (RemoteException re) {
                    if (e instanceof RetryException) {
                        Response response = ((RetryException)e).getResponse();
                        return response;
                    }
                    throw new RemoteFailoverException("Cannot complete request.  Retry attempted on " + failed.size() + " servers", e);
                }
            }
            catch (Throwable error) {
                throw new RemoteException("Error while communicating with server: ", error);
            }
            finally {
                if (null != out) {
                    try {
                        out.close();
                    }
                    catch (Throwable e) {}
                }
                if (null != in) {
                    try {
                        in.close();
                    }
                    catch (Throwable e) {}
                }
                if (null != conn) {
                    try {
                        conn.close();
                    }
                    catch (Throwable t) {
                        logger.log(Level.WARNING, "Error closing connection with server: " + t.getMessage(), t);
                    }
                }
            }
        }
        return res;
    }

    public static Set<URI> getFailed() {
        Set<URI> set = failed.get();
        if (set == null) {
            set = new HashSet<URI>();
            failed.set(set);
        }
        return set;
    }

    private static void setClusterMetaData(ServerMetaData server, ClusterMetaData cluster) {
        Context context = Client.getContext(server);
        context.setClusterMetaData(cluster);
    }

    private static ClusterMetaData getClusterMetaData(ServerMetaData server) {
        return Client.getContext(server).getClusterMetaData();
    }

    private boolean getRetry() {
        this.retry = Boolean.valueOf(System.getProperty("openejb.client.requestretry", this.retry + ""));
        return this.retry;
    }

    public static Context getContext(ServerMetaData serverMetaData) {
        Context context = contexts.get(serverMetaData);
        if (context == null) {
            context = new Context(serverMetaData);
            contexts.put(serverMetaData, context);
        }
        return context;
    }

    static {
        String version = System.getProperty(OPENEJB_CLIENT_COMPATIBILITY_VERSION);
        COMPATIBLE_META_DATA = null != version ? new ProtocolMetaData(version) : null;
        contexts = new ConcurrentHashMap<ServerMetaData, Context>();
    }

    public static class Context {
        private final Properties properties = new Properties();
        private final ServerMetaData serverMetaData;
        private ClusterMetaData clusterMetaData;
        private Options options;

        private Context(ServerMetaData serverMetaData) {
            this.serverMetaData = serverMetaData;
            this.clusterMetaData = new ClusterMetaData(0L, serverMetaData.getLocation());
            this.options = new Options(this.properties, new Options(System.getProperties()));
        }

        public ServerMetaData getServerMetaData() {
            return this.serverMetaData;
        }

        public ClusterMetaData getClusterMetaData() {
            return this.clusterMetaData;
        }

        public void setClusterMetaData(ClusterMetaData updated) {
            if (updated == null) {
                throw new IllegalArgumentException("clusterMetaData cannot be null");
            }
            ClusterMetaData previous = this.clusterMetaData;
            this.clusterMetaData = updated;
            if (updated.getConnectionStrategy() == null) {
                updated.setConnectionStrategy(previous.getConnectionStrategy());
            }
            updated.setLastLocation(previous.getLastLocation());
            ClusterMetaDataUpdated clusterMetaDataUpdated = new ClusterMetaDataUpdated(this.serverMetaData, updated, previous);
            Client.fireEvent(clusterMetaDataUpdated);
            HashSet<URI> found = this.locations(updated);
            HashSet<URI> existing = this.locations(previous);
            for (URI uri : this.diff(existing, found)) {
                Client.fireEvent(new ServerAdded(clusterMetaDataUpdated, uri));
            }
            for (URI uri : this.diff(found, existing)) {
                Client.fireEvent(new ServerRemoved(clusterMetaDataUpdated, uri));
            }
        }

        private HashSet<URI> locations(ClusterMetaData updated) {
            return new HashSet<URI>(Arrays.asList(updated.getLocations()));
        }

        public Properties getProperties() {
            return this.properties;
        }

        public Options getOptions() {
            return this.options;
        }

        public Set<URI> diff(Set<URI> a, Set<URI> b) {
            HashSet<URI> diffs = new HashSet<URI>();
            for (URI uri : b) {
                if (a.contains(uri)) continue;
                diffs.add(uri);
            }
            return diffs;
        }
    }
}

