/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.CompManagedBean;
import org.apache.openejb.config.DynamicDeployer;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.EntityBean;
import org.apache.openejb.jee.ManagedBean;
import org.apache.openejb.jee.PersistenceType;
import org.apache.openejb.jee.oejb3.EjbDeployment;
import org.apache.openejb.jee.oejb3.OpenejbJar;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.Messages;
import org.apache.openejb.util.StringTemplate;

public class InitEjbDeployments
implements DynamicDeployer {
    public static Messages messages = new Messages("org.apache.openejb.util.resources");
    public static Logger logger = Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.util.resources");
    private final StringTemplate deploymentIdTemplate;
    private static final String DEPLOYMENT_ID_FORMAT = "openejb.deploymentId.format";

    public InitEjbDeployments() {
        String format = SystemInstance.get().getOptions().get(DEPLOYMENT_ID_FORMAT, "{ejbName}");
        this.deploymentIdTemplate = new StringTemplate(format);
    }

    @Override
    public synchronized AppModule deploy(AppModule appModule) throws OpenEJBException {
        HashSet<String> abstractSchemaNames = new HashSet<String>();
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            for (EnterpriseBean bean : ejbModule.getEjbJar().getEnterpriseBeans()) {
                EntityBean entity;
                String name;
                if (!InitEjbDeployments.isCmpEntity(bean) || (name = (entity = (EntityBean)bean).getAbstractSchemaName()) == null) continue;
                abstractSchemaNames.add(name);
            }
        }
        HashMap<String, String> contextData = new HashMap<String, String>();
        contextData.put("appId", appModule.getModuleId());
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            contextData.put("ejbJarId", ejbModule.getModuleId());
            this.deploy(ejbModule, contextData, abstractSchemaNames);
        }
        contextData.clear();
        return appModule;
    }

    public EjbModule deploy(EjbModule ejbModule) throws OpenEJBException {
        return this.deploy(ejbModule, new HashMap<String, String>(), new HashSet<String>());
    }

    private EjbModule deploy(EjbModule ejbModule, Map<String, String> contextData, Set<String> abstractSchemaNames) throws OpenEJBException {
        OpenejbJar openejbJar;
        contextData.put("moduleId", ejbModule.getModuleId());
        contextData.put("moduleUri", ejbModule.getModuleUri().toString());
        if (ejbModule.getOpenejbJar() != null) {
            openejbJar = ejbModule.getOpenejbJar();
        } else {
            openejbJar = new OpenejbJar();
            ejbModule.setOpenejbJar(openejbJar);
        }
        StringTemplate deploymentIdTemplate = this.deploymentIdTemplate;
        if (openejbJar.getProperties().containsKey(DEPLOYMENT_ID_FORMAT)) {
            String format = openejbJar.getProperties().getProperty(DEPLOYMENT_ID_FORMAT);
            logger.info("Using openejb.deploymentId.format '" + format + "'");
            deploymentIdTemplate = new StringTemplate(format);
        }
        for (EnterpriseBean bean : ejbModule.getEjbJar().getEnterpriseBeans()) {
            EntityBean entity;
            StringTemplate template = deploymentIdTemplate;
            org.apache.openejb.api.EjbDeployment annotation = this.getEjbDeploymentAnnotation(ejbModule, bean);
            EjbDeployment ejbDeployment = (EjbDeployment)openejbJar.getDeploymentsByEjbName().get(bean.getEjbName());
            if (ejbDeployment == null) {
                ejbDeployment = new EjbDeployment();
                ejbDeployment.setEjbName(bean.getEjbName());
                if (annotation != null && this.isDefined(annotation.id())) {
                    template = new StringTemplate(annotation.id());
                    ejbDeployment.setDeploymentId(this.formatDeploymentId(bean, contextData, template));
                } else {
                    ejbDeployment.setDeploymentId(this.formatDeploymentId(bean, contextData, template));
                    if (!(bean instanceof ManagedBean) || !((ManagedBean)bean).isHidden()) {
                        logger.info("Auto-deploying ejb " + bean.getEjbName() + ": EjbDeployment(deployment-id=" + ejbDeployment.getDeploymentId() + ")");
                    }
                }
                openejbJar.getEjbDeployment().add(ejbDeployment);
            } else if (ejbDeployment.getDeploymentId() == null) {
                if (annotation != null && this.isDefined(annotation.id())) {
                    template = new StringTemplate(annotation.id());
                    ejbDeployment.setDeploymentId(this.formatDeploymentId(bean, contextData, template));
                } else {
                    ejbDeployment.setDeploymentId(this.formatDeploymentId(bean, contextData, template));
                    logger.info("Auto-assigning deployment-id for ejb " + bean.getEjbName() + ": EjbDeployment(deployment-id=" + ejbDeployment.getDeploymentId() + ")");
                }
            }
            if (ejbDeployment.getContainerId() == null && annotation != null && this.isDefined(annotation.container())) {
                ejbDeployment.setContainerId(annotation.container());
            }
            if (!InitEjbDeployments.isCmpEntity(bean) || (entity = (EntityBean)bean).getAbstractSchemaName() != null) continue;
            String abstractSchemaName = bean.getEjbName().trim().replaceAll("[ \\t\\n\\r-]+", "_");
            if (abstractSchemaNames.contains(abstractSchemaName)) {
                int i = 2;
                while (abstractSchemaNames.contains(abstractSchemaName + i)) {
                    ++i;
                }
                abstractSchemaName = abstractSchemaName + i;
            }
            abstractSchemaNames.add(abstractSchemaName);
            entity.setAbstractSchemaName(abstractSchemaName);
        }
        return ejbModule;
    }

    private org.apache.openejb.api.EjbDeployment getEjbDeploymentAnnotation(EjbModule ejbModule, EnterpriseBean bean) {
        try {
            Class<?> beanClass = ejbModule.getClassLoader().loadClass(bean.getEjbClass());
            return beanClass.getAnnotation(org.apache.openejb.api.EjbDeployment.class);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private boolean isDefined(String s) {
        return s != null && !"".equals(s);
    }

    private static boolean isCmpEntity(EnterpriseBean bean) {
        return bean instanceof EntityBean && ((EntityBean)bean).getPersistenceType() == PersistenceType.CONTAINER;
    }

    private String formatDeploymentId(EnterpriseBean bean, Map<String, String> contextData, StringTemplate template) {
        contextData.put("ejbType", bean.getClass().getSimpleName());
        contextData.put("ejbClass", bean.getEjbClass());
        int simpleNameIdx = bean.getEjbClass().lastIndexOf(".");
        contextData.put("ejbClass.simpleName", bean.getEjbClass().substring(simpleNameIdx + 1));
        contextData.put("ejbName", bean.getEjbName());
        String name = template.apply(contextData);
        if (bean instanceof CompManagedBean) {
            return name + System.identityHashCode(bean);
        }
        return name;
    }
}

