/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cipher;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Map;
import org.apache.openejb.cipher.PasswordCipher;
import org.apache.openejb.cipher.PasswordCipherException;
import org.apache.xbean.finder.ResourceFinder;

public class PasswordCipherFactory {
    public static PasswordCipher getPasswordCipher(String passwordCipherClass) {
        PasswordCipher cipher;
        try {
            cipher = PasswordCipherFactory.doInternalPasswordCipher(PasswordCipher.class, passwordCipherClass);
        }
        catch (PasswordCipherException initial) {
            try {
                return PasswordCipherFactory.doInternalPasswordCipher(org.apache.openejb.resource.jdbc.cipher.PasswordCipher.class, passwordCipherClass);
            }
            catch (PasswordCipherException ignore) {
                throw initial;
            }
        }
        return cipher;
    }

    private static <T extends PasswordCipher> T doInternalPasswordCipher(Class<T> intf, String passwordCipherClass) {
        Map impls;
        ResourceFinder finder = new ResourceFinder("META-INF/");
        try {
            impls = finder.mapAllImplementations(intf);
        }
        catch (Throwable t) {
            String message = "Password cipher '" + passwordCipherClass + "' not found in META-INF/org.apache.openejb.cipher.PasswordCipher.";
            throw new PasswordCipherException(message, t);
        }
        Class<T> pwdCipher = (Class<T>)impls.get(passwordCipherClass);
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        URL url = tccl.getResource("META-INF/" + intf.getName() + "/" + passwordCipherClass);
        if (url != null) {
            try {
                String clazz = new BufferedReader(new InputStreamReader(url.openStream())).readLine().trim();
                pwdCipher = tccl.loadClass(clazz).asSubclass(intf);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (null == pwdCipher) {
            try {
                try {
                    pwdCipher = Class.forName(passwordCipherClass).asSubclass(intf);
                }
                catch (ClassNotFoundException cnfe) {
                    pwdCipher = tccl.loadClass(passwordCipherClass).asSubclass(intf);
                }
            }
            catch (Throwable t) {
                String message = "Cannot load password cipher class '" + passwordCipherClass + "'";
                throw new PasswordCipherException(message, t);
            }
        }
        try {
            return (T)((PasswordCipher)pwdCipher.newInstance());
        }
        catch (Throwable t) {
            String message = "Cannot create password cipher instance";
            throw new PasswordCipherException("Cannot create password cipher instance", t);
        }
    }
}

