/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.loader;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.openejb.loader.Embedder;
import org.apache.openejb.loader.Files;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.LocationResolver;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.loader.Zips;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class ProvisioningUtil {
    private static final SAXParserFactory FACTORY = SAXParserFactory.newInstance();
    public static final String OPENEJB_DEPLOYER_CACHE_FOLDER = "openejb.deployer.cache.folder";
    public static final String HTTP_PREFIX = "http";
    public static final String MVN_PREFIX = "mvn:";
    public static final String SNAPSHOT_SUFFIX = "-SNAPSHOT";
    private static final int CONNECT_TIMEOUT = 10000;
    private static final String ADDITIONAL_LIB_CONFIG = "provisioning.properties";
    private static final String REPO1 = "http://repo1.maven.org/maven2/";
    private static final String APACHE_SNAPSHOT = "https://repository.apache.org/snapshots/";
    private static final String ZIP_KEY = "zip";
    private static final String DESTINATION_KEY = "destination";
    private static final String JAR_KEY = "jar";
    public static final String TEMP_DIR = "temp";

    private ProvisioningUtil() {
    }

    public static String cache() {
        return System.getProperty(OPENEJB_DEPLOYER_CACHE_FOLDER, TEMP_DIR);
    }

    public static File cacheFile(String path) {
        return new File(SystemInstance.get().getBase().getDirectory(), ProvisioningUtil.cache() + File.separator + path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String copyTryingProxies(URI source, File destination) throws Exception {
        InputStream is = ProvisioningUtil.inputStreamTryingProxies(source);
        if (is == null) {
            return null;
        }
        try {
            IO.copy(is, destination);
        }
        finally {
            IO.close(is);
        }
        return destination.getAbsolutePath();
    }

    public static InputStream inputStreamTryingProxies(URI source) throws Exception {
        URL url = source.toURL();
        for (Proxy proxy : ProxySelector.getDefault().select(source)) {
            try {
                URLConnection urlConnection = url.openConnection(proxy);
                urlConnection.setConnectTimeout(10000);
                return new BufferedInputStream(urlConnection.getInputStream());
            }
            catch (IOException e) {
            }
        }
        return null;
    }

    public static String lastPart(String location) {
        int idx = location.lastIndexOf(47);
        if (idx <= 0) {
            return location;
        }
        return location.substring(idx + 1, location.length());
    }

    public static String realLocation(String rawLocation) {
        if (rawLocation.startsWith(HTTP_PREFIX)) {
            File file = ProvisioningUtil.cacheFile(ProvisioningUtil.lastPart(rawLocation));
            if (file.exists()) {
                return file.getAbsolutePath();
            }
            String path = null;
            try {
                path = ProvisioningUtil.copyTryingProxies(new URI(rawLocation), file);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (path != null) {
                return path;
            }
        }
        try {
            Class<?> clazz = ProvisioningUtil.class.getClassLoader().loadClass("org.apache.openejb.resolver.Resolver");
            LocationResolver instance = (LocationResolver)clazz.newInstance();
            return instance.resolve(rawLocation);
        }
        catch (Throwable e) {
            return ProvisioningUtil.fallback(rawLocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String fallback(String rawLocation) {
        if (rawLocation.startsWith(MVN_PREFIX)) {
            try {
                String repo1Url = ProvisioningUtil.quickMvnUrl(rawLocation.substring(MVN_PREFIX.length()).replace(":", "/"));
                return ProvisioningUtil.realLocation(repo1Url);
            }
            catch (MalformedURLException e1) {
                Logger.getLogger(ProvisioningUtil.class.getName()).severe("Can't find " + rawLocation);
            }
        } else {
            String string;
            File file = ProvisioningUtil.cacheFile(ProvisioningUtil.lastPart(rawLocation));
            URL url = new URL(rawLocation);
            BufferedInputStream is = null;
            try {
                is = new BufferedInputStream(url.openStream());
                IO.copy((InputStream)is, file);
                string = file.getAbsolutePath();
            }
            catch (Throwable throwable) {
                try {
                    IO.close(is);
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            IO.close(is);
            return string;
        }
        return rawLocation;
    }

    public static String quickMvnUrl(String raw) throws MalformedURLException {
        String toParse;
        String base = raw.contains(SNAPSHOT_SUFFIX) && raw.contains("apache") ? APACHE_SNAPSHOT : REPO1;
        StringBuilder builder = new StringBuilder();
        if (!raw.contains("!")) {
            File file = new File(ProvisioningUtil.m2Home() + ProvisioningUtil.mvnArtifactPath(raw, null));
            if (file.exists()) {
                return file.getAbsolutePath();
            }
            builder = new StringBuilder();
            builder.append(base);
            toParse = raw;
        } else {
            int repoIdx = raw.lastIndexOf("!");
            toParse = raw.substring(repoIdx + 1);
            String repo = raw.substring(0, repoIdx);
            builder.append(repo);
            if (!repo.endsWith("/")) {
                builder.append("/");
            }
        }
        builder.append(ProvisioningUtil.mvnArtifactPath(toParse, base));
        return builder.toString();
    }

    private static String m2Home() {
        return SystemInstance.get().getProperty("openejb.m2.home", System.getProperty("user.home") + "/.m2/repository/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String mvnArtifactPath(String toParse, String snapshotBase) throws MalformedURLException {
        String artifactVersion;
        StringBuilder builder = new StringBuilder();
        String[] segments = toParse.split("/");
        if (segments.length < 3) {
            throw new MalformedURLException("Invalid path. " + toParse);
        }
        String group = segments[0];
        if (group.trim().isEmpty()) {
            throw new MalformedURLException("Invalid groupId. " + toParse);
        }
        builder.append(group.replace('.', '/')).append("/");
        String artifact = segments[1];
        if (artifact.trim().isEmpty()) {
            throw new MalformedURLException("Invalid artifactId. " + toParse);
        }
        builder.append(artifact).append("/");
        String version = segments[2];
        if (version.trim().isEmpty()) {
            throw new MalformedURLException("Invalid artifactId. " + toParse);
        }
        builder.append(version).append("/");
        if (snapshotBase != null && snapshotBase.startsWith(HTTP_PREFIX) && version.endsWith(SNAPSHOT_SUFFIX)) {
            String meta = snapshotBase + builder.toString() + "maven-metadata.xml";
            URL url = new URL(meta);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            InputStream is = null;
            try {
                is = ProvisioningUtil.inputStreamTryingProxies(url.toURI());
                IO.copy(is, (OutputStream)out);
                artifactVersion = ProvisioningUtil.extractLastSnapshotVersion(version, new ByteArrayInputStream(out.toByteArray()));
            }
            catch (Exception e) {
                artifactVersion = version;
            }
            finally {
                IO.close(is);
            }
        } else {
            artifactVersion = version;
        }
        String type = JAR_KEY;
        if (segments.length >= 4 && segments[3].trim().length() > 0) {
            type = segments[3];
        }
        String fullClassifier = null;
        if (segments.length >= 5 && segments[4].trim().length() > 0) {
            fullClassifier = "-" + segments[4];
        }
        builder.append(artifact).append("-").append(artifactVersion);
        if (fullClassifier != null) {
            builder.append(fullClassifier);
        }
        return builder.append(".").append(type).toString();
    }

    private static String extractLastSnapshotVersion(String defaultVersion, InputStream metadata) {
        QuickMvnMetadataParser handler = new QuickMvnMetadataParser();
        try {
            SAXParser parser = FACTORY.newSAXParser();
            parser.parse(metadata, (DefaultHandler)handler);
            if (handler.timestamp != null && handler.buildNumber != null) {
                return defaultVersion.substring(0, defaultVersion.length() - SNAPSHOT_SUFFIX.length()) + "-" + handler.timestamp.toString() + "-" + handler.buildNumber.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultVersion;
    }

    public static Collection<File> addAdditionalLibraries() throws IOException {
        File destination;
        String toExtract;
        File conf = SystemInstance.get().getConf(ADDITIONAL_LIB_CONFIG);
        if (conf == null || !conf.exists()) {
            return Collections.emptyList();
        }
        Properties additionalLibProperties = IO.readProperties(conf);
        ArrayList<String> libToCopy = new ArrayList<String>();
        String toCopy = additionalLibProperties.getProperty(JAR_KEY);
        if (toCopy != null) {
            for (String lib : toCopy.split(",")) {
                libToCopy.add(ProvisioningUtil.realLocation(lib.trim()));
            }
        }
        if ((toExtract = additionalLibProperties.getProperty(ZIP_KEY)) != null) {
            for (String zip : toExtract.split(",")) {
                libToCopy.addAll(ProvisioningUtil.extract(ProvisioningUtil.realLocation(zip)));
            }
        }
        if (!(destination = additionalLibProperties.containsKey(DESTINATION_KEY) ? new File(additionalLibProperties.getProperty(DESTINATION_KEY)) : new File(SystemInstance.get().getBase().getDirectory(), Embedder.ADDITIONAL_LIB_FOLDER)).exists()) {
            Files.mkdirs(destination);
        }
        ArrayList<File> newFiles = new ArrayList<File>(libToCopy.size());
        for (String lib : libToCopy) {
            newFiles.add(ProvisioningUtil.copy(new File(lib), destination));
        }
        return newFiles;
    }

    private static File copy(File file, File lib) throws IOException {
        File dest = new File(lib, file.getName());
        if (dest.exists()) {
            return dest;
        }
        IO.copy(file, dest);
        return dest;
    }

    private static Collection<String> extract(String zip) throws IOException {
        File zipFile;
        File extracted;
        File tmp = new File(SystemInstance.get().getBase().getDirectory(), TEMP_DIR);
        if (!tmp.exists()) {
            try {
                Files.mkdirs(tmp);
            }
            catch (Files.FileRuntimeException fre) {
                // empty catch block
            }
        }
        if ((extracted = new File(tmp, (zipFile = new File(ProvisioningUtil.realLocation(zip))).getName().replace(".zip", ""))).exists()) {
            return ProvisioningUtil.list(extracted);
        }
        Files.mkdirs(extracted);
        Zips.unzip(zipFile, extracted);
        return ProvisioningUtil.list(extracted);
    }

    private static Collection<String> list(File dir) {
        if (dir == null) {
            return Collections.emptyList();
        }
        ArrayList<String> libs = new ArrayList<String>();
        File[] files = dir.listFiles();
        if (files == null) {
            return Collections.emptyList();
        }
        for (File file : files) {
            if (file.isDirectory()) {
                libs.addAll(ProvisioningUtil.list(file));
                continue;
            }
            libs.add(file.getAbsolutePath());
        }
        return libs;
    }

    static {
        FACTORY.setNamespaceAware(false);
        FACTORY.setValidating(false);
    }

    private static class QuickMvnMetadataParser
    extends DefaultHandler {
        private boolean readTs;
        private boolean readBn;
        private StringBuilder timestamp;
        private StringBuilder buildNumber;

        private QuickMvnMetadataParser() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("timestamp".equalsIgnoreCase(qName)) {
                this.readTs = true;
                this.timestamp = new StringBuilder();
            } else if ("buildNumber".equalsIgnoreCase(qName)) {
                this.readBn = true;
                this.buildNumber = new StringBuilder();
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.readBn && this.buildNumber != null) {
                this.buildNumber.append(new String(ch, start, length));
            } else if (this.readTs && this.timestamp != null) {
                this.timestamp.append(new String(ch, start, length));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("timestamp".equalsIgnoreCase(qName)) {
                this.readTs = false;
            } else if ("buildNumber".equalsIgnoreCase(qName)) {
                this.readBn = false;
            }
        }
    }
}

