/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.loader;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.JarLocation;
import org.apache.openejb.loader.LoaderRuntimeException;
import org.apache.openejb.loader.TrueFilter;

public class Files {
    private static final Map<String, MessageDigest> DIGESTS = new HashMap<String, MessageDigest>();
    static final List<String> delete = new ArrayList<String>();

    public static File path(String ... parts) {
        File dir = null;
        for (String part : parts) {
            dir = dir == null ? new File(part) : new File(dir, part);
        }
        return null != dir ? dir.getAbsoluteFile() : dir;
    }

    public static File path(File dir, String ... parts) {
        File partFile;
        File base = dir;
        int idx = 0;
        if (parts.length >= 1 && (partFile = new File(parts[0])).exists() && partFile.isAbsolute()) {
            base = partFile;
            idx = 1;
        }
        for (int i = idx; i < parts.length; ++i) {
            base = new File(base, parts[i]);
        }
        return base.getAbsoluteFile();
    }

    public static List<File> collect(File dir, String regex) {
        return Files.collect(dir, Pattern.compile(regex));
    }

    public static List<File> collect(File dir, Pattern pattern) {
        return Files.collect(dir, new PatternFileFilter(pattern));
    }

    public static List<File> collect(File dir, FileFilter filter) {
        File[] files;
        ArrayList<File> accepted = new ArrayList<File>();
        if (filter.accept(dir)) {
            accepted.add(dir);
        }
        if ((files = dir.listFiles()) != null) {
            for (File file : files) {
                accepted.addAll(Files.collect(file, filter));
            }
        }
        return accepted;
    }

    public static File exists(File file, String s) {
        if (!file.exists()) {
            throw new FileDoesNotExistException(s + " does not exist: " + file.getAbsolutePath());
        }
        return file;
    }

    public static File exists(File file) {
        if (!file.exists()) {
            throw new FileDoesNotExistException("Does not exist: " + file.getAbsolutePath());
        }
        return file;
    }

    public static File dir(File file) {
        if (!file.isDirectory()) {
            throw new FileRuntimeException("Not a directory: " + file.getAbsolutePath());
        }
        return file;
    }

    public static File touch(File file) throws IOException {
        if (!file.createNewFile()) {
            throw new FileRuntimeException("Cannot create file: " + file.getAbsolutePath());
        }
        return file;
    }

    public static File file(File file) {
        Files.exists(file);
        if (!file.isFile()) {
            throw new FileRuntimeException("Not a file: " + file.getAbsolutePath());
        }
        return file;
    }

    public static File notHidden(File file) {
        Files.exists(file);
        if (file.isHidden()) {
            throw new FileRuntimeException("File is hidden: " + file.getAbsolutePath());
        }
        return file;
    }

    public static File writable(File file) {
        if (!file.canWrite()) {
            throw new FileRuntimeException("Not writable: " + file.getAbsolutePath());
        }
        return file;
    }

    public static File readable(File file) {
        if (!file.canRead()) {
            throw new FileRuntimeException("Not readable: " + file.getAbsolutePath());
        }
        return file;
    }

    public static File readableFile(File file) {
        return Files.readable(Files.file(file));
    }

    public static File mkdir(File file) {
        if (file.exists()) {
            return file;
        }
        if (!file.mkdirs()) {
            throw new FileRuntimeException("Cannot mkdir: " + file.getAbsolutePath());
        }
        return file;
    }

    public static File mkdir(File file, String name) {
        return Files.mkdir(new File(file, name));
    }

    public static File tmpdir() {
        try {
            File file = null;
            try {
                file = File.createTempFile("temp", "dir");
            }
            catch (Throwable e) {
                File tmp = new File("tmp");
                if (!tmp.exists() && !tmp.mkdirs()) {
                    throw new IOException("Failed to create local tmp directory: " + tmp.getAbsolutePath());
                }
                file = File.createTempFile("temp", "dir", tmp);
            }
            if (!file.delete()) {
                throw new IOException("Failed to create temp dir. Delete failed");
            }
            Files.mkdir(file);
            Files.deleteOnExit(file);
            return file;
        }
        catch (IOException e) {
            throw new FileRuntimeException(e);
        }
    }

    public static File mkparent(File file) {
        Files.mkdirs(file.getParentFile());
        return file;
    }

    public static File mkdirs(File file) {
        if (!file.exists()) {
            if (!file.mkdirs()) {
                throw new FileRuntimeException("Cannot mkdirs: " + file.getAbsolutePath());
            }
            return file;
        }
        return Files.dir(file);
    }

    public static void deleteOnExit(File file) {
        delete.add(file.getAbsolutePath());
        Files.flagForDeleteOnExit(file);
    }

    public static void flagForDeleteOnExit(File file) {
        if (file.exists()) {
            File[] files;
            if (file.isDirectory() && null != (files = file.listFiles())) {
                for (File f : files) {
                    Files.flagForDeleteOnExit(f);
                }
            }
            try {
                file.deleteOnExit();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    private static void delete() {
        for (String path : delete) {
            Files.delete(new File(path));
        }
    }

    public static void delete(File file) {
        if (file.exists()) {
            File[] files;
            if (file.isDirectory() && null != (files = file.listFiles())) {
                for (File f : files) {
                    Files.delete(f);
                }
            }
            try {
                if (!file.delete()) {
                    file.deleteOnExit();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void remove(File file) {
        File[] files;
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File child : files) {
                Files.remove(child);
            }
        }
        if (!file.delete()) {
            throw new IllegalStateException("Could not delete file: " + file.getAbsolutePath());
        }
    }

    public static File select(File dir, String pattern) {
        List<File> matches = Files.collect(dir, pattern);
        if (matches.size() == 0) {
            throw new IllegalStateException(String.format("Missing '%s'", pattern));
        }
        if (matches.size() > 1) {
            throw new IllegalStateException(String.format("Too many found '%s': %s", pattern, Files.join(", ", matches)));
        }
        return matches.get(0);
    }

    private static String join(String delimiter, Collection<File> collection) {
        if (collection.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (File obj : collection) {
            sb.append(obj.getName()).append(delimiter);
        }
        return sb.substring(0, sb.length() - delimiter.length());
    }

    public static Set<URL> listJars(String path) {
        HashSet<URL> set = new HashSet<URL>();
        String token = path;
        if (token.endsWith("*.jar")) {
            File directory = new File(token = token.substring(0, token.length() - "*.jar".length()));
            if (!directory.isDirectory()) {
                return set;
            }
            Object[] filenames = directory.list();
            Arrays.sort(filenames);
            for (Object rawFilename : filenames) {
                File file;
                String filename = ((String)rawFilename).toLowerCase(Locale.ENGLISH);
                if (!filename.endsWith(".jar") || !(file = new File(directory, (String)rawFilename)).isFile()) continue;
                try {
                    set.add(file.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
        } else {
            File file = new File(token);
            if (!file.exists()) {
                return set;
            }
            try {
                set.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        return set;
    }

    public static File toFile(URL url) {
        if ("jar".equals(url.getProtocol())) {
            try {
                String spec = url.getFile();
                int separator = spec.indexOf(33);
                if (separator == -1) {
                    throw new MalformedURLException("no ! found in jar url spec:" + spec);
                }
                return Files.toFile(new URL(spec.substring(0, separator++)));
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(e);
            }
        }
        if ("file".equals(url.getProtocol())) {
            String path = JarLocation.decode(url.getFile());
            if (path.endsWith("!")) {
                path = path.substring(0, path.length() - 1);
            }
            return new File(path);
        }
        throw new IllegalArgumentException("Unsupported URL scheme: " + url.toExternalForm());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String hash(Set<URL> urls, String algo) {
        ArrayList<File> files = new ArrayList<File>();
        for (URL u : urls) {
            File file = Files.toFile(u);
            if (!file.isDirectory()) {
                files.add(file);
                continue;
            }
            files.addAll(Files.collect(file, TrueFilter.INSTANCE));
        }
        MessageDigest digest = DIGESTS.get(algo);
        if (digest == null) {
            try {
                digest = MessageDigest.getInstance(algo);
            }
            catch (NoSuchAlgorithmException e) {
                throw new LoaderRuntimeException(e);
            }
            DIGESTS.put(algo, digest);
        }
        for (File file : files) {
            if (!file.exists()) continue;
            DigestInputStream is = null;
            try {
                is = new DigestInputStream(new FileInputStream(file), digest);
                IO.copy((InputStream)is, (OutputStream)new NoopOutputStream());
            }
            catch (IOException e) {
                IO.close(is);
                continue;
                catch (Throwable throwable) {
                    IO.close(is);
                    throw throwable;
                }
            }
            IO.close(is);
        }
        byte[] hash = digest.digest();
        digest.reset();
        StringBuilder sb = new StringBuilder("");
        for (byte b : hash) {
            sb.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(Files.class.getClassLoader());
        try {
            DeleteThread deleteShutdownHook = new DeleteThread();
            try {
                Runtime.getRuntime().addShutdownHook(deleteShutdownHook);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(loader);
        }
    }

    public static class DeleteThread
    extends Thread {
        @Override
        public void run() {
            Files.delete();
        }
    }

    public static class PatternFileFilter
    implements FileFilter {
        private final Pattern pattern;

        public PatternFileFilter(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean accept(File file) {
            return this.pattern.matcher(file.getName()).matches();
        }
    }

    public static class FileDoesNotExistException
    extends FileRuntimeException {
        public FileDoesNotExistException(String str) {
            super(str);
        }

        public FileDoesNotExistException(Exception e) {
            super(e);
        }
    }

    public static class FileRuntimeException
    extends RuntimeException {
        public FileRuntimeException(String str) {
            super(str);
        }

        public FileRuntimeException(Exception e) {
            super(e);
        }
    }

    public static class NoopOutputStream
    extends OutputStream {
        @Override
        public void write(int b) throws IOException {
        }
    }
}

