/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.criteria;

import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Subquery;
import org.apache.openjpa.kernel.exps.Arguments;
import org.apache.openjpa.kernel.exps.Expression;
import org.apache.openjpa.kernel.exps.ExpressionFactory;
import org.apache.openjpa.kernel.exps.Literal;
import org.apache.openjpa.kernel.exps.Value;
import org.apache.openjpa.kernel.jpql.JPQLExpressionBuilder;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.persistence.criteria.AliasContext;
import org.apache.openjpa.persistence.criteria.BindableParameter;
import org.apache.openjpa.persistence.criteria.CriteriaExpression;
import org.apache.openjpa.persistence.criteria.CriteriaExpressionVisitor;
import org.apache.openjpa.persistence.criteria.CriteriaQueryImpl;
import org.apache.openjpa.persistence.criteria.ExpressionImpl;
import org.apache.openjpa.persistence.criteria.Joins;
import org.apache.openjpa.persistence.criteria.ParameterExpressionImpl;
import org.apache.openjpa.persistence.criteria.PathImpl;
import org.apache.openjpa.persistence.criteria.PredicateImpl;
import org.apache.openjpa.persistence.criteria.SubqueryImpl;
import org.apache.openjpa.persistence.meta.Types;

class Expressions {
    static final String OPEN_BRACE = "(";
    static final String CLOSE_BRACE = ")";
    static final String COMMA = ",";

    Expressions() {
    }

    static Value toValue(ExpressionImpl<?> e, ExpressionFactory factory, CriteriaQueryImpl<?> q) {
        return e == null ? factory.getNull() : e.toValue(factory, q);
    }

    static void setImplicitTypes(Value v1, Value v2, Class<?> expected, CriteriaQueryImpl<?> q) {
        JPQLExpressionBuilder.setImplicitTypes(v1, v2, expected, q.getMetamodel(), q.getParameterTypes(), q.toString());
    }

    static void acceptVisit(CriteriaExpressionVisitor visitor, CriteriaExpression parent, javax.persistence.criteria.Expression<?> ... exprs) {
        if (parent == null) {
            return;
        }
        CriteriaExpressionVisitor.TraversalStyle traversal = visitor.getTraversalStyle(parent);
        switch (traversal) {
            case INFIX: {
                if (exprs == null || exprs.length == 0) {
                    visitor.enter(parent);
                    visitor.exit(parent);
                    return;
                }
                for (int i = 0; i < exprs.length; ++i) {
                    ExpressionImpl e = (ExpressionImpl)exprs[i];
                    if (e != null) {
                        e.acceptVisit(visitor);
                    }
                    if (i + 1 == exprs.length) continue;
                    visitor.enter(parent);
                    visitor.exit(parent);
                }
                break;
            }
            case POSTFIX: {
                Expressions.visitChildren(visitor, exprs);
                visitor.enter(parent);
                visitor.exit(parent);
                break;
            }
            case PREFIX: {
                visitor.enter(parent);
                visitor.exit(parent);
                Expressions.visitChildren(visitor, exprs);
                break;
            }
            case FUNCTION: {
                visitor.enter(parent);
                Expressions.visitChildren(visitor, exprs);
                visitor.exit(parent);
            }
        }
    }

    static void visitChildren(CriteriaExpressionVisitor visitor, javax.persistence.criteria.Expression<?> ... exprs) {
        for (int i = 0; exprs != null && i < exprs.length; ++i) {
            ExpressionImpl e = (ExpressionImpl)exprs[i];
            if (e == null) continue;
            e.acceptVisit(visitor);
        }
    }

    static StringBuilder asValue(AliasContext q, javax.persistence.criteria.Expression<?>[] exps, String connector) {
        StringBuilder buffer = new StringBuilder();
        if (exps == null) {
            return buffer;
        }
        for (int i = 0; i < exps.length; ++i) {
            buffer.append((CharSequence)((ExpressionImpl)exps[i]).asValue(q));
            if (i + 1 == exps.length) continue;
            buffer.append(connector);
        }
        return buffer;
    }

    static StringBuilder asValue(AliasContext q, Object ... params) {
        StringBuilder buffer = new StringBuilder();
        if (params == null) {
            return buffer;
        }
        for (int i = 0; i < params.length; ++i) {
            Object o = params[i];
            if (o == null) {
                if (i + 1 >= params.length || !params[i + 1].equals(COMMA)) continue;
                ++i;
                continue;
            }
            if (o instanceof CriteriaExpression) {
                buffer.append((CharSequence)((CriteriaExpression)o).asValue(q));
                continue;
            }
            buffer.append(o);
        }
        return buffer;
    }

    static <X> List<X> returnCopy(List<X> list) {
        return list == null ? new ArrayList() : new CopyOnWriteArrayList<X>(list);
    }

    static <X> Set<X> returnCopy(Set<X> set) {
        return set == null ? new HashSet() : new CopyOnWriteArraySet<X>(set);
    }

    static Expression and(ExpressionFactory factory, Expression e1, Expression e2) {
        return e1 == null ? e2 : (e2 == null ? e1 : factory.and(e1, e2));
    }

    public static class ListArgument<T>
    extends ExpressionImpl<T> {
        private final ExpressionImpl<?>[] _args;

        public ListArgument(Class<T> cls, ExpressionImpl<?> ... args) {
            super(cls);
            this._args = args;
        }

        @Override
        public Arguments toValue(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            Value[] kvs = new Value[this._args.length];
            int i = 0;
            for (ExpressionImpl<?> arg : this._args) {
                kvs[i++] = arg.toValue(factory, q);
            }
            Arguments e = factory.newArgumentList(kvs);
            e.setImplicitType(this.getJavaType());
            return e;
        }

        @Override
        public void acceptVisit(CriteriaExpressionVisitor visitor) {
            Expressions.acceptVisit(visitor, this, this._args);
        }
    }

    public static class CastAs<Y>
    extends ExpressionImpl<Y> {
        protected final ExpressionImpl<?> actual;

        public CastAs(Class<Y> cast, ExpressionImpl<?> actual) {
            super(cast);
            this.actual = actual;
        }

        @Override
        public Value toValue(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            Value e = this.actual.toValue(factory, q);
            e.setImplicitType(this.getJavaType());
            return e;
        }

        @Override
        public void acceptVisit(CriteriaExpressionVisitor visitor) {
            Expressions.acceptVisit(visitor, this, this.actual);
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            return this.actual.asValue(q);
        }
    }

    public static class Not
    extends PredicateImpl {
        protected final ExpressionImpl<Boolean> e;

        public Not(javax.persistence.criteria.Expression<Boolean> ne) {
            this.e = (ExpressionImpl)ne;
        }

        @Override
        public Expression toKernelExpression(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            return factory.not(this.e.toKernelExpression(factory, q));
        }

        @Override
        public void acceptVisit(CriteriaExpressionVisitor visitor) {
            Expressions.acceptVisit(visitor, this, this.e);
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            return Expressions.asValue(q, "NOT ", this.e);
        }
    }

    public static class Any<X>
    extends SubqueryExpression<X> {
        public Any(Subquery<X> x) {
            super(x);
        }

        @Override
        public Value toValue(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            return factory.any(Expressions.toValue(this.e, factory, q));
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            return Expressions.asValue(q, "ANY", Expressions.OPEN_BRACE, this.e, Expressions.CLOSE_BRACE);
        }
    }

    public static class All<X>
    extends SubqueryExpression<X> {
        public All(Subquery<X> x) {
            super(x);
        }

        @Override
        public Value toValue(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            return factory.all(Expressions.toValue(this.e, factory, q));
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            return Expressions.asValue(q, "ALL", Expressions.OPEN_BRACE, this.e, Expressions.CLOSE_BRACE);
        }
    }

    public static class Exists<X>
    extends SubqueryPredicate<X> {
        public Exists(Subquery<X> x) {
            super(x);
        }

        @Override
        Expression toKernelExpression(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            Expression exists = factory.isNotEmpty(Expressions.toValue(this.e, factory, q));
            return exists;
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            return Expressions.asValue(q, " EXISTS", Expressions.OPEN_BRACE, this.e, Expressions.CLOSE_BRACE);
        }
    }

    public static abstract class SubqueryExpression<X>
    extends ExpressionImpl<X> {
        final SubqueryImpl<X> e;

        public SubqueryExpression(Subquery<X> x) {
            super(x.getJavaType());
            this.e = (SubqueryImpl)x;
        }

        @Override
        public void acceptVisit(CriteriaExpressionVisitor visitor) {
            Expressions.acceptVisit(visitor, this, this.e);
        }
    }

    public static abstract class SubqueryPredicate<X>
    extends PredicateImpl {
        final SubqueryImpl<X> e;

        public SubqueryPredicate(Subquery<X> x) {
            this.e = (SubqueryImpl)x;
        }

        @Override
        public void acceptVisit(CriteriaExpressionVisitor visitor) {
            Expressions.acceptVisit(visitor, this, this.e);
        }
    }

    public static class Length
    extends UnaryFunctionalExpression<Integer> {
        public Length(javax.persistence.criteria.Expression<String> x) {
            super(Integer.class, x);
        }

        @Override
        public Value toValue(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            return factory.stringLength(Expressions.toValue(this.e, factory, q));
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            return Expressions.asValue(q, "LENGTH", Expressions.OPEN_BRACE, this.e, Expressions.CLOSE_BRACE);
        }
    }

    public static class Upper
    extends UnaryFunctionalExpression<String> {
        public Upper(javax.persistence.criteria.Expression<String> x) {
            super(String.class, x);
        }

        @Override
        public Value toValue(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            return factory.toUpperCase(Expressions.toValue(this.e, factory, q));
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            return Expressions.asValue(q, "UPPER", Expressions.OPEN_BRACE, this.e, Expressions.CLOSE_BRACE);
        }
    }

    public static class Lower
    extends UnaryFunctionalExpression<String> {
        public Lower(javax.persistence.criteria.Expression<String> x) {
            super(String.class, x);
        }

        @Override
        public Value toValue(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            return factory.toLowerCase(Expressions.toValue(this.e, factory, q));
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            return Expressions.asValue(q, "LOWER", Expressions.OPEN_BRACE, this.e, Expressions.CLOSE_BRACE);
        }
    }

    public static class SimpleCase<C, R>
    extends ExpressionImpl<R>
    implements CriteriaBuilder.SimpleCase<C, R> {
        private final List<javax.persistence.criteria.Expression<? extends R>> thens = new ArrayList<javax.persistence.criteria.Expression<? extends R>>();
        private final List<javax.persistence.criteria.Expression<C>> whens = new ArrayList<javax.persistence.criteria.Expression<C>>();
        private javax.persistence.criteria.Expression<? extends R> otherwise;
        private javax.persistence.criteria.Expression<C> caseOperand;

        public SimpleCase(Class<R> cls) {
            super(cls);
        }

        public SimpleCase(javax.persistence.criteria.Expression<C> expr) {
            super(null);
            this.caseOperand = expr;
        }

        public javax.persistence.criteria.Expression<C> getExpression() {
            return this.caseOperand;
        }

        public SimpleCase<C, R> when(javax.persistence.criteria.Expression<C> when, javax.persistence.criteria.Expression<? extends R> then) {
            this.whens.add(when);
            this.thens.add(then);
            return this;
        }

        public SimpleCase<C, R> when(C when, javax.persistence.criteria.Expression<? extends R> then) {
            return this.when((C)new Constant<C>(when), (R)then);
        }

        public SimpleCase<C, R> when(C when, R then) {
            return this.when((Object)when, new Constant<R>(then));
        }

        public SimpleCase<C, R> otherwise(javax.persistence.criteria.Expression<? extends R> otherwise) {
            this.otherwise = otherwise;
            return this;
        }

        public SimpleCase<C, R> otherwise(R otherwise) {
            return this.otherwise(new Constant<R>(otherwise));
        }

        @Override
        public Value toValue(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            Value caseOperandExpr = Expressions.toValue((ExpressionImpl)this.caseOperand, factory, q);
            int size = this.whens.size();
            Expression[] exps = new Expression[size];
            for (int i = 0; i < size; ++i) {
                Value when = Expressions.toValue((ExpressionImpl)this.whens.get(i), factory, q);
                Value action = Expressions.toValue((ExpressionImpl)this.thens.get(i), factory, q);
                exps[i] = factory.whenScalar(when, action);
            }
            Value other = Expressions.toValue((ExpressionImpl)this.otherwise, factory, q);
            return factory.simpleCaseExpression(caseOperandExpr, exps, other);
        }

        @Override
        public void acceptVisit(CriteriaExpressionVisitor visitor) {
            visitor.enter(this);
            Expressions.visitChildren(visitor, this.caseOperand);
            for (int i = 0; i < this.whens.size(); ++i) {
                Expressions.visitChildren(visitor, this.whens.get(i));
                Expressions.visitChildren(visitor, this.thens.get(i));
            }
            Expressions.visitChildren(visitor, this.otherwise);
            visitor.exit(this);
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            StringBuilder buffer = new StringBuilder("CASE ");
            int size = this.whens.size();
            for (int i = 0; i < size; ++i) {
                buffer.append((CharSequence)Expressions.asValue(q, " WHEN ", this.whens.get(i), " THEN ", this.thens.get(i)));
            }
            buffer.append((CharSequence)Expressions.asValue(q, " ELSE ", this.otherwise, " END"));
            return buffer;
        }
    }

    public static class Case<T>
    extends ExpressionImpl<T>
    implements CriteriaBuilder.Case<T> {
        private final List<javax.persistence.criteria.Expression<? extends T>> thens = new ArrayList<javax.persistence.criteria.Expression<? extends T>>();
        private final List<javax.persistence.criteria.Expression<Boolean>> whens = new ArrayList<javax.persistence.criteria.Expression<Boolean>>();
        private javax.persistence.criteria.Expression<? extends T> otherwise;

        public Case(Class<T> cls) {
            super(cls);
        }

        public Case<T> when(javax.persistence.criteria.Expression<Boolean> when, javax.persistence.criteria.Expression<? extends T> then) {
            this.whens.add(when);
            this.thens.add(then);
            return this;
        }

        public Case<T> when(javax.persistence.criteria.Expression<Boolean> when, T then) {
            return this.when((javax.persistence.criteria.Expression)when, new Constant<T>(then));
        }

        public Case<T> otherwise(javax.persistence.criteria.Expression<? extends T> otherwise) {
            this.otherwise = otherwise;
            return this;
        }

        public Case<T> otherwise(T otherwise) {
            return this.otherwise(new Constant<T>(otherwise));
        }

        @Override
        public Value toValue(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            int size = this.whens.size();
            Expression[] exps = new Expression[size];
            for (int i = 0; i < size; ++i) {
                Expression expr = ((ExpressionImpl)this.whens.get(i)).toKernelExpression(factory, q);
                Value action = Expressions.toValue((ExpressionImpl)this.thens.get(i), factory, q);
                exps[i] = factory.whenCondition(expr, action);
            }
            Value other = Expressions.toValue((ExpressionImpl)this.otherwise, factory, q);
            return factory.generalCaseExpression(exps, other);
        }

        @Override
        public void acceptVisit(CriteriaExpressionVisitor visitor) {
            visitor.enter(this);
            for (int i = 0; i < this.whens.size(); ++i) {
                Expressions.visitChildren(visitor, this.whens.get(i));
                Expressions.visitChildren(visitor, this.thens.get(i));
            }
            Expressions.visitChildren(visitor, this.otherwise);
            visitor.exit(this);
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            StringBuilder buffer = new StringBuilder("CASE ");
            int size = this.whens.size();
            for (int i = 0; i < size; ++i) {
                buffer.append((CharSequence)Expressions.asValue(q, " WHEN ", this.whens.get(i), " THEN ", this.thens.get(i)));
            }
            buffer.append((CharSequence)Expressions.asValue(q, " ELSE ", this.otherwise, " END"));
            return buffer;
        }
    }

    public static class In<T>
    extends PredicateImpl.Or
    implements CriteriaBuilder.In<T> {
        final ExpressionImpl<T> e;

        public In(javax.persistence.criteria.Expression<?> e) {
            super(new Predicate[0]);
            this.e = (ExpressionImpl)e;
        }

        public javax.persistence.criteria.Expression<T> getExpression() {
            return this.e;
        }

        public In<T> value(T value) {
            this.add(new Equal(this.e, value));
            return this;
        }

        public In<T> value(javax.persistence.criteria.Expression<? extends T> value) {
            this.add(new Equal(this.e, value));
            return this;
        }

        @Override
        public PredicateImpl not() {
            In<T> notIn = new In<T>(this.e);
            notIn.markNegated();
            for (Predicate e : this._exps) {
                notIn.add((javax.persistence.criteria.Expression)e);
            }
            return notIn;
        }

        @Override
        Expression toKernelExpression(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            Expression inExpr = null;
            if (this._exps.size() == 1) {
                Equal e = (Equal)this._exps.get(0);
                ExpressionImpl e2 = e.e2;
                ExpressionImpl e1 = e.e1;
                Class e1JavaType = e1.getJavaType();
                Class e2jt = e2.getJavaType();
                if (BindableParameter.class.isInstance(e2) && ((BindableParameter)BindableParameter.class.cast(e2)).value() != null && (e2jt.isArray() && e2jt.getComponentType().equals(e1JavaType) || Class.class.isInstance(e2jt) || ParameterizedType.class.isInstance(e2jt) && ((ParameterizedType)ParameterizedType.class.cast(e2jt)).getActualTypeArguments().length > 0 && e1JavaType.equals(((ParameterizedType)ParameterizedType.class.cast(e2jt)).getActualTypeArguments()[0]))) {
                    BindableParameter bp = (BindableParameter)BindableParameter.class.cast(e2);
                    Object value = bp.value();
                    this._exps.clear();
                    if (value == null) {
                        this.add(new Equal(e1, null));
                    } else if (value.getClass().isArray()) {
                        int len = Array.getLength(value);
                        for (int i = 0; i < len; ++i) {
                            this.add(new Equal(e1, Array.get(value, i)));
                        }
                    } else if (Collection.class.isInstance(value)) {
                        for (Object item : (Collection)Collection.class.cast(value)) {
                            this.add(new Equal(e1, item));
                        }
                    }
                } else {
                    Value val2 = Expressions.toValue(e2, factory, q);
                    if (!(val2 instanceof Literal)) {
                        Value val1 = Expressions.toValue(e1, factory, q);
                        Expressions.setImplicitTypes(val1, val2, e1.getJavaType(), q);
                        inExpr = factory.contains(val2, val1);
                        return this.isNegated() ? factory.not(inExpr) : inExpr;
                    }
                    if (((Literal)val2).getParseType() == 7) {
                        Collection coll = (Collection)((Literal)val2).getValue();
                        this._exps.clear();
                        for (Object v : coll) {
                            this.add(new Equal(e1, v));
                        }
                    }
                }
            }
            inExpr = super.toKernelExpression(factory, q);
            IsNotNull notNull = new IsNotNull(this.e);
            return factory.and(inExpr, notNull.toKernelExpression(factory, q));
        }

        @Override
        public void acceptVisit(CriteriaExpressionVisitor visitor) {
            super.acceptVisit(visitor);
            Expressions.acceptVisit(visitor, this, this.e);
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            StringBuilder buffer = Expressions.asValue(q, this.e, " IN ", Expressions.OPEN_BRACE);
            for (int i = 0; i < this._exps.size(); ++i) {
                buffer.append((CharSequence)((Equal)this._exps.get((int)i)).e2.asValue(q)).append(i + 1 == this._exps.size() ? Expressions.CLOSE_BRACE : Expressions.COMMA);
            }
            return buffer;
        }
    }

    public static class IsNotNull
    extends PredicateImpl {
        final ExpressionImpl<?> e;

        public IsNotNull(ExpressionImpl<?> e) {
            this.e = e;
        }

        @Override
        public PredicateImpl not() {
            return new IsNull(this.e).markNegated();
        }

        @Override
        Expression toKernelExpression(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            return factory.notEqual(Expressions.toValue(this.e, factory, q), factory.getNull());
        }

        @Override
        public void acceptVisit(CriteriaExpressionVisitor visitor) {
            super.acceptVisit(visitor);
            Expressions.acceptVisit(visitor, this.e, new javax.persistence.criteria.Expression[0]);
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            return Expressions.asValue(q, this.e, " IS NOT NULL");
        }
    }

    public static class IsNull
    extends PredicateImpl {
        final ExpressionImpl<?> e;

        public IsNull(ExpressionImpl<?> e) {
            this.e = e;
        }

        @Override
        public PredicateImpl not() {
            return new IsNotNull(this.e).markNegated();
        }

        @Override
        Expression toKernelExpression(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            return factory.equal(Expressions.toValue(this.e, factory, q), factory.getNull());
        }

        @Override
        public void acceptVisit(CriteriaExpressionVisitor visitor) {
            super.acceptVisit(visitor);
            Expressions.acceptVisit(visitor, this.e, new javax.persistence.criteria.Expression[0]);
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            return Expressions.asValue(q, this.e, " IS NULL");
        }
    }

    public static class Nullif<T>
    extends ExpressionImpl<T> {
        private javax.persistence.criteria.Expression<T> val1;
        private javax.persistence.criteria.Expression<?> val2;

        public Nullif(javax.persistence.criteria.Expression<T> x, javax.persistence.criteria.Expression<?> y) {
            super(x.getJavaType());
            this.val1 = x;
            this.val2 = y;
        }

        public Nullif(javax.persistence.criteria.Expression<T> x, T y) {
            this(x, new Constant<T>(y));
        }

        @Override
        public Value toValue(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            Value value1 = Expressions.toValue((ExpressionImpl)this.val1, factory, q);
            Value value2 = Expressions.toValue((ExpressionImpl)this.val2, factory, q);
            return factory.nullIfExpression(value1, value2);
        }

        @Override
        public void acceptVisit(CriteriaExpressionVisitor visitor) {
            Expressions.acceptVisit(visitor, this, this.val1, this.val2);
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            return Expressions.asValue(q, "NULLIF", Expressions.OPEN_BRACE, this.val1, Expressions.COMMA, this.val2, Expressions.CLOSE_BRACE);
        }
    }

    public static class Coalesce<T>
    extends ExpressionImpl<T>
    implements CriteriaBuilder.Coalesce<T> {
        private final List<javax.persistence.criteria.Expression<? extends T>> values = new ArrayList<javax.persistence.criteria.Expression<? extends T>>();

        public Coalesce(Class<T> cls) {
            super(cls);
        }

        public Coalesce<T> value(T value) {
            this.values.add(new Constant<T>(value));
            return this;
        }

        public Coalesce<T> value(javax.persistence.criteria.Expression<? extends T> value) {
            this.values.add(value);
            return this;
        }

        @Override
        public Value toValue(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            Value[] vs = new Value[this.values.size()];
            int i = 0;
            for (javax.persistence.criteria.Expression<? extends T> expression : this.values) {
                vs[i++] = Expressions.toValue((ExpressionImpl)expression, factory, q);
            }
            return factory.coalesceExpression(vs);
        }

        @Override
        public void acceptVisit(CriteriaExpressionVisitor visitor) {
            Expressions.acceptVisit(visitor, this, this.values.toArray(new ExpressionImpl[this.values.size()]));
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            return Expressions.asValue(q, "COALESCE", Expressions.OPEN_BRACE, Expressions.asValue(q, this.values == null ? null : this.values.toArray(new javax.persistence.criteria.Expression[this.values.size()]), Expressions.COMMA), Expressions.CLOSE_BRACE);
        }
    }

    public static class Like
    extends PredicateImpl {
        public static final String MATCH_MULTICHAR = "%";
        public static final String MATCH_SINGLECHAR = "_";
        final ExpressionImpl<String> str;
        final ExpressionImpl<String> pattern;
        final ExpressionImpl<Character> escapeChar;

        public Like(javax.persistence.criteria.Expression<String> x, javax.persistence.criteria.Expression<String> pattern, javax.persistence.criteria.Expression<Character> escapeChar) {
            this.str = (ExpressionImpl)x;
            this.pattern = (ExpressionImpl)pattern;
            this.escapeChar = (ExpressionImpl)escapeChar;
        }

        public Like(javax.persistence.criteria.Expression<String> x, javax.persistence.criteria.Expression<String> pat, char esc) {
            this(x, pat, new Constant<Character>(Character.class, Character.valueOf(esc)));
        }

        public Like(javax.persistence.criteria.Expression<String> x, javax.persistence.criteria.Expression<String> pattern) {
            this(x, pattern, null);
        }

        public Like(javax.persistence.criteria.Expression<String> x, String pattern) {
            this(x, new Constant<String>(pattern), null);
        }

        public Like(javax.persistence.criteria.Expression<String> x, String pat, javax.persistence.criteria.Expression<Character> esc) {
            this(x, new Constant<String>(pat), esc);
        }

        public Like(javax.persistence.criteria.Expression<String> x, String pat, Character esc) {
            this(x, new Constant<String>(pat), new Constant<Character>(esc));
        }

        @Override
        public Expression toKernelExpression(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            String escapeStr = this.escapeChar == null ? null : ((Character)((Literal)Expressions.toValue(this.escapeChar, factory, q)).getValue()).toString();
            return factory.matches(Expressions.toValue(this.str, factory, q), Expressions.toValue(this.pattern, factory, q), MATCH_SINGLECHAR, MATCH_MULTICHAR, escapeStr);
        }

        @Override
        public void acceptVisit(CriteriaExpressionVisitor visitor) {
            Expressions.acceptVisit(visitor, this, this.str, this.pattern, this.escapeChar);
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            return Expressions.asValue(q, this.str, " LIKE ", this.pattern);
        }
    }

    public static class IsMember<E>
    extends PredicateImpl {
        final ExpressionImpl<E> element;
        final ExpressionImpl<?> collection;

        public IsMember(javax.persistence.criteria.Expression<E> element, javax.persistence.criteria.Expression<?> collection) {
            this.element = (ExpressionImpl)element;
            this.collection = (ExpressionImpl)collection;
        }

        public IsMember(E element, javax.persistence.criteria.Expression<?> collection) {
            this(new Constant<E>(element), collection);
        }

        @Override
        public Expression toKernelExpression(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            Expression contains = factory.contains(Expressions.toValue(this.collection, factory, q), Expressions.toValue(this.element, factory, q));
            return contains;
        }

        @Override
        public void acceptVisit(CriteriaExpressionVisitor visitor) {
            super.acceptVisit(visitor);
            Expressions.acceptVisit(visitor, this.collection, this.element);
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            return Expressions.asValue(q, this.element, "MEMBER OF ", this.collection);
        }
    }

    public static class Index
    extends UnaryFunctionalExpression<Integer> {
        public Index(Joins.List<?, ?> e) {
            super(Integer.class, e);
        }

        @Override
        public Value toValue(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            Value v = Expressions.toValue(this.e, factory, q);
            ClassMetaData meta = ((PathImpl)this.e)._member.fmd.getElement().getTypeMetaData();
            v.setMetaData(meta);
            return factory.index(v);
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            return Expressions.asValue(q, "INDEX", Expressions.OPEN_BRACE, this.e, Expressions.CLOSE_BRACE);
        }
    }

    public static class IsNotEmpty
    extends PredicateImpl {
        final ExpressionImpl<?> collection;

        public IsNotEmpty(javax.persistence.criteria.Expression<?> collection) {
            this.collection = (ExpressionImpl)collection;
        }

        @Override
        public PredicateImpl not() {
            return new IsEmpty(this.collection).markNegated();
        }

        @Override
        Value toValue(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            return Expressions.toValue(this.collection, factory, q);
        }

        @Override
        Expression toKernelExpression(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            Value val = Expressions.toValue(this.collection, factory, q);
            return factory.not(factory.isEmpty(val));
        }

        @Override
        public void acceptVisit(CriteriaExpressionVisitor visitor) {
            super.acceptVisit(visitor);
            Expressions.acceptVisit(visitor, this.collection, new javax.persistence.criteria.Expression[0]);
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            return Expressions.asValue(q, this.collection, " IS NOT EMPTY");
        }
    }

    public static class IsEmpty
    extends PredicateImpl {
        final ExpressionImpl<?> collection;

        public IsEmpty(javax.persistence.criteria.Expression<?> collection) {
            this.collection = (ExpressionImpl)collection;
        }

        @Override
        public PredicateImpl not() {
            return new IsNotEmpty(this.collection).markNegated();
        }

        @Override
        Value toValue(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            return Expressions.toValue(this.collection, factory, q);
        }

        @Override
        Expression toKernelExpression(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            Value val = Expressions.toValue(this.collection, factory, q);
            return factory.isEmpty(val);
        }

        @Override
        public void acceptVisit(CriteriaExpressionVisitor visitor) {
            super.acceptVisit(visitor);
            Expressions.acceptVisit(visitor, this.collection, new javax.persistence.criteria.Expression[0]);
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            return Expressions.asValue(q, this.collection, " IS EMPTY");
        }
    }

    public static class Constant<X>
    extends ExpressionImpl<X> {
        public final Object arg;

        public Constant(Class<X> t, X x) {
            super(t);
            this.arg = x;
        }

        public Constant(X x) {
            this(x == null ? null : x.getClass(), x);
        }

        @Override
        public Value toValue(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            Object value = this.arg;
            Class literalClass = this.getJavaType();
            if (this.arg instanceof ParameterExpressionImpl) {
                return ((ParameterExpressionImpl)this.arg).toValue(factory, q);
            }
            int literalType = 0;
            if (Number.class.isAssignableFrom(literalClass)) {
                literalType = 1;
            } else if (Boolean.class.isAssignableFrom(literalClass)) {
                literalType = 2;
            } else if (String.class.isAssignableFrom(literalClass)) {
                literalType = 3;
            } else if (Enum.class.isAssignableFrom(literalClass)) {
                literalType = 6;
            } else {
                if (Class.class.isAssignableFrom(literalClass)) {
                    literalType = 5;
                    Literal lit = factory.newTypeLiteral(value, 5);
                    ClassMetaData can = ((Types.Entity)q.getRoot().getModel()).meta;
                    Class<?> candidate = can.getDescribedType();
                    if (candidate.isAssignableFrom((Class)value)) {
                        lit.setMetaData(q.getMetamodel().getRepository().getMetaData((Class)value, null, true));
                    } else {
                        lit.setMetaData(can);
                    }
                    return lit;
                }
                if (Collection.class.isAssignableFrom(literalClass)) {
                    literalType = 7;
                }
            }
            return factory.newLiteral(value, literalType);
        }

        @Override
        public void acceptVisit(CriteriaExpressionVisitor visitor) {
            Expressions.acceptVisit(visitor, this, this.arg instanceof javax.persistence.criteria.Expression ? (javax.persistence.criteria.Expression)this.arg : null);
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            if (this.arg == null) {
                return new StringBuilder("NULL");
            }
            Class literalClass = this.getJavaType();
            if (this.arg instanceof ParameterExpressionImpl) {
                return ((ParameterExpressionImpl)this.arg).asValue(q);
            }
            if (Number.class.isAssignableFrom(literalClass)) {
                return new StringBuilder(this.arg.toString());
            }
            if (Boolean.class.isAssignableFrom(literalClass)) {
                return new StringBuilder(this.arg.toString());
            }
            if (String.class.isAssignableFrom(literalClass)) {
                return new StringBuilder("'").append(this.arg.toString()).append("'");
            }
            if (Enum.class.isAssignableFrom(literalClass)) {
                return new StringBuilder(this.arg.toString());
            }
            if (Class.class.isAssignableFrom(literalClass)) {
                return new StringBuilder(((Class)this.arg).getSimpleName());
            }
            if (Collection.class.isAssignableFrom(literalClass)) {
                return new StringBuilder(((Collection)this.arg).toString());
            }
            return new StringBuilder(this.arg.toString());
        }
    }

    public static class Between<Y extends Comparable<Y>>
    extends PredicateImpl.And {
        private final ExpressionImpl<? extends Y> e;
        private final ExpressionImpl<? extends Y> v1;
        private final ExpressionImpl<? extends Y> v2;

        public Between(javax.persistence.criteria.Expression<? extends Y> v, javax.persistence.criteria.Expression<? extends Y> x, javax.persistence.criteria.Expression<? extends Y> y) {
            super(new GreaterThanEqual(v, x), new LessThanEqual(v, y));
            this.e = (ExpressionImpl)v;
            this.v1 = (ExpressionImpl)x;
            this.v2 = (ExpressionImpl)y;
        }

        public Between(javax.persistence.criteria.Expression<? extends Y> v, Y x, Y y) {
            this(v, new Constant<Y>(x), new Constant<Y>(y));
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            return Expressions.asValue(q, this.e, " BETWEEN ", this.v1, " AND ", this.v2);
        }
    }

    public static class LessThanEqual
    extends BinaryLogicalExpression {
        public <X, Y> LessThanEqual(javax.persistence.criteria.Expression<X> x, javax.persistence.criteria.Expression<Y> y) {
            super(x, y);
        }

        public <X> LessThanEqual(javax.persistence.criteria.Expression<X> x, Object y) {
            this(x, (javax.persistence.criteria.Expression<Y>)new Constant<Object>(y));
        }

        @Override
        public PredicateImpl not() {
            return new GreaterThan(this.e1, this.e2).markNegated();
        }

        @Override
        Expression toKernelExpression(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            Value val1 = Expressions.toValue(this.e1, factory, q);
            Value val2 = Expressions.toValue(this.e2, factory, q);
            Expressions.setImplicitTypes(val1, val2, this.e1.getJavaType(), q);
            return factory.lessThanEqual(val1, val2);
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            return Expressions.asValue(q, this.e1, " <= ", this.e2);
        }
    }

    public static class LessThan
    extends BinaryLogicalExpression {
        public <X, Y> LessThan(javax.persistence.criteria.Expression<X> x, javax.persistence.criteria.Expression<Y> y) {
            super(x, y);
        }

        public <X> LessThan(javax.persistence.criteria.Expression<X> x, Object y) {
            this(x, (javax.persistence.criteria.Expression<Y>)new Constant<Object>(y));
        }

        @Override
        public PredicateImpl not() {
            return new GreaterThanEqual(this.e1, this.e2).markNegated();
        }

        @Override
        Expression toKernelExpression(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            Value val1 = Expressions.toValue(this.e1, factory, q);
            Value val2 = Expressions.toValue(this.e2, factory, q);
            Expressions.setImplicitTypes(val1, val2, this.e1.getJavaType(), q);
            return factory.lessThan(val1, val2);
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            return Expressions.asValue(q, this.e1, " < ", this.e2);
        }
    }

    public static class GreaterThanEqual
    extends BinaryLogicalExpression {
        public <X, Y> GreaterThanEqual(javax.persistence.criteria.Expression<X> x, javax.persistence.criteria.Expression<Y> y) {
            super(x, y);
        }

        public <X> GreaterThanEqual(javax.persistence.criteria.Expression<X> x, Object y) {
            this(x, (javax.persistence.criteria.Expression<Y>)new Constant<Object>(y));
        }

        @Override
        public PredicateImpl not() {
            return new LessThan(this.e1, this.e2).markNegated();
        }

        @Override
        Expression toKernelExpression(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            Value val1 = Expressions.toValue(this.e1, factory, q);
            Value val2 = Expressions.toValue(this.e2, factory, q);
            Expressions.setImplicitTypes(val1, val2, this.e1.getJavaType(), q);
            return factory.greaterThanEqual(val1, val2);
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            return Expressions.asValue(q, this.e1, " >= ", this.e2);
        }
    }

    public static class GreaterThan
    extends BinaryLogicalExpression {
        public <X, Y> GreaterThan(javax.persistence.criteria.Expression<X> x, javax.persistence.criteria.Expression<Y> y) {
            super(x, y);
        }

        public <X> GreaterThan(javax.persistence.criteria.Expression<X> x, Object y) {
            this(x, (javax.persistence.criteria.Expression<Y>)new Constant<Object>(y));
        }

        @Override
        public PredicateImpl not() {
            return new LessThanEqual(this.e1, this.e2).markNegated();
        }

        @Override
        Expression toKernelExpression(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            Value val1 = Expressions.toValue(this.e1, factory, q);
            Value val2 = Expressions.toValue(this.e2, factory, q);
            Expressions.setImplicitTypes(val1, val2, this.e1.getJavaType(), q);
            return factory.greaterThan(val1, val2);
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            return Expressions.asValue(q, this.e1, " > ", this.e2);
        }
    }

    public static class NotEqual
    extends BinaryLogicalExpression {
        public <X, Y> NotEqual(javax.persistence.criteria.Expression<X> x, javax.persistence.criteria.Expression<Y> y) {
            super(x, y);
        }

        public <X> NotEqual(javax.persistence.criteria.Expression<X> x, Object y) {
            this(x, (javax.persistence.criteria.Expression<Y>)new Constant<Object>(y));
        }

        @Override
        public PredicateImpl not() {
            return new Equal(this.e1, this.e2).markNegated();
        }

        @Override
        Expression toKernelExpression(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            Value val1 = Expressions.toValue(this.e1, factory, q);
            Value val2 = Expressions.toValue(this.e2, factory, q);
            Expressions.setImplicitTypes(val1, val2, this.e1.getJavaType(), q);
            return factory.notEqual(val1, val2);
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            return Expressions.asValue(q, this.e1, " <> ", this.e2);
        }
    }

    public static class Equal
    extends BinaryLogicalExpression {
        public <X, Y> Equal(javax.persistence.criteria.Expression<X> x, javax.persistence.criteria.Expression<Y> y) {
            super(x, y);
        }

        public <X> Equal(javax.persistence.criteria.Expression<X> x, Object y) {
            this(x, (javax.persistence.criteria.Expression<Y>)new Constant<Object>(y));
        }

        @Override
        public PredicateImpl not() {
            return new NotEqual(this.e1, this.e2).markNegated();
        }

        @Override
        Expression toKernelExpression(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            Value val1 = Expressions.toValue(this.e1, factory, q);
            Value val2 = Expressions.toValue(this.e2, factory, q);
            Expressions.setImplicitTypes(val1, val2, this.e1.getJavaType(), q);
            return factory.equal(val1, val2);
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            return Expressions.asValue(q, this.e1, " = ", this.e2);
        }
    }

    public static class CurrentTimestamp
    extends ExpressionImpl<Timestamp> {
        public CurrentTimestamp() {
            super(Timestamp.class);
        }

        @Override
        public Value toValue(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            return factory.getCurrentTimestamp(this.getJavaType());
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            return new StringBuilder("CURRENT_TIMESTAMP");
        }
    }

    public static class CurrentTime
    extends ExpressionImpl<Time> {
        public CurrentTime() {
            super(Time.class);
        }

        @Override
        public Value toValue(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            return factory.getCurrentTime(this.getJavaType());
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            return new StringBuilder("CURRENT_TIME");
        }
    }

    public static class CurrentDate
    extends ExpressionImpl<Date> {
        public CurrentDate() {
            super(Date.class);
        }

        @Override
        public Value toValue(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            return factory.getCurrentDate(this.getJavaType());
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            return new StringBuilder("CURRENT_DATE");
        }
    }

    public static class Mod
    extends BinarayFunctionalExpression<Integer> {
        public Mod(javax.persistence.criteria.Expression<Integer> x, javax.persistence.criteria.Expression<Integer> y) {
            super(Integer.class, x, y);
        }

        public Mod(javax.persistence.criteria.Expression<Integer> x, Integer y) {
            this(x, new Constant<Integer>(Integer.class, y));
        }

        public Mod(Integer x, javax.persistence.criteria.Expression<Integer> y) {
            this(new Constant<Integer>(Integer.class, x), y);
        }

        @Override
        public Value toValue(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            Value value = factory.mod(Expressions.toValue(this.e1, factory, q), Expressions.toValue(this.e2, factory, q));
            value.setImplicitType(this.getJavaType());
            return value;
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            return Expressions.asValue(q, "MOD", Expressions.OPEN_BRACE, this.e1, Expressions.COMMA, this.e2, Expressions.CLOSE_BRACE);
        }
    }

    public static class Quotient<N extends Number>
    extends BinarayFunctionalExpression<N> {
        public Quotient(javax.persistence.criteria.Expression<? extends Number> x, javax.persistence.criteria.Expression<? extends Number> y) {
            super(x.getJavaType(), x, y);
        }

        public Quotient(javax.persistence.criteria.Expression<? extends Number> x, Number y) {
            this(x, new Constant<Number>(y));
        }

        public Quotient(Number x, javax.persistence.criteria.Expression<? extends Number> y) {
            this(new Constant<Number>(x), y);
        }

        @Override
        public Value toValue(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            Value value = factory.divide(Expressions.toValue(this.e1, factory, q), Expressions.toValue(this.e2, factory, q));
            value.setImplicitType(this.getJavaType());
            return value;
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            return Expressions.asValue(q, this.e1, "%", this.e2);
        }
    }

    public static class Diff<N extends Number>
    extends BinarayFunctionalExpression<N> {
        public Diff(javax.persistence.criteria.Expression<? extends Number> x, javax.persistence.criteria.Expression<? extends Number> y) {
            super(x.getJavaType(), x, y);
        }

        public Diff(javax.persistence.criteria.Expression<? extends Number> x, Number y) {
            this(x, new Constant<Number>(Number.class, y));
        }

        public Diff(Number x, javax.persistence.criteria.Expression<? extends Number> y) {
            this(new Constant<Number>(Number.class, x), y);
        }

        @Override
        public Value toValue(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            Value value = factory.subtract(Expressions.toValue(this.e1, factory, q), Expressions.toValue(this.e2, factory, q));
            value.setImplicitType(this.getJavaType());
            return value;
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            return Expressions.asValue(q, this.e1, " - ", this.e2);
        }
    }

    public static class Product<N extends Number>
    extends BinarayFunctionalExpression<N> {
        public Product(javax.persistence.criteria.Expression<? extends Number> x, javax.persistence.criteria.Expression<? extends Number> y) {
            super(x.getJavaType(), x, y);
        }

        public Product(javax.persistence.criteria.Expression<? extends Number> x, Number y) {
            this(x, new Constant<Number>(Number.class, y));
        }

        public Product(Number x, javax.persistence.criteria.Expression<? extends Number> y) {
            this(new Constant<Number>(Number.class, x), y);
        }

        @Override
        public Value toValue(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            return factory.multiply(Expressions.toValue(this.e1, factory, q), Expressions.toValue(this.e2, factory, q));
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            return Expressions.asValue(q, this.e1, " * ", this.e2);
        }
    }

    public static class Sum<N extends Number>
    extends BinarayFunctionalExpression<N> {
        public Sum(javax.persistence.criteria.Expression<? extends Number> x, javax.persistence.criteria.Expression<? extends Number> y) {
            super(x.getJavaType(), x, y);
        }

        public Sum(javax.persistence.criteria.Expression<? extends Number> x) {
            this(x, (javax.persistence.criteria.Expression<? extends Number>)((javax.persistence.criteria.Expression)null));
        }

        public Sum(javax.persistence.criteria.Expression<? extends Number> x, Number y) {
            this(x, new Constant<Number>(Number.class, y));
        }

        public Sum(Number x, javax.persistence.criteria.Expression<? extends Number> y) {
            this(new Constant<Number>(Number.class, x), y);
        }

        @Override
        public Value toValue(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            Value value = this.e2 == null ? factory.sum(Expressions.toValue(this.e1, factory, q)) : factory.add(Expressions.toValue(this.e1, factory, q), Expressions.toValue(this.e2, factory, q));
            value.setImplicitType(this.getJavaType());
            return value;
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            return this.e2 == null ? Expressions.asValue(q, "SUM", Expressions.OPEN_BRACE, this.e1, Expressions.CLOSE_BRACE) : Expressions.asValue(q, this.e1, " + ", this.e2);
        }
    }

    public static class Trim
    extends BinarayFunctionalExpression<String> {
        static javax.persistence.criteria.Expression<Character> defaultTrim = new Constant<Character>(Character.class, Character.valueOf(' '));
        static CriteriaBuilder.Trimspec defaultSpec = CriteriaBuilder.Trimspec.BOTH;
        private CriteriaBuilder.Trimspec ts;

        public Trim(javax.persistence.criteria.Expression<String> x, javax.persistence.criteria.Expression<Character> y, CriteriaBuilder.Trimspec ts) {
            super(String.class, x, y);
            this.ts = ts;
        }

        public Trim(javax.persistence.criteria.Expression<String> x, javax.persistence.criteria.Expression<Character> y) {
            this(x, y, defaultSpec);
        }

        public Trim(javax.persistence.criteria.Expression<String> x) {
            this(x, defaultTrim, defaultSpec);
        }

        public Trim(javax.persistence.criteria.Expression<String> x, Character t) {
            this(x, new Constant<Character>(Character.class, t), defaultSpec);
        }

        public Trim(javax.persistence.criteria.Expression<String> x, Character t, CriteriaBuilder.Trimspec ts) {
            this(x, new Constant<Character>(Character.class, t), ts);
        }

        public Trim(javax.persistence.criteria.Expression<String> x, CriteriaBuilder.Trimspec ts) {
            this(x, defaultTrim, ts);
        }

        @Override
        public Value toValue(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            Boolean spec = null;
            if (this.ts != null) {
                switch (this.ts) {
                    case LEADING: {
                        spec = true;
                        break;
                    }
                    case TRAILING: {
                        spec = false;
                        break;
                    }
                    case BOTH: {
                        spec = null;
                    }
                }
            }
            Character t = (Character)((Constant)this.e2).arg;
            Constant<String> e2 = new Constant<String>(String.class, t.toString());
            return factory.trim(Expressions.toValue(this.e1, factory, q), Expressions.toValue(e2, factory, q), spec);
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            return Expressions.asValue(q, "TRIM", Expressions.OPEN_BRACE, this.e1, Expressions.COMMA, this.e2, Expressions.CLOSE_BRACE);
        }
    }

    public static class Locate
    extends ExpressionImpl<Integer> {
        private ExpressionImpl<String> pattern;
        private ExpressionImpl<Integer> from;
        private ExpressionImpl<String> path;

        public Locate(javax.persistence.criteria.Expression<String> path, javax.persistence.criteria.Expression<String> pattern, javax.persistence.criteria.Expression<Integer> from) {
            super(Integer.class);
            this.path = (ExpressionImpl)path;
            this.pattern = (ExpressionImpl)pattern;
            this.from = (ExpressionImpl)from;
        }

        public Locate(javax.persistence.criteria.Expression<String> path, javax.persistence.criteria.Expression<String> pattern) {
            this(path, pattern, null);
        }

        public Locate(javax.persistence.criteria.Expression<String> path, String pattern) {
            this(path, new Constant<String>(pattern), null);
        }

        public Locate(String path, javax.persistence.criteria.Expression<String> pattern) {
            this(new Constant<String>(path), pattern, null);
        }

        public Locate(javax.persistence.criteria.Expression<String> path, String pattern, int from) {
            this(path, new Constant<String>(pattern), new Constant<Integer>(from));
        }

        @Override
        public Value toValue(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            Value locateSearch = this.path.toValue(factory, q);
            Value locateFromIndex = this.from == null ? null : Expressions.toValue(this.from, factory, q);
            Value locatePath = Expressions.toValue(this.pattern, factory, q);
            return factory.indexOf(locateSearch, locateFromIndex == null ? locatePath : factory.newArgumentList(locatePath, locateFromIndex));
        }

        @Override
        public void acceptVisit(CriteriaExpressionVisitor visitor) {
            Expressions.acceptVisit(visitor, this, this.pattern, this.from, this.path);
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            return Expressions.asValue(q, "LOCATE", Expressions.OPEN_BRACE, this.pattern, Expressions.COMMA, this.path, Expressions.CLOSE_BRACE);
        }
    }

    public static class Substring
    extends UnaryFunctionalExpression<String> {
        private ExpressionImpl<Integer> from;
        private ExpressionImpl<Integer> len;

        public Substring(javax.persistence.criteria.Expression<String> s, javax.persistence.criteria.Expression<Integer> from, javax.persistence.criteria.Expression<Integer> len) {
            super(String.class, s);
            this.from = (ExpressionImpl)from;
            this.len = (ExpressionImpl)len;
        }

        public Substring(javax.persistence.criteria.Expression<String> s, javax.persistence.criteria.Expression<Integer> from) {
            this(s, (ExpressionImpl)from, null);
        }

        public Substring(javax.persistence.criteria.Expression<String> s) {
            this(s, (javax.persistence.criteria.Expression<Integer>)((javax.persistence.criteria.Expression)null), (javax.persistence.criteria.Expression<Integer>)((javax.persistence.criteria.Expression)null));
        }

        public Substring(javax.persistence.criteria.Expression<String> s, Integer from) {
            this(s, new Constant<Integer>(from), null);
        }

        public Substring(javax.persistence.criteria.Expression<String> s, Integer from, Integer len) {
            this(s, new Constant<Integer>(from), new Constant<Integer>(len));
        }

        @Override
        public Value toValue(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            return JPQLExpressionBuilder.convertSubstringArguments(factory, Expressions.toValue(this.e, factory, q), this.from == null ? null : this.from.toValue(factory, q), this.len == null ? null : this.len.toValue(factory, q));
        }

        @Override
        public void acceptVisit(CriteriaExpressionVisitor visitor) {
            super.acceptVisit(visitor);
            Expressions.acceptVisit(visitor, this.from, this.len);
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            return Expressions.asValue(q, "SUBSTRING", Expressions.OPEN_BRACE, this.e, Expressions.COMMA, this.from, Expressions.COMMA, this.len, Expressions.CLOSE_BRACE);
        }
    }

    public static class Concat
    extends BinarayFunctionalExpression<String> {
        public Concat(javax.persistence.criteria.Expression<String> x, javax.persistence.criteria.Expression<String> y) {
            super(String.class, x, y);
        }

        public Concat(javax.persistence.criteria.Expression<String> x, String y) {
            this(x, new Constant<String>(y));
        }

        public Concat(String x, javax.persistence.criteria.Expression<String> y) {
            this(new Constant<String>(x), y);
        }

        @Override
        public Value toValue(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            return factory.concat(Expressions.toValue(this.e1, factory, q), Expressions.toValue(this.e2, factory, q));
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            return Expressions.asValue(q, "CONCAT", Expressions.OPEN_BRACE, this.e1, Expressions.COMMA, this.e2, Expressions.CLOSE_BRACE);
        }
    }

    public static class Cast<B>
    extends UnaryFunctionalExpression<B> {
        public Cast(javax.persistence.criteria.Expression<?> x, Class<B> b) {
            super(b, x);
        }

        @Override
        public Value toValue(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            return factory.cast(Expressions.toValue(this.e, factory, q), this.getJavaType());
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            return Expressions.asValue(q, Expressions.OPEN_BRACE, this.getJavaType().getSimpleName(), Expressions.CLOSE_BRACE, this.e);
        }
    }

    public static class Type<X extends Class>
    extends UnaryFunctionalExpression<X> {
        public Type(PathImpl<?, ?> path) {
            super(Class.class, path);
        }

        @Override
        public Value toValue(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            return factory.type(Expressions.toValue(this.e, factory, q));
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            return Expressions.asValue(q, "TYPE", Expressions.OPEN_BRACE, this.e, Expressions.CLOSE_BRACE);
        }
    }

    public static class DatabaseFunction<T>
    extends FunctionalExpression<T> {
        private final String functionName;
        private final Class<T> resultType;

        public DatabaseFunction(String name, Class<T> resultType, javax.persistence.criteria.Expression<?> ... exps) {
            super(resultType, exps);
            this.functionName = name;
            this.resultType = resultType;
        }

        @Override
        public Value toValue(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            return factory.newFunction(this.functionName, this.getJavaType(), new ListArgument<T>(this.resultType, this.args).toValue(factory, (CriteriaQueryImpl)q));
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            return Expressions.asValue(q, this.functionName, Expressions.OPEN_BRACE, Expressions.asValue(q, this.args, Expressions.COMMA), Expressions.CLOSE_BRACE);
        }
    }

    public static class Size
    extends UnaryFunctionalExpression<Integer> {
        public Size(javax.persistence.criteria.Expression<? extends Collection<?>> x) {
            super(Integer.class, x);
        }

        public Size(Collection<?> x) {
            this(new Constant(x));
        }

        @Override
        public Value toValue(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            Value val = Expressions.toValue(this.e, factory, q);
            Value result = val instanceof Literal && ((Literal)val).getParseType() == 7 ? factory.newLiteral(((Collection)((Literal)val).getValue()).size(), 1) : factory.size(val);
            result.setImplicitType(Integer.class);
            return result;
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            return Expressions.asValue(q, "SIZE", Expressions.OPEN_BRACE, this.e, Expressions.CLOSE_BRACE);
        }
    }

    public static class Min<X>
    extends UnaryFunctionalExpression<X> {
        public Min(javax.persistence.criteria.Expression<X> x) {
            super(x);
        }

        @Override
        public Value toValue(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            Value value = factory.min(Expressions.toValue(this.e, factory, q));
            value.setImplicitType(this.getJavaType());
            return value;
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            return Expressions.asValue(q, "MIN", Expressions.OPEN_BRACE, this.e, Expressions.CLOSE_BRACE);
        }
    }

    public static class Max<X>
    extends UnaryFunctionalExpression<X> {
        public Max(javax.persistence.criteria.Expression<X> x) {
            super(x);
        }

        @Override
        public Value toValue(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            Value value = factory.max(Expressions.toValue(this.e, factory, q));
            value.setImplicitType(this.getJavaType());
            return value;
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            return Expressions.asValue(q, "MAX", Expressions.OPEN_BRACE, this.e, Expressions.CLOSE_BRACE);
        }
    }

    public static class Sqrt
    extends UnaryFunctionalExpression<Double> {
        public Sqrt(javax.persistence.criteria.Expression<? extends Number> x) {
            super(Double.class, x);
        }

        @Override
        public Value toValue(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            Value value = factory.sqrt(Expressions.toValue(this.e, factory, q));
            value.setImplicitType(this.getJavaType());
            return value;
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            return Expressions.asValue(q, "SQRT", Expressions.OPEN_BRACE, this.e, Expressions.CLOSE_BRACE);
        }
    }

    public static class Avg
    extends UnaryFunctionalExpression<Double> {
        public Avg(javax.persistence.criteria.Expression<?> x) {
            super(Double.class, x);
        }

        @Override
        public Value toValue(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            Value value = factory.avg(Expressions.toValue(this.e, factory, q));
            value.setImplicitType(this.getJavaType());
            return value;
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            return Expressions.asValue(q, "AVG", Expressions.OPEN_BRACE, this.e, Expressions.CLOSE_BRACE);
        }
    }

    public static class Count
    extends UnaryFunctionalExpression<Long> {
        private boolean _distinct;

        public Count(javax.persistence.criteria.Expression<?> x) {
            this(x, false);
        }

        public Count(javax.persistence.criteria.Expression<?> x, boolean distinct) {
            super(Long.class, x);
            this._distinct = distinct;
        }

        @Override
        public Value toValue(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            Value v = Expressions.toValue(this.e, factory, q);
            return this._distinct ? factory.count(factory.distinct(v)) : factory.count(v);
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            return Expressions.asValue(q, "COUNT", Expressions.OPEN_BRACE, this._distinct ? "DISTINCT(" : "", this.e, this._distinct ? Expressions.CLOSE_BRACE : "", Expressions.CLOSE_BRACE);
        }
    }

    public static class Abs<X>
    extends UnaryFunctionalExpression<X> {
        public Abs(javax.persistence.criteria.Expression<X> x) {
            super(x);
        }

        @Override
        public Value toValue(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
            Value value = factory.abs(Expressions.toValue(this.e, factory, q));
            value.setImplicitType(this.getJavaType());
            return value;
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            return Expressions.asValue(q, "ABS", Expressions.OPEN_BRACE, this.e, Expressions.CLOSE_BRACE);
        }
    }

    public static abstract class BinaryLogicalExpression
    extends PredicateImpl {
        protected final ExpressionImpl<?> e1;
        protected final ExpressionImpl<?> e2;

        public BinaryLogicalExpression(javax.persistence.criteria.Expression<?> x, javax.persistence.criteria.Expression<?> y) {
            this.e1 = (ExpressionImpl)x;
            this.e2 = (ExpressionImpl)y;
        }

        @Override
        public void acceptVisit(CriteriaExpressionVisitor visitor) {
            Expressions.acceptVisit(visitor, this, this.e1, this.e2);
        }
    }

    public static abstract class FunctionalExpression<X>
    extends ExpressionImpl<X> {
        protected final ExpressionImpl<?>[] args;

        public FunctionalExpression(Class<X> t, javax.persistence.criteria.Expression<?> ... args) {
            super(t);
            int len = args == null ? 0 : args.length;
            this.args = new ExpressionImpl[len];
            for (int i = 0; args != null && i < args.length; ++i) {
                this.args[i] = (ExpressionImpl)args[i];
            }
        }

        @Override
        public void acceptVisit(CriteriaExpressionVisitor visitor) {
            Expressions.acceptVisit(visitor, this, this.args);
        }
    }

    public static abstract class BinarayFunctionalExpression<X>
    extends ExpressionImpl<X> {
        protected final ExpressionImpl<?> e1;
        protected final ExpressionImpl<?> e2;

        public BinarayFunctionalExpression(Class<X> t, javax.persistence.criteria.Expression<?> x, javax.persistence.criteria.Expression<?> y) {
            super(t);
            this.e1 = (ExpressionImpl)x;
            this.e2 = (ExpressionImpl)y;
        }

        @Override
        public void acceptVisit(CriteriaExpressionVisitor visitor) {
            Expressions.acceptVisit(visitor, this, this.e1, this.e2);
        }
    }

    public static abstract class UnaryFunctionalExpression<X>
    extends ExpressionImpl<X> {
        protected final ExpressionImpl<?> e;

        public UnaryFunctionalExpression(Class<X> t, javax.persistence.criteria.Expression<?> e) {
            super(t);
            this.e = (ExpressionImpl)e;
        }

        public UnaryFunctionalExpression(javax.persistence.criteria.Expression<X> e) {
            this(e.getJavaType(), e);
        }

        @Override
        public void acceptVisit(CriteriaExpressionVisitor visitor) {
            Expressions.acceptVisit(visitor, this, this.e);
        }
    }
}

