/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.installer;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.openejb.loader.IO;
import org.apache.tomee.installer.Alerts;
import org.codehaus.swizzle.stream.DelimitedTokenReplacementInputStream;
import org.codehaus.swizzle.stream.StreamTokenHandler;
import org.codehaus.swizzle.stream.StringTokenHandler;

public class Installers {
    public static String readEntry(JarFile jarFile, String name, Alerts alerts) {
        ZipEntry entry = jarFile.getEntry(name);
        if (entry == null) {
            return null;
        }
        try {
            String text = IO.slurp((InputStream)jarFile.getInputStream(entry));
            return text;
        }
        catch (Exception e) {
            alerts.addError("Unable to read " + name + " from " + jarFile.getName());
            return null;
        }
    }

    public static String replace(String inputText, String begin, String newBegin, String end, String newEnd) throws IOException {
        BeginEndTokenHandler tokenHandler = new BeginEndTokenHandler(newBegin, newEnd);
        ByteArrayInputStream in = new ByteArrayInputStream(inputText.getBytes());
        DelimitedTokenReplacementInputStream replacementStream = new DelimitedTokenReplacementInputStream((InputStream)in, begin, end, (StreamTokenHandler)tokenHandler, true);
        StringBuilder sb = new StringBuilder();
        int i = replacementStream.read();
        while (i != -1) {
            sb.append((char)i);
            i = replacementStream.read();
        }
        String newServerXml = sb.toString();
        IO.close((Closeable)replacementStream);
        return newServerXml;
    }

    public static boolean backup(File source, Alerts alerts) {
        try {
            File backupFile = new File(source.getParent(), source.getName() + ".original");
            if (!backupFile.exists()) {
                Installers.copyFile(source, backupFile);
            }
            return true;
        }
        catch (IOException e) {
            alerts.addError("Unable to backup " + source.getAbsolutePath() + "; No changes will be made to this file");
            return false;
        }
    }

    public static void copyFile(File source, File destination) throws IOException {
        File destinationDir = destination.getParentFile();
        if (!destinationDir.exists() && !destinationDir.mkdirs()) {
            throw new IOException("Cannot create directory : " + destinationDir);
        }
        IO.copy((File)source, (File)destination);
    }

    public static boolean writeAll(File file, String text, Alerts alerts) {
        if (file.exists()) {
            try {
                String oldText = IO.slurp((File)file);
                if (oldText.equals(text)) {
                    return true;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!file.delete()) {
                alerts.addError("can't replace " + file.getName());
            }
        }
        try {
            IO.copy((InputStream)IO.read((String)text), (File)file);
            return true;
        }
        catch (Exception e) {
            alerts.addError("Unable to write to " + file.getAbsolutePath(), e);
            return false;
        }
    }

    public static void writeAll(InputStream in, OutputStream out) throws IOException {
        int count;
        byte[] buffer = new byte[4096];
        while ((count = in.read(buffer)) > 0) {
            out.write(buffer, 0, count);
        }
        out.flush();
    }

    public static String readAll(File file, Alerts alerts) {
        try {
            String text = IO.slurp((File)file);
            return text;
        }
        catch (Exception e) {
            alerts.addError("Unable to read " + file.getAbsolutePath());
            return null;
        }
    }

    public static void copy(File srcFile, File destFile) throws IOException {
        if (destFile.exists() && destFile.isDirectory()) {
            throw new IOException("Destination '" + destFile + "' exists but is a directory");
        }
        IO.copy((File)srcFile, (File)destFile);
    }

    public static class BeginEndTokenHandler
    extends StringTokenHandler {
        private final String begin;
        private final String end;

        public BeginEndTokenHandler(String begin, String end) {
            this.begin = begin;
            this.end = end;
        }

        public String handleToken(String token) throws IOException {
            String result = this.begin + token + this.end;
            return result;
        }
    }
}

