/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.perforce.command.checkout;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringBufferInputStream;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkout.AbstractCheckOutCommand;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.perforce.PerforceScmProvider;
import org.apache.maven.scm.provider.perforce.command.PerforceCommand;
import org.apache.maven.scm.provider.perforce.command.checkout.PerforceCheckOutConsumer;
import org.apache.maven.scm.provider.perforce.repository.PerforceScmProviderRepository;
import org.apache.regexp.RE;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class PerforceCheckOutCommand
extends AbstractCheckOutCommand
implements PerforceCommand {
    private String actualLocation;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CheckOutScmResult executeCheckOutCommand(ScmProviderRepository repo, ScmFileSet files, ScmVersion version, boolean recursive) throws ScmException {
        CheckOutScmResult checkOutScmResult;
        block54: {
            boolean clientspecExists;
            Commandline cl;
            PerforceCheckOutConsumer consumer;
            String specname;
            File workingDirectory;
            PerforceScmProviderRepository prepo;
            block52: {
                CheckOutScmResult checkOutScmResult2;
                block53: {
                    block51: {
                        block50: {
                            prepo = (PerforceScmProviderRepository)repo;
                            workingDirectory = new File(files.getBasedir().getAbsolutePath());
                            this.actualLocation = PerforceScmProvider.getRepoPath(this.getLogger(), prepo, files.getBasedir());
                            specname = PerforceScmProvider.getClientspecName(this.getLogger(), prepo, workingDirectory);
                            consumer = new PerforceCheckOutConsumer(specname, this.actualLocation);
                            if (this.getLogger().isInfoEnabled()) {
                                this.getLogger().info("Checkout working directory: " + workingDirectory);
                            }
                            cl = null;
                            try {
                                CommandLineUtils.StringStreamConsumer err;
                                int exitCode;
                                cl = PerforceScmProvider.createP4Command(prepo, workingDirectory);
                                cl.createArg().setValue("client");
                                cl.createArg().setValue("-i");
                                if (this.getLogger().isInfoEnabled()) {
                                    this.getLogger().info("Executing: " + PerforceScmProvider.clean(cl.toString()));
                                }
                                String client = PerforceScmProvider.createClientspec(this.getLogger(), prepo, workingDirectory, this.actualLocation);
                                if (this.getLogger().isDebugEnabled()) {
                                    this.getLogger().debug("Updating clientspec:\n" + client);
                                }
                                if ((exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (InputStream)new StringBufferInputStream(client), (StreamConsumer)consumer, (StreamConsumer)(err = new CommandLineUtils.StringStreamConsumer()))) != 0) {
                                    String cmdLine = CommandLineUtils.toString((String[])cl.getCommandline());
                                    StringBuffer msg = new StringBuffer("Exit code: " + exitCode + " - " + err.getOutput());
                                    msg.append('\n');
                                    msg.append("Command line was:" + cmdLine);
                                    throw new CommandLineException(msg.toString());
                                }
                            }
                            catch (CommandLineException e) {
                                if (!this.getLogger().isErrorEnabled()) break block50;
                                this.getLogger().error("CommandLineException " + e.getMessage(), (Throwable)e);
                            }
                        }
                        clientspecExists = consumer.isSuccess();
                        if (clientspecExists) {
                            try {
                                String line;
                                int lastChangelist = this.getLastChangelist(prepo, workingDirectory, specname);
                                cl = PerforceCheckOutCommand.createCommandLine(prepo, workingDirectory, version, specname);
                                if (this.getLogger().isDebugEnabled()) {
                                    this.getLogger().debug("Executing: " + PerforceScmProvider.clean(cl.toString()));
                                }
                                Process proc = cl.execute();
                                BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                                while ((line = br.readLine()) != null) {
                                    if (this.getLogger().isDebugEnabled()) {
                                        this.getLogger().debug("Consuming: " + line);
                                    }
                                    consumer.consumeLine(line);
                                }
                                CommandLineUtils.StringStreamConsumer err = new CommandLineUtils.StringStreamConsumer();
                                int exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)err);
                                if (exitCode != 0) {
                                    String cmdLine = CommandLineUtils.toString((String[])cl.getCommandline());
                                    StringBuffer msg = new StringBuffer("Exit code: " + exitCode + " - " + err.getOutput());
                                    msg.append('\n');
                                    msg.append("Command line was:" + cmdLine);
                                    throw new CommandLineException(msg.toString());
                                }
                                if (this.getLogger().isDebugEnabled()) {
                                    this.getLogger().debug("Perforce sync complete.");
                                }
                            }
                            catch (CommandLineException e) {
                                if (this.getLogger().isErrorEnabled()) {
                                    this.getLogger().error("CommandLineException " + e.getMessage(), (Throwable)e);
                                }
                            }
                            catch (IOException e) {
                                if (!this.getLogger().isErrorEnabled()) break block51;
                                this.getLogger().error("IOException " + e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                    if (!consumer.isSuccess()) break block52;
                    checkOutScmResult2 = new CheckOutScmResult(cl.toString(), consumer.getCheckedout());
                    Object var20_29 = null;
                    if (clientspecExists && !prepo.isPersistCheckout()) {
                        try {
                            String line;
                            cl = PerforceScmProvider.createP4Command(prepo, workingDirectory);
                            cl.createArg().setValue("client");
                            cl.createArg().setValue("-d");
                            cl.createArg().setValue(specname);
                            if (this.getLogger().isInfoEnabled()) {
                                this.getLogger().info("Executing: " + PerforceScmProvider.clean(cl.toString()));
                            }
                            Process proc = cl.execute();
                            BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                            while ((line = br.readLine()) != null) {
                                if (this.getLogger().isDebugEnabled()) {
                                    this.getLogger().debug("Consuming: " + line);
                                }
                                consumer.consumeLine(line);
                            }
                            br.close();
                            BufferedReader brErr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                            while ((line = brErr.readLine()) != null) {
                                if (this.getLogger().isDebugEnabled()) {
                                    this.getLogger().debug("Consuming stderr: " + line);
                                }
                                consumer.consumeLine(line);
                            }
                            brErr.close();
                        }
                        catch (CommandLineException e) {
                            if (this.getLogger().isErrorEnabled()) {
                                this.getLogger().error("CommandLineException " + e.getMessage(), (Throwable)e);
                            }
                            break block53;
                        }
                        catch (IOException e) {
                            if (this.getLogger().isErrorEnabled()) {
                                this.getLogger().error("IOException " + e.getMessage(), (Throwable)e);
                            }
                            break block53;
                        }
                    }
                    if (clientspecExists) {
                        System.setProperty("maven.scm.perforce.clientspec.name", specname);
                    }
                }
                return checkOutScmResult2;
            }
            try {
                checkOutScmResult = new CheckOutScmResult(cl.toString(), "Unable to sync.  Are you logged in?", consumer.getOutput(), consumer.isSuccess());
                Object var20_30 = null;
            }
            catch (Throwable throwable) {
                block55: {
                    block56: {
                        Object var20_31 = null;
                        if (!clientspecExists || prepo.isPersistCheckout()) break block56;
                        try {
                            String line;
                            cl = PerforceScmProvider.createP4Command(prepo, workingDirectory);
                            cl.createArg().setValue("client");
                            cl.createArg().setValue("-d");
                            cl.createArg().setValue(specname);
                            if (this.getLogger().isInfoEnabled()) {
                                this.getLogger().info("Executing: " + PerforceScmProvider.clean(cl.toString()));
                            }
                            Process proc = cl.execute();
                            BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                            while ((line = br.readLine()) != null) {
                                if (this.getLogger().isDebugEnabled()) {
                                    this.getLogger().debug("Consuming: " + line);
                                }
                                consumer.consumeLine(line);
                            }
                            br.close();
                            BufferedReader brErr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                            while ((line = brErr.readLine()) != null) {
                                if (this.getLogger().isDebugEnabled()) {
                                    this.getLogger().debug("Consuming stderr: " + line);
                                }
                                consumer.consumeLine(line);
                            }
                            brErr.close();
                        }
                        catch (CommandLineException e) {
                            if (this.getLogger().isErrorEnabled()) {
                                this.getLogger().error("CommandLineException " + e.getMessage(), (Throwable)e);
                            }
                            break block55;
                        }
                        catch (IOException e) {
                            if (!this.getLogger().isErrorEnabled()) break block55;
                            this.getLogger().error("IOException " + e.getMessage(), (Throwable)e);
                        }
                        break block55;
                    }
                    if (!clientspecExists) break block55;
                    System.setProperty("maven.scm.perforce.clientspec.name", specname);
                }
                throw throwable;
            }
            if (clientspecExists && !prepo.isPersistCheckout()) {
                try {
                    String line;
                    cl = PerforceScmProvider.createP4Command(prepo, workingDirectory);
                    cl.createArg().setValue("client");
                    cl.createArg().setValue("-d");
                    cl.createArg().setValue(specname);
                    if (this.getLogger().isInfoEnabled()) {
                        this.getLogger().info("Executing: " + PerforceScmProvider.clean(cl.toString()));
                    }
                    Process proc = cl.execute();
                    BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                    while ((line = br.readLine()) != null) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Consuming: " + line);
                        }
                        consumer.consumeLine(line);
                    }
                    br.close();
                    BufferedReader brErr = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                    while ((line = brErr.readLine()) != null) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Consuming stderr: " + line);
                        }
                        consumer.consumeLine(line);
                    }
                    brErr.close();
                }
                catch (CommandLineException e) {
                    if (this.getLogger().isErrorEnabled()) {
                        this.getLogger().error("CommandLineException " + e.getMessage(), (Throwable)e);
                    }
                    break block54;
                }
                catch (IOException e) {
                    if (this.getLogger().isErrorEnabled()) {
                        this.getLogger().error("IOException " + e.getMessage(), (Throwable)e);
                    }
                    break block54;
                }
            }
            if (clientspecExists) {
                System.setProperty("maven.scm.perforce.clientspec.name", specname);
            }
        }
        return checkOutScmResult;
    }

    public static Commandline createCommandLine(PerforceScmProviderRepository repo, File workingDirectory, ScmVersion version, String specname) {
        Commandline command = PerforceScmProvider.createP4Command(repo, workingDirectory);
        command.createArg().setValue("-c" + specname);
        command.createArg().setValue("sync");
        String[] files = workingDirectory.list();
        if (files == null || files.length == 0) {
            command.createArg().setValue("-f");
        }
        if (version != null && StringUtils.isNotEmpty((String)version.getName())) {
            command.createArg().setValue("@" + version.getName());
        }
        return command;
    }

    private int getLastChangelist(PerforceScmProviderRepository repo, File workingDirectory, String specname) {
        int lastChangelist = 0;
        try {
            String line;
            Commandline command = PerforceScmProvider.createP4Command(repo, workingDirectory);
            command.createArgument().setValue("-c" + specname);
            command.createArgument().setValue("changes");
            command.createArgument().setValue("-m1");
            command.createArgument().setValue("-ssubmitted");
            command.createArgument().setValue("//" + specname + "/...");
            this.getLogger().debug("Executing: " + PerforceScmProvider.clean(command.toString()));
            Process proc = command.execute();
            BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            String lastChangelistStr = "";
            while ((line = br.readLine()) != null) {
                this.getLogger().debug("Consuming: " + line);
                RE changeRegexp = new RE("Change (\\d+)");
                if (!changeRegexp.match(line)) continue;
                lastChangelistStr = changeRegexp.getParen(1);
            }
            br.close();
            try {
                lastChangelist = Integer.parseInt(lastChangelistStr);
            }
            catch (NumberFormatException nfe) {
                this.getLogger().debug("Could not parse changelist from line " + line);
            }
        }
        catch (IOException e) {
            this.getLogger().error((Throwable)e);
        }
        catch (CommandLineException e) {
            this.getLogger().error((Throwable)e);
        }
        return lastChangelist;
    }
}

