/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.hg.command.checkout;

import java.io.File;
import java.io.IOException;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkout.AbstractCheckOutCommand;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.hg.HgUtils;
import org.apache.maven.scm.provider.hg.command.HgCommand;
import org.apache.maven.scm.provider.hg.command.HgConsumer;
import org.apache.maven.scm.provider.hg.command.checkout.HgCheckOutConsumer;
import org.apache.maven.scm.provider.hg.repository.HgScmProviderRepository;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class HgCheckOutCommand
extends AbstractCheckOutCommand
implements HgCommand {
    protected CheckOutScmResult executeCheckOutCommand(ScmProviderRepository repo, ScmFileSet fileSet, ScmVersion scmVersion) throws ScmException {
        HgScmProviderRepository repository = (HgScmProviderRepository)repo;
        String url = repository.getURI();
        File checkoutDir = fileSet.getBasedir();
        try {
            this.getLogger().info("Removing " + checkoutDir);
            FileUtils.deleteDirectory((File)checkoutDir);
        }
        catch (IOException e) {
            throw new ScmException("Cannot remove " + checkoutDir);
        }
        String[] checkout_cmd = new String[]{"clone", "-r", scmVersion != null && !StringUtils.isEmpty((String)scmVersion.getName()) ? scmVersion.getName() : "tip", url, checkoutDir.getAbsolutePath()};
        HgConsumer checkout_consumer = new HgConsumer(this.getLogger());
        HgUtils.execute(checkout_consumer, this.getLogger(), checkoutDir.getParentFile(), checkout_cmd);
        String[] inventory_cmd = new String[]{"locate"};
        HgCheckOutConsumer consumer = new HgCheckOutConsumer(this.getLogger(), checkoutDir);
        ScmResult result = HgUtils.execute(consumer, this.getLogger(), checkoutDir, inventory_cmd);
        return new CheckOutScmResult(consumer.getCheckedOutFiles(), result);
    }
}

