/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.war.util;

import java.util.Objects;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;

public class WarUtils {
    public static Artifact getArtifact(MavenProject project, Dependency dependency) {
        for (Artifact artifact : project.getArtifacts()) {
            if (!artifact.getGroupId().equals(dependency.getGroupId()) || !artifact.getArtifactId().equals(dependency.getArtifactId()) || !artifact.getType().equals(dependency.getType())) continue;
            if (artifact.getClassifier() == null && dependency.getClassifier() == null) {
                return artifact;
            }
            if (dependency.getClassifier() == null || !dependency.getClassifier().equals(artifact.getClassifier())) continue;
            return artifact;
        }
        return null;
    }

    public static boolean isRelated(Artifact artifact, Dependency dependency) {
        if (artifact == null || dependency == null) {
            return false;
        }
        if (!Objects.equals(artifact.getGroupId(), dependency.getGroupId())) {
            return false;
        }
        if (!Objects.equals(artifact.getArtifactId(), dependency.getArtifactId())) {
            return false;
        }
        if (Objects.equals(artifact.getVersion(), dependency.getVersion())) {
            return false;
        }
        if (Objects.equals(artifact.getType(), dependency.getType())) {
            return false;
        }
        if (Objects.equals(artifact.getClassifier(), dependency.getClassifier())) {
            return false;
        }
        if (Objects.equals(artifact.getScope(), dependency.getScope())) {
            return false;
        }
        return artifact.isOptional() == dependency.isOptional();
    }
}

