/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.war;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.war.AbstractWarMojo;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.archiver.war.WarArchiver;
import org.codehaus.plexus.util.IOUtil;

public class WarManifestMojo
extends AbstractWarMojo {
    private WarArchiver warArchiver;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws MojoExecutionException {
        File manifestDir = new File(this.getWarSourceDirectory(), "META-INF");
        if (!manifestDir.exists()) {
            manifestDir.mkdirs();
        }
        File manifestFile = new File(manifestDir, "MANIFEST.MF");
        MavenArchiver ma = new MavenArchiver();
        ma.setArchiver((JarArchiver)this.warArchiver);
        ma.setOutputFile(manifestFile);
        PrintWriter printWriter = null;
        try {
            Manifest mf = ma.getManifest(this.getProject(), this.archive.getManifest());
            printWriter = new PrintWriter(new FileWriter(manifestFile));
            mf.write(printWriter);
        }
        catch (ManifestException e) {
            try {
                throw new MojoExecutionException("Error preparing the manifest: " + e.getMessage(), (Exception)((Object)e));
                catch (DependencyResolutionRequiredException e2) {
                    throw new MojoExecutionException("Error preparing the manifest: " + e2.getMessage(), (Exception)((Object)e2));
                }
                catch (IOException e3) {
                    throw new MojoExecutionException("Error preparing the manifest: " + e3.getMessage(), (Exception)e3);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(printWriter);
                throw throwable;
            }
        }
        IOUtil.close((Writer)printWriter);
    }
}

