/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.toolchain;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.toolchain.Toolchains;
import org.apache.maven.toolchain.MisconfiguredToolchainException;
import org.apache.maven.toolchain.ToolchainManagerPrivate;
import org.apache.maven.toolchain.ToolchainPrivate;

public class ToolchainMojo
extends AbstractMojo {
    private ToolchainManagerPrivate toolchainManager;
    private MavenSession session;
    private Toolchains toolchains;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.toolchains != null) {
            Iterator en = this.toolchains.getToolchainsTypes().iterator();
            ArrayList<String> nonMatchedTypes = new ArrayList<String>();
            while (en.hasNext()) {
                try {
                    String type = (String)en.next();
                    this.getLog().info((CharSequence)("Type:" + type));
                    Map params = this.toolchains.getParams(type);
                    ToolchainPrivate[] tcs = this.getToolchains(type);
                    boolean matched = false;
                    for (int i = 0; i < tcs.length; ++i) {
                        if (!tcs[i].matchesRequirements(params)) continue;
                        this.getLog().info((CharSequence)("Toolchain (" + type + ") matched:" + tcs[i]));
                        this.toolchainManager.storeToolchainToBuildContext(tcs[i], this.session);
                        matched = true;
                        break;
                    }
                    if (matched) continue;
                    nonMatchedTypes.add(type);
                }
                catch (MisconfiguredToolchainException ex) {
                    throw new MojoExecutionException("Misconfigured toolchains.", (Exception)((Object)ex));
                }
            }
            if (!nonMatchedTypes.isEmpty()) {
                StringBuffer buff = new StringBuffer();
                buff.append("Cannot find matching toolchain definitions for the following toolchain types:");
                Iterator it = nonMatchedTypes.iterator();
                while (it.hasNext()) {
                    String type = (String)it.next();
                    buff.append('\n');
                    buff.append(type);
                    Map params = this.toolchains.getParams(type);
                    if (params.size() <= 0) continue;
                    Iterator it2 = params.keySet().iterator();
                    buff.append(" [");
                    while (it2.hasNext()) {
                        String string = (String)it2.next();
                        buff.append(" " + string + "='" + params.get(string) + "' ");
                    }
                    buff.append(']');
                }
                this.getLog().error((CharSequence)buff.toString());
                throw new MojoFailureException(buff.toString() + "\nPlease make sure you define the required toolchains in your ~/.m2/toolchains.xml file.");
            }
        }
    }

    private ToolchainPrivate[] getToolchains(String type) throws MojoExecutionException, MisconfiguredToolchainException {
        Class<?> managerClass = this.toolchainManager.getClass();
        try {
            try {
                Method newMethod = managerClass.getMethod("getToolchainsForType", String.class, MavenSession.class);
                return (ToolchainPrivate[])newMethod.invoke((Object)this.toolchainManager, type, this.session);
            }
            catch (NoSuchMethodException e) {
                try {
                    Method oldMethod = managerClass.getMethod("getToolchainsForType", String.class);
                    return (ToolchainPrivate[])oldMethod.invoke((Object)this.toolchainManager, type);
                }
                catch (NoSuchMethodException e2) {
                    throw new MojoExecutionException("Incompatible toolchain API", (Exception)e2);
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new MojoExecutionException("Incompatible toolchain API", (Exception)e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof MisconfiguredToolchainException) {
                throw (MisconfiguredToolchainException)cause;
            }
            throw new MojoExecutionException("Incompatible toolchain API", (Exception)e);
        }
    }
}

