/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.surefire.report;

import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.plugins.surefire.report.ReportTestCase;
import org.apache.maven.plugins.surefire.report.ReportTestSuite;
import org.apache.maven.plugins.surefire.report.TestSuiteXmlParser;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.StringUtils;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SurefireReportParser {
    private static final String INCLUDES = "*.xml";
    private static final String EXCLUDES = "*.txt, testng-failed.xml, testng-failures.xml, testng-results.xml";
    private NumberFormat numberFormat = NumberFormat.getInstance();
    private List<File> reportsDirectories;
    private final List<ReportTestSuite> testSuites = new ArrayList<ReportTestSuite>();
    private static final int PCENT = 100;

    public SurefireReportParser() {
    }

    public SurefireReportParser(List<File> reportsDirectoriesFiles, Locale locale) {
        this.reportsDirectories = reportsDirectoriesFiles;
        this.setLocale(locale);
    }

    public List<ReportTestSuite> parseXMLReportFiles() throws MavenReportException {
        ArrayList<File> xmlReportFileList = new ArrayList<File>();
        for (File reportsDirectory : this.reportsDirectories) {
            String[] xmlReportFiles;
            if (!reportsDirectory.exists()) continue;
            for (String xmlReportFile : xmlReportFiles = SurefireReportParser.getIncludedFiles(reportsDirectory, INCLUDES, EXCLUDES)) {
                File xmlReport = new File(reportsDirectory, xmlReportFile);
                xmlReportFileList.add(xmlReport);
            }
        }
        TestSuiteXmlParser parser = new TestSuiteXmlParser();
        for (File aXmlReportFileList : xmlReportFileList) {
            Collection<ReportTestSuite> suites;
            try {
                suites = parser.parse(aXmlReportFileList.getAbsolutePath());
            }
            catch (ParserConfigurationException e) {
                throw new MavenReportException("Error setting up parser for JUnit XML report", (Exception)e);
            }
            catch (SAXException e) {
                throw new MavenReportException("Error parsing JUnit XML report " + aXmlReportFileList, (Exception)e);
            }
            catch (IOException e) {
                throw new MavenReportException("Error reading JUnit XML report " + aXmlReportFileList, (Exception)e);
            }
            this.testSuites.addAll(suites);
        }
        return this.testSuites;
    }

    protected String parseTestSuiteName(String lineString) {
        return lineString.substring(lineString.lastIndexOf(".") + 1, lineString.length());
    }

    protected String parseTestSuitePackageName(String lineString) {
        return lineString.substring(lineString.indexOf(":") + 2, lineString.lastIndexOf("."));
    }

    protected String parseTestCaseName(String lineString) {
        return lineString.substring(0, lineString.indexOf("("));
    }

    public Map getSummary(List suites) {
        HashMap<String, String> totalSummary = new HashMap<String, String>();
        ListIterator iter = suites.listIterator();
        int totalNumberOfTests = 0;
        int totalNumberOfErrors = 0;
        int totalNumberOfFailures = 0;
        int totalNumberOfSkipped = 0;
        float totalElapsedTime = 0.0f;
        while (iter.hasNext()) {
            ReportTestSuite suite = (ReportTestSuite)iter.next();
            totalNumberOfTests += suite.getNumberOfTests();
            totalNumberOfErrors += suite.getNumberOfErrors();
            totalNumberOfFailures += suite.getNumberOfFailures();
            totalNumberOfSkipped += suite.getNumberOfSkipped();
            totalElapsedTime += suite.getTimeElapsed();
        }
        String totalPercentage = this.computePercentage(totalNumberOfTests, totalNumberOfErrors, totalNumberOfFailures, totalNumberOfSkipped);
        totalSummary.put("totalTests", Integer.toString(totalNumberOfTests));
        totalSummary.put("totalErrors", Integer.toString(totalNumberOfErrors));
        totalSummary.put("totalFailures", Integer.toString(totalNumberOfFailures));
        totalSummary.put("totalSkipped", Integer.toString(totalNumberOfSkipped));
        totalSummary.put("totalElapsedTime", this.numberFormat.format(totalElapsedTime));
        totalSummary.put("totalPercentage", totalPercentage);
        return totalSummary;
    }

    public void setReportsDirectory(File reportsDirectory) {
        this.reportsDirectories = Collections.singletonList(reportsDirectory);
    }

    public final void setLocale(Locale locale) {
        this.numberFormat = NumberFormat.getInstance(locale);
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public Map getSuitesGroupByPackage(List testSuitesList) {
        ListIterator iter = testSuitesList.listIterator();
        HashMap suitePackage = new HashMap();
        while (iter.hasNext()) {
            ReportTestSuite suite = (ReportTestSuite)iter.next();
            List<ReportTestSuite> suiteList = new ArrayList<ReportTestSuite>();
            if (suitePackage.get(suite.getPackageName()) != null) {
                suiteList = (List)suitePackage.get(suite.getPackageName());
            }
            suiteList.add(suite);
            suitePackage.put(suite.getPackageName(), suiteList);
        }
        return suitePackage;
    }

    public String computePercentage(int tests, int errors, int failures, int skipped) {
        float percentage = tests == 0 ? 0.0f : (float)(tests - errors - failures - skipped) / (float)tests * 100.0f;
        return this.numberFormat.format(percentage);
    }

    public List<ReportTestCase> getFailureDetails(List testSuitesList) {
        ListIterator iter = testSuitesList.listIterator();
        ArrayList<ReportTestCase> failureDetailList = new ArrayList<ReportTestCase>();
        while (iter.hasNext()) {
            ReportTestSuite suite = (ReportTestSuite)iter.next();
            List<ReportTestCase> testCaseList = suite.getTestCases();
            if (testCaseList == null) continue;
            ListIterator<ReportTestCase> caseIter = testCaseList.listIterator();
            while (caseIter.hasNext()) {
                ReportTestCase tCase = caseIter.next();
                if (tCase.getFailure() == null) continue;
                failureDetailList.add(tCase);
            }
        }
        return failureDetailList;
    }

    public static boolean hasReportFiles(File directory) {
        return directory != null && directory.isDirectory() && SurefireReportParser.getIncludedFiles(directory, INCLUDES, EXCLUDES).length > 0;
    }

    private static String[] getIncludedFiles(File directory, String includes, String excludes) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(directory);
        scanner.setIncludes(StringUtils.split((String)includes, (String)","));
        scanner.setExcludes(StringUtils.split((String)excludes, (String)","));
        scanner.scan();
        return scanner.getIncludedFiles();
    }
}

