/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.source;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractSourceJarMojo
extends AbstractMojo {
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/*"};
    protected MavenProject project;
    private boolean attach;
    private MavenProjectHelper projectHelper;
    protected File outputDirectory;
    protected String finalName;
    protected List reactorProjects;

    protected abstract String getClassifier();

    protected abstract List getSources(MavenProject var1);

    protected abstract List getResources(MavenProject var1);

    public void execute() throws MojoExecutionException {
        this.packageSources(this.project);
    }

    protected void packageSources(MavenProject project) throws MojoExecutionException {
        if (!"pom".equals(project.getPackaging())) {
            this.packageSources(Arrays.asList(project));
        }
    }

    protected void packageSources(List projects) throws MojoExecutionException {
        if (this.project.getArtifact().getClassifier() != null) {
            this.getLog().warn((CharSequence)("NOT adding sources to artifacts with classifier as Maven only supports one classifier per artifact. Current artifact [" + this.project.getArtifact().getId() + "] has a [" + this.project.getArtifact().getClassifier() + "] classifier."));
        } else {
            Archiver archiver = this.createArchiver();
            Iterator i = projects.iterator();
            while (i.hasNext()) {
                MavenProject project = this.getProject((MavenProject)i.next());
                if ("pom".equals(project.getPackaging())) continue;
                this.archiveProjectContent(project, archiver);
            }
            File outputFile = new File(this.outputDirectory, this.finalName + "-" + this.getClassifier() + ".jar");
            try {
                archiver.setDestFile(outputFile);
                archiver.createArchive();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error creating source archive: " + e.getMessage(), (Exception)e);
            }
            catch (ArchiverException e) {
                throw new MojoExecutionException("Error creating source archive: " + e.getMessage(), (Exception)((Object)e));
            }
            if (this.attach) {
                this.projectHelper.attachArtifact(this.project, "java-source", this.getClassifier(), outputFile);
            } else {
                this.getLog().info((CharSequence)"NOT adding java-sources to attached artifacts list.");
            }
        }
    }

    protected void archiveProjectContent(MavenProject project, Archiver archiver) throws MojoExecutionException {
        File sourceDirectory;
        Iterator i = this.getSources(project).iterator();
        while (i.hasNext()) {
            String s = (String)i.next();
            sourceDirectory = new File(s);
            if (!sourceDirectory.exists()) continue;
            this.addDirectory(archiver, sourceDirectory, DEFAULT_INCLUDES, FileUtils.getDefaultExcludes());
        }
        i = this.getResources(project).iterator();
        while (i.hasNext()) {
            Resource resource = (Resource)i.next();
            sourceDirectory = new File(resource.getDirectory());
            if (!sourceDirectory.exists()) continue;
            List resourceIncludes = resource.getIncludes();
            String[] includes = resourceIncludes == null || resourceIncludes.size() == 0 ? DEFAULT_INCLUDES : resourceIncludes.toArray(new String[resourceIncludes.size()]);
            List resourceExcludes = resource.getExcludes();
            String[] excludes = resourceExcludes == null || resourceExcludes.size() == 0 ? FileUtils.getDefaultExcludes() : resourceExcludes.toArray(new String[resourceExcludes.size()]);
            this.addDirectory(archiver, sourceDirectory, includes, excludes);
        }
    }

    protected void attachArtifact(File outputFile, String classifier) {
    }

    protected Archiver createArchiver() throws MojoExecutionException {
        JarArchiver archiver = new JarArchiver();
        if (this.project.getBuild() != null) {
            List resources = this.project.getBuild().getResources();
            Iterator i = resources.iterator();
            while (i.hasNext()) {
                Resource r = (Resource)i.next();
                if (!r.getDirectory().endsWith("maven-shared-archive-resources")) continue;
                this.addDirectory((Archiver)archiver, new File(r.getDirectory()), new String[0], new String[0]);
            }
        }
        return archiver;
    }

    protected void addDirectory(Archiver archiver, File sourceDirectory, String[] includes, String[] excludes) throws MojoExecutionException {
        try {
            archiver.addDirectory(sourceDirectory, includes, excludes);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Error adding directory to source archive.", (Exception)((Object)e));
        }
    }

    protected MavenProject getProject(MavenProject project) {
        if (project.getExecutionProject() != null) {
            return project.getExecutionProject();
        }
        return project;
    }
}

