/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site.render;

import java.io.FileNotFoundException;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.maven.doxia.siterenderer.DocumentContent;
import org.apache.maven.doxia.siterenderer.DocumentRenderer;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.doxia.siterenderer.RendererException;
import org.apache.maven.doxia.siterenderer.RenderingContext;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.doxia.siterenderer.sink.SiteRendererSink;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.reporting.MavenReport;
import org.codehaus.plexus.i18n.I18N;

public class CategorySummaryDocumentRenderer
implements DocumentRenderer {
    private RenderingContext renderingContext;
    private String title;
    private String desc1;
    private String desc2;
    private I18N i18n;
    private List<MavenReport> categoryReports;
    private final Log log;

    public CategorySummaryDocumentRenderer(RenderingContext renderingContext, String title, String desc1, String desc2, I18N i18n, List<MavenReport> categoryReports) {
        this(renderingContext, title, desc1, desc2, i18n, categoryReports, null);
    }

    public CategorySummaryDocumentRenderer(RenderingContext renderingContext, String title, String desc1, String desc2, I18N i18n, List<MavenReport> categoryReports, Log log) {
        this.renderingContext = renderingContext;
        this.title = title;
        this.desc1 = desc1;
        this.desc2 = desc2;
        this.i18n = i18n;
        this.categoryReports = Collections.unmodifiableList(categoryReports);
        this.log = log;
    }

    public void renderDocument(Writer writer, Renderer renderer, SiteRenderingContext siteRenderingContext) throws RendererException, FileNotFoundException {
        SiteRendererSink sink = new SiteRendererSink(this.renderingContext);
        sink.head();
        sink.title();
        sink.text(this.title);
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.text(this.title);
        sink.sectionTitle1_();
        sink.paragraph();
        sink.text(this.desc1 + " ");
        sink.link("http://maven.apache.org");
        sink.text("Maven");
        sink.link_();
        sink.text(" " + this.desc2);
        sink.paragraph_();
        sink.section2();
        sink.sectionTitle2();
        Locale locale = siteRenderingContext.getLocale();
        sink.text(this.i18n.getString("site-plugin", locale, "report.category.sectionTitle"));
        sink.sectionTitle2_();
        sink.table();
        sink.tableRows(new int[]{1, 1}, false);
        String name = this.i18n.getString("site-plugin", locale, "report.category.column.document");
        String description = this.i18n.getString("site-plugin", locale, "report.category.column.description");
        sink.tableRow();
        sink.tableHeaderCell();
        sink.text(name);
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text(description);
        sink.tableHeaderCell_();
        sink.tableRow_();
        if (this.categoryReports != null) {
            for (MavenReport report : this.categoryReports) {
                sink.tableRow();
                sink.tableCell();
                sink.link(report.getOutputName() + ".html");
                sink.text(report.getName(locale));
                sink.link_();
                sink.tableCell_();
                sink.tableCell();
                sink.text(report.getDescription(locale));
                sink.tableCell_();
                sink.tableRow_();
            }
        }
        sink.tableRows_();
        sink.table_();
        sink.section2_();
        sink.section1_();
        sink.body_();
        sink.flush();
        sink.close();
        renderer.mergeDocumentIntoSite(writer, (DocumentContent)sink, siteRenderingContext);
    }

    public String getOutputName() {
        return this.renderingContext.getOutputName();
    }

    public RenderingContext getRenderingContext() {
        return this.renderingContext;
    }

    public boolean isOverwrite() {
        return true;
    }

    public boolean isExternalReport() {
        return false;
    }
}

