/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.doxia.siterenderer.DocumentRenderer;
import org.apache.maven.doxia.siterenderer.SiteRenderingContext;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.site.AbstractSiteRenderingMojo;
import org.apache.maven.plugins.site.webapp.DoxiaBean;
import org.apache.maven.reporting.MavenReport;
import org.codehaus.plexus.util.IOUtil;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.DefaultHandler;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.webapp.WebAppContext;

public class SiteRunMojo
extends AbstractSiteRenderingMojo {
    private File tempWebappDirectory;
    private int port;
    private static final int MAX_IDLE_TIME = 30000;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Server server = new Server();
        server.setStopAtShutdown(true);
        Connector defaultConnector = this.getDefaultConnector();
        server.setConnectors(new Connector[]{defaultConnector});
        WebAppContext webapp = this.createWebApplication();
        webapp.setServer(server);
        DefaultHandler defaultHandler = new DefaultHandler();
        defaultHandler.setServer(server);
        Handler[] handlers = new Handler[]{webapp, defaultHandler};
        server.setHandlers(handlers);
        this.getLog().info((CharSequence)("Starting Jetty on http://localhost:" + this.port + "/"));
        try {
            server.start();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error executing Jetty: " + e.getMessage(), e);
        }
        try {
            server.getThreadPool().join();
        }
        catch (InterruptedException e) {
            this.getLog().warn((CharSequence)"Jetty was interrupted", (Throwable)e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private WebAppContext createWebApplication() throws MojoExecutionException {
        File webXml = new File(this.tempWebappDirectory, "WEB-INF/web.xml");
        webXml.getParentFile().mkdirs();
        InputStream inStream = null;
        FileOutputStream outStream = null;
        try {
            inStream = ((Object)((Object)this)).getClass().getResourceAsStream("/webapp/web.xml");
            outStream = new FileOutputStream(webXml);
            IOUtil.copy((InputStream)inStream, (OutputStream)outStream);
        }
        catch (FileNotFoundException e) {
            try {
                throw new MojoExecutionException("Unable to construct temporary webapp for running site", (Exception)e);
                catch (IOException e2) {
                    throw new MojoExecutionException("Unable to construct temporary webapp for running site", (Exception)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(outStream);
                IOUtil.close((InputStream)inStream);
                throw throwable;
            }
        }
        IOUtil.close((OutputStream)outStream);
        IOUtil.close((InputStream)inStream);
        WebAppContext webapp = new WebAppContext();
        webapp.setContextPath("/");
        webapp.setResourceBase(this.tempWebappDirectory.getAbsolutePath());
        webapp.setAttribute("siteRenderer", (Object)this.siteRenderer);
        webapp.getInitParams().put("org.mortbay.jetty.servlet.Default.useFileMappedBuffer", "false");
        this.project.getReporting().setOutputDirectory(this.tempWebappDirectory.getAbsolutePath());
        for (MavenReport report : this.reports) {
            report.setReportOutputDirectory(this.tempWebappDirectory);
        }
        List<MavenReport> filteredReports = this.filterReports(this.reports);
        List localesList = this.siteTool.getAvailableLocales(this.locales);
        webapp.setAttribute("localesList", (Object)localesList);
        Locale defaultLocale = (Locale)localesList.get(0);
        Locale.setDefault(defaultLocale);
        try {
            HashMap<String, DoxiaBean> i18nDoxiaContexts = new HashMap<String, DoxiaBean>();
            Iterator i$2 = localesList.iterator();
            while (true) {
                if (!i$2.hasNext()) {
                    webapp.setAttribute("i18nDoxiaContexts", i18nDoxiaContexts);
                    return webapp;
                }
                Locale locale = (Locale)i$2.next();
                SiteRenderingContext i18nContext = this.createSiteRenderingContext(locale);
                i18nContext.setInputEncoding(this.getInputEncoding());
                i18nContext.setOutputEncoding(this.getOutputEncoding());
                Map<String, DocumentRenderer> i18nDocuments = this.locateDocuments(i18nContext, filteredReports, locale);
                DoxiaBean doxiaBean = defaultLocale.equals(locale) ? new DoxiaBean(i18nContext, i18nDocuments, this.generatedSiteDirectory) : new DoxiaBean(i18nContext, i18nDocuments, new File(this.generatedSiteDirectory, locale.getLanguage()));
                i18nDoxiaContexts.put(locale.getLanguage(), doxiaBean);
                if (defaultLocale.equals(locale)) {
                    i18nDoxiaContexts.put("default", doxiaBean);
                }
                if (defaultLocale.equals(locale)) {
                    this.siteRenderer.copyResources(i18nContext, new File(this.siteDirectory, "resources"), this.tempWebappDirectory);
                    continue;
                }
                this.siteRenderer.copyResources(i18nContext, new File(this.siteDirectory, "resources"), new File(this.tempWebappDirectory, locale.getLanguage()));
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to set up webapp", e);
        }
    }

    private Connector getDefaultConnector() {
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(this.port);
        connector.setMaxIdleTime(30000);
        return connector;
    }

    public void setTempWebappDirectory(File tempWebappDirectory) {
        this.tempWebappDirectory = tempWebappDirectory;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

