/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.mojo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.shade.ShadeRequest;
import org.apache.maven.plugins.shade.Shader;
import org.apache.maven.plugins.shade.filter.Filter;
import org.apache.maven.plugins.shade.filter.MinijarFilter;
import org.apache.maven.plugins.shade.filter.SimpleFilter;
import org.apache.maven.plugins.shade.mojo.ArchiveFilter;
import org.apache.maven.plugins.shade.mojo.ArtifactId;
import org.apache.maven.plugins.shade.mojo.ArtifactSelector;
import org.apache.maven.plugins.shade.mojo.ArtifactSet;
import org.apache.maven.plugins.shade.mojo.PackageRelocation;
import org.apache.maven.plugins.shade.mojo.RelativizePath;
import org.apache.maven.plugins.shade.pom.PomWriter;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.relocation.SimpleRelocator;
import org.apache.maven.plugins.shade.resource.ManifestResourceTransformer;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;
import org.apache.maven.plugins.shade.resource.UseDependencyReducedPom;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.transfer.artifact.ArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.DefaultArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolverException;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamWriter;

@Mojo(name="shade", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class ShadeMojo
extends AbstractMojo {
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Component
    private MavenProjectHelper projectHelper;
    @Component(hint="default", role=Shader.class)
    private Shader shader;
    @Component
    private DependencyGraphBuilder dependencyGraphBuilder;
    @Component
    private ProjectBuilder projectBuilder;
    @Parameter(readonly=true, required=true, defaultValue="${project.remoteArtifactRepositories}")
    protected List<ArtifactRepository> remoteArtifactRepositories;
    @Parameter(readonly=true, required=true, defaultValue="${localRepository}")
    protected ArtifactRepository localRepository;
    @Component
    protected ArtifactResolver artifactResolver;
    @Parameter
    private ArtifactSet artifactSet;
    @Parameter
    private PackageRelocation[] relocations;
    @Parameter
    private ResourceTransformer[] transformers;
    @Parameter
    private ArchiveFilter[] filters;
    @Parameter(defaultValue="${project.build.directory}")
    private File outputDirectory;
    @Parameter
    private String finalName;
    @Parameter(defaultValue="${project.artifactId}")
    private String shadedArtifactId;
    @Parameter
    private String shadedGroupFilter;
    @Parameter
    private boolean shadedArtifactAttached;
    @Parameter(defaultValue="true")
    private boolean createDependencyReducedPom;
    @Parameter(defaultValue="${basedir}/dependency-reduced-pom.xml")
    private File dependencyReducedPomLocation;
    @Parameter(defaultValue="false")
    private boolean generateUniqueDependencyReducedPom;
    @Parameter(defaultValue="false")
    private boolean useDependencyReducedPomInJar;
    @Parameter
    private boolean keepDependenciesWithProvidedScope;
    @Parameter
    private boolean promoteTransitiveDependencies;
    @Parameter(defaultValue="shaded")
    private String shadedClassifierName;
    @Parameter
    private boolean createSourcesJar;
    @Parameter
    private boolean createTestSourcesJar;
    @Parameter(property="shadeSourcesContent", defaultValue="false")
    private boolean shadeSourcesContent;
    @Parameter
    private boolean minimizeJar;
    @Parameter
    private File outputFile;
    @Parameter
    private String shaderHint;
    @Parameter(defaultValue="false")
    private boolean useBaseVersion;
    @Parameter(defaultValue="false")
    private boolean shadeTestJar;
    @Inject
    private Map<String, Shader> shaders;
    @Parameter(defaultValue="false")
    private boolean skip;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Shading has been skipped.");
            return;
        }
        this.setupHintedShader();
        LinkedHashSet<File> artifacts = new LinkedHashSet<File>();
        LinkedHashSet<String> artifactIds = new LinkedHashSet<String>();
        LinkedHashSet<File> sourceArtifacts = new LinkedHashSet<File>();
        LinkedHashSet<File> testArtifacts = new LinkedHashSet<File>();
        LinkedHashSet<File> testSourceArtifacts = new LinkedHashSet<File>();
        ArtifactSelector artifactSelector = new ArtifactSelector(this.project.getArtifact(), this.artifactSet, this.shadedGroupFilter);
        if (artifactSelector.isSelected(this.project.getArtifact()) && !"pom".equals(this.project.getArtifact().getType())) {
            File file;
            if (this.invalidMainArtifact()) {
                this.createErrorOutput();
                throw new MojoExecutionException("Failed to create shaded artifact, project main artifact does not exist.");
            }
            artifacts.add(this.project.getArtifact().getFile());
            if (this.createSourcesJar && (file = this.shadedSourcesArtifactFile()).isFile()) {
                sourceArtifacts.add(file);
            }
            if (this.shadeTestJar && (file = this.shadedTestArtifactFile()).isFile()) {
                testArtifacts.add(file);
            }
            if (this.createTestSourcesJar && (file = this.shadedTestSourcesArtifactFile()).isFile()) {
                testSourceArtifacts.add(file);
            }
        }
        this.processArtifactSelectors(artifacts, artifactIds, sourceArtifacts, testArtifacts, testSourceArtifacts, artifactSelector);
        File outputJar = this.outputFile != null ? this.outputFile : this.shadedArtifactFileWithClassifier();
        File sourcesJar = this.shadedSourceArtifactFileWithClassifier();
        File testJar = this.shadedTestArtifactFileWithClassifier();
        File testSourcesJar = this.shadedTestSourceArtifactFileWithClassifier();
        try {
            List<Filter> filters = this.getFilters();
            List<Relocator> relocators = this.getRelocators();
            List<ResourceTransformer> resourceTransformers = this.getResourceTransformers();
            if (this.createDependencyReducedPom) {
                this.createDependencyReducedPom(artifactIds);
                if (this.useDependencyReducedPomInJar) {
                    resourceTransformers = new ArrayList<ResourceTransformer>(resourceTransformers);
                    resourceTransformers.addAll(UseDependencyReducedPom.createPomReplaceTransformers(this.project, this.dependencyReducedPomLocation));
                }
            }
            ShadeRequest shadeRequest = this.shadeRequest("jar", artifacts, outputJar, filters, relocators, resourceTransformers);
            this.shader.shade(shadeRequest);
            if (this.createSourcesJar) {
                ShadeRequest shadeSourcesRequest = this.createShadeSourcesRequest("sources-jar", sourceArtifacts, sourcesJar, filters, relocators, resourceTransformers);
                this.shader.shade(shadeSourcesRequest);
            }
            if (this.shadeTestJar) {
                ShadeRequest shadeTestRequest = this.shadeRequest("test-jar", testArtifacts, testJar, filters, relocators, resourceTransformers);
                this.shader.shade(shadeTestRequest);
            }
            if (this.createTestSourcesJar) {
                ShadeRequest shadeTestSourcesRequest = this.createShadeSourcesRequest("test-sources-jar", testSourceArtifacts, testSourcesJar, filters, relocators, resourceTransformers);
                this.shader.shade(shadeTestSourcesRequest);
            }
            if (this.outputFile == null) {
                boolean renamed = false;
                if (this.finalName != null && this.finalName.length() > 0 && !this.finalName.equals(this.project.getBuild().getFinalName())) {
                    String finalFileName = this.finalName + "." + this.project.getArtifact().getArtifactHandler().getExtension();
                    File finalFile = new File(this.outputDirectory, finalFileName);
                    this.replaceFile(finalFile, outputJar);
                    outputJar = finalFile;
                    if (this.createSourcesJar) {
                        finalFileName = this.finalName + "-sources.jar";
                        finalFile = new File(this.outputDirectory, finalFileName);
                        this.replaceFile(finalFile, sourcesJar);
                        sourcesJar = finalFile;
                    }
                    if (this.shadeTestJar) {
                        finalFileName = this.finalName + "-tests.jar";
                        finalFile = new File(this.outputDirectory, finalFileName);
                        this.replaceFile(finalFile, testJar);
                        testJar = finalFile;
                    }
                    if (this.createTestSourcesJar) {
                        finalFileName = this.finalName + "-test-sources.jar";
                        finalFile = new File(this.outputDirectory, finalFileName);
                        this.replaceFile(finalFile, testSourcesJar);
                        testSourcesJar = finalFile;
                    }
                    renamed = true;
                }
                if (this.shadedArtifactAttached) {
                    this.getLog().info((CharSequence)"Attaching shaded artifact.");
                    this.projectHelper.attachArtifact(this.project, this.project.getArtifact().getType(), this.shadedClassifierName, outputJar);
                    if (this.createSourcesJar) {
                        this.projectHelper.attachArtifact(this.project, "java-source", this.shadedClassifierName + "-sources", sourcesJar);
                    }
                    if (this.shadeTestJar) {
                        this.projectHelper.attachArtifact(this.project, "test-jar", this.shadedClassifierName + "-tests", testJar);
                    }
                    if (this.createTestSourcesJar) {
                        this.projectHelper.attachArtifact(this.project, "java-source", this.shadedClassifierName + "-test-sources", testSourcesJar);
                    }
                } else if (!renamed) {
                    this.getLog().info((CharSequence)"Replacing original artifact with shaded artifact.");
                    File originalArtifact = this.project.getArtifact().getFile();
                    if (originalArtifact != null) {
                        this.replaceFile(originalArtifact, outputJar);
                        if (this.createSourcesJar) {
                            this.getLog().info((CharSequence)"Replacing original source artifact with shaded source artifact.");
                            File shadedSources = this.shadedSourcesArtifactFile();
                            this.replaceFile(shadedSources, sourcesJar);
                            this.projectHelper.attachArtifact(this.project, "java-source", "sources", shadedSources);
                        }
                        if (this.shadeTestJar) {
                            this.getLog().info((CharSequence)"Replacing original test artifact with shaded test artifact.");
                            File shadedTests = this.shadedTestArtifactFile();
                            this.replaceFile(shadedTests, testJar);
                            this.projectHelper.attachArtifact(this.project, "test-jar", shadedTests);
                        }
                        if (this.createTestSourcesJar) {
                            this.getLog().info((CharSequence)"Replacing original test source artifact with shaded test source artifact.");
                            File shadedTestSources = this.shadedTestSourcesArtifactFile();
                            this.replaceFile(shadedTestSources, testSourcesJar);
                            this.projectHelper.attachArtifact(this.project, "java-source", "test-sources", shadedTestSources);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error creating shaded jar: " + e.getMessage(), e);
        }
    }

    private void createErrorOutput() {
        this.getLog().error((CharSequence)"The project main artifact does not exist. This could have the following");
        this.getLog().error((CharSequence)"reasons:");
        this.getLog().error((CharSequence)"- You have invoked the goal directly from the command line. This is not");
        this.getLog().error((CharSequence)"  supported. Please add the goal to the default lifecycle via an");
        this.getLog().error((CharSequence)"  <execution> element in your POM and use \"mvn package\" to have it run.");
        this.getLog().error((CharSequence)"- You have bound the goal to a lifecycle phase before \"package\". Please");
        this.getLog().error((CharSequence)"  remove this binding from your POM such that the goal will be run in");
        this.getLog().error((CharSequence)"  the proper phase.");
        this.getLog().error((CharSequence)"- You removed the configuration of the maven-jar-plugin that produces the main artifact.");
    }

    private ShadeRequest shadeRequest(String shade, Set<File> artifacts, File outputJar, List<Filter> filters, List<Relocator> relocators, List<ResourceTransformer> resourceTransformers) {
        ShadeRequest shadeRequest = new ShadeRequest();
        shadeRequest.setJars(artifacts);
        shadeRequest.setUberJar(outputJar);
        shadeRequest.setFilters(filters);
        shadeRequest.setRelocators(relocators);
        shadeRequest.setResourceTransformers(this.toResourceTransformers(shade, resourceTransformers));
        return shadeRequest;
    }

    private ShadeRequest createShadeSourcesRequest(String shade, Set<File> testArtifacts, File testJar, List<Filter> filters, List<Relocator> relocators, List<ResourceTransformer> resourceTransformers) {
        ShadeRequest shadeSourcesRequest = this.shadeRequest(shade, testArtifacts, testJar, filters, relocators, resourceTransformers);
        shadeSourcesRequest.setShadeSourcesContent(this.shadeSourcesContent);
        return shadeSourcesRequest;
    }

    private void setupHintedShader() throws MojoExecutionException {
        if (this.shaderHint != null) {
            this.shader = this.shaders.get(this.shaderHint);
            if (this.shader == null) {
                throw new MojoExecutionException("unable to lookup own Shader implementation with hint: '" + this.shaderHint + "'");
            }
        }
    }

    private void processArtifactSelectors(Set<File> artifacts, Set<String> artifactIds, Set<File> sourceArtifacts, Set<File> testArtifacts, Set<File> testSourceArtifacts, ArtifactSelector artifactSelector) {
        ArrayList<String> excludedArtifacts = new ArrayList<String>();
        ArrayList<String> pomArtifacts = new ArrayList<String>();
        ArrayList<String> emptySourceArtifacts = new ArrayList<String>();
        ArrayList<String> emptyTestArtifacts = new ArrayList<String>();
        ArrayList<String> emptyTestSourceArtifacts = new ArrayList<String>();
        for (Artifact artifact : this.project.getArtifacts()) {
            File file;
            if (!artifactSelector.isSelected(artifact)) {
                excludedArtifacts.add(artifact.getId());
                continue;
            }
            if ("pom".equals(artifact.getType())) {
                pomArtifacts.add(artifact.getId());
                continue;
            }
            this.getLog().info((CharSequence)("Including " + artifact.getId() + " in the shaded jar."));
            artifacts.add(artifact.getFile());
            artifactIds.add(this.getId(artifact));
            if (this.createSourcesJar && (file = this.resolveArtifactForClassifier(artifact, "sources")) != null) {
                if (file.length() > 0L) {
                    sourceArtifacts.add(file);
                } else {
                    emptySourceArtifacts.add(artifact.getArtifactId());
                }
            }
            if (this.shadeTestJar && (file = this.resolveArtifactForClassifier(artifact, "tests")) != null) {
                if (file.length() > 0L) {
                    testArtifacts.add(file);
                } else {
                    emptyTestArtifacts.add(artifact.getId());
                }
            }
            if (!this.createTestSourcesJar) continue;
            file = this.resolveArtifactForClassifier(artifact, "test-sources");
            if (file != null) {
                testSourceArtifacts.add(file);
                continue;
            }
            emptyTestSourceArtifacts.add(artifact.getId());
        }
        for (String artifactId : excludedArtifacts) {
            this.getLog().info((CharSequence)("Excluding " + artifactId + " from the shaded jar."));
        }
        for (String artifactId : pomArtifacts) {
            this.getLog().info((CharSequence)("Skipping pom dependency " + artifactId + " in the shaded jar."));
        }
        for (String artifactId : emptySourceArtifacts) {
            this.getLog().warn((CharSequence)("Skipping empty source jar " + artifactId + "."));
        }
        for (String artifactId : emptyTestArtifacts) {
            this.getLog().warn((CharSequence)("Skipping empty test jar " + artifactId + "."));
        }
        for (String artifactId : emptyTestArtifacts) {
            this.getLog().warn((CharSequence)("Skipping empty test source jar " + artifactId + "."));
        }
    }

    private boolean invalidMainArtifact() {
        return this.project.getArtifact().getFile() == null || !this.project.getArtifact().getFile().isFile();
    }

    private void replaceFile(File oldFile, File newFile) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Replacing " + oldFile + " with " + newFile));
        File origFile = new File(this.outputDirectory, "original-" + oldFile.getName());
        if (oldFile.exists() && !oldFile.renameTo(origFile)) {
            System.gc();
            System.gc();
            if (!oldFile.renameTo(origFile)) {
                try {
                    this.copyFiles(oldFile, origFile);
                }
                catch (IOException ex) {
                    this.getLog().warn((Throwable)ex);
                }
            }
        }
        if (!newFile.renameTo(oldFile)) {
            System.gc();
            System.gc();
            if (!newFile.renameTo(oldFile)) {
                try {
                    this.copyFiles(newFile, oldFile);
                }
                catch (IOException ex) {
                    throw new MojoExecutionException("Could not replace original artifact with shaded artifact!", (Exception)ex);
                }
            }
        }
    }

    private void copyFiles(File source, File target) throws IOException {
        try (FileInputStream in = new FileInputStream(source);
             FileOutputStream out = new FileOutputStream(target);){
            IOUtil.copy((InputStream)in, (OutputStream)out);
        }
    }

    private File resolveArtifactForClassifier(Artifact artifact, String classifier) {
        Artifact resolvedArtifact;
        DefaultArtifactCoordinate coordinate = new DefaultArtifactCoordinate();
        coordinate.setGroupId(artifact.getGroupId());
        coordinate.setArtifactId(artifact.getArtifactId());
        coordinate.setVersion(artifact.getVersion());
        coordinate.setExtension("jar");
        coordinate.setClassifier(classifier);
        try {
            resolvedArtifact = this.artifactResolver.resolveArtifact(this.session.getProjectBuildingRequest(), (ArtifactCoordinate)coordinate).getArtifact();
        }
        catch (ArtifactResolverException e) {
            this.getLog().warn((CharSequence)("Could not get " + classifier + " for " + artifact));
            return null;
        }
        if (resolvedArtifact.isResolved()) {
            return resolvedArtifact.getFile();
        }
        return null;
    }

    private List<Relocator> getRelocators() {
        ArrayList<Relocator> relocators = new ArrayList<Relocator>();
        if (this.relocations == null) {
            return relocators;
        }
        for (PackageRelocation r : this.relocations) {
            relocators.add(new SimpleRelocator(r.getPattern(), r.getShadedPattern(), r.getIncludes(), r.getExcludes(), r.isRawString()));
        }
        return relocators;
    }

    private List<ResourceTransformer> getResourceTransformers() {
        if (this.transformers == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.transformers);
    }

    private List<Filter> getFilters() throws MojoExecutionException {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        ArrayList<SimpleFilter> simpleFilters = new ArrayList<SimpleFilter>();
        if (this.filters != null && this.filters.length > 0) {
            HashMap<Artifact, ArtifactId> artifacts = new HashMap<Artifact, ArtifactId>();
            artifacts.put(this.project.getArtifact(), new ArtifactId(this.project.getArtifact()));
            for (Artifact artifact : this.project.getArtifacts()) {
                artifacts.put(artifact, new ArtifactId(artifact));
            }
            for (ArchiveFilter filter : this.filters) {
                ArtifactId pattern = new ArtifactId(filter.getArtifact());
                HashSet<File> jars = new HashSet<File>();
                for (Map.Entry entry : artifacts.entrySet()) {
                    File file;
                    if (!((ArtifactId)entry.getValue()).matches(pattern)) continue;
                    Artifact artifact = (Artifact)entry.getKey();
                    jars.add(artifact.getFile());
                    if (this.createSourcesJar && (file = this.resolveArtifactForClassifier(artifact, "sources")) != null) {
                        jars.add(file);
                    }
                    if (!this.shadeTestJar || (file = this.resolveArtifactForClassifier(artifact, "tests")) == null) continue;
                    jars.add(file);
                }
                if (jars.isEmpty()) {
                    this.getLog().info((CharSequence)("No artifact matching filter " + filter.getArtifact()));
                    continue;
                }
                simpleFilters.add(new SimpleFilter(jars, filter));
            }
        }
        filters.addAll(simpleFilters);
        if (this.minimizeJar) {
            this.getLog().info((CharSequence)("Minimizing jar " + this.project.getArtifact()));
            try {
                filters.add(new MinijarFilter(this.project, this.getLog(), simpleFilters));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to analyze class dependencies", (Exception)e);
            }
        }
        return filters;
    }

    private File shadedArtifactFileWithClassifier() {
        Artifact artifact = this.project.getArtifact();
        String shadedName = this.shadedArtifactId + "-" + artifact.getVersion() + "-" + this.shadedClassifierName + "." + artifact.getArtifactHandler().getExtension();
        return new File(this.outputDirectory, shadedName);
    }

    private File shadedSourceArtifactFileWithClassifier() {
        return this.shadedArtifactFileWithClassifier("sources");
    }

    private File shadedTestSourceArtifactFileWithClassifier() {
        return this.shadedArtifactFileWithClassifier("test-sources");
    }

    private File shadedArtifactFileWithClassifier(String classifier) {
        Artifact artifact = this.project.getArtifact();
        String shadedName = this.shadedArtifactId + "-" + artifact.getVersion() + "-" + this.shadedClassifierName + "-" + classifier + "." + artifact.getArtifactHandler().getExtension();
        return new File(this.outputDirectory, shadedName);
    }

    private File shadedTestArtifactFileWithClassifier() {
        return this.shadedArtifactFileWithClassifier("tests");
    }

    private File shadedSourcesArtifactFile() {
        return this.shadedArtifactFile("sources");
    }

    private File shadedTestSourcesArtifactFile() {
        return this.shadedArtifactFile("test-sources");
    }

    private File shadedArtifactFile(String classifier) {
        Artifact artifact = this.project.getArtifact();
        String shadedName = this.project.getBuild().getFinalName() != null ? this.project.getBuild().getFinalName() + "-" + classifier + "." + artifact.getArtifactHandler().getExtension() : this.shadedArtifactId + "-" + artifact.getVersion() + "-" + classifier + "." + artifact.getArtifactHandler().getExtension();
        return new File(this.outputDirectory, shadedName);
    }

    private File shadedTestArtifactFile() {
        return this.shadedArtifactFile("tests");
    }

    private void createDependencyReducedPom(Set<String> artifactsToRemove) throws IOException, DependencyGraphBuilderException, ProjectBuildingException {
        ArrayList<Dependency> transitiveDeps = new ArrayList<Dependency>();
        for (Artifact artifact : this.project.getArtifacts()) {
            if ("pom".equals(artifact.getType())) continue;
            Dependency dep = this.createDependency(artifact);
            transitiveDeps.add(dep);
        }
        Model model = this.project.getOriginalModel();
        ArrayList<Dependency> origDeps = new ArrayList<Dependency>();
        ArrayList<Dependency> source = this.promoteTransitiveDependencies ? transitiveDeps : this.project.getDependencies();
        for (Dependency d : source) {
            origDeps.add(d.clone());
        }
        model = model.clone();
        List originalDependencies = model.getDependencies();
        this.removeSystemScopedDependencies(artifactsToRemove, originalDependencies);
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        boolean modified = false;
        for (Dependency d : origDeps) {
            if (artifactsToRemove.contains(this.getId(d))) {
                if (this.keepDependenciesWithProvidedScope) {
                    if (!"provided".equals(d.getScope())) {
                        modified = true;
                        d.setScope("provided");
                    }
                } else {
                    modified = true;
                    continue;
                }
            }
            dependencies.add(d);
        }
        model.setArtifactId(this.shadedArtifactId);
        this.addSystemScopedDependencyFromNonInterpolatedPom(dependencies, originalDependencies);
        this.rewriteDependencyReducedPomIfWeHaveReduction(dependencies, modified, transitiveDeps, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rewriteDependencyReducedPomIfWeHaveReduction(List<Dependency> dependencies, boolean modified, List<Dependency> transitiveDeps, Model model) throws IOException, ProjectBuildingException, DependencyGraphBuilderException {
        if (modified) {
            int loopCounter = 0;
            while (modified) {
                model.setDependencies(dependencies);
                if (this.generateUniqueDependencyReducedPom) {
                    this.dependencyReducedPomLocation = File.createTempFile("dependency-reduced-pom-", ".xml", this.project.getBasedir());
                    this.project.getProperties().setProperty("maven.shade.dependency-reduced-pom", this.dependencyReducedPomLocation.getAbsolutePath());
                } else if (this.dependencyReducedPomLocation == null) {
                    this.dependencyReducedPomLocation = new File(this.project.getBasedir(), "dependency-reduced-pom.xml");
                }
                File f = this.dependencyReducedPomLocation;
                if (loopCounter == 0) {
                    this.getLog().info((CharSequence)("Dependency-reduced POM written at: " + f.getAbsolutePath()));
                }
                if (f.exists()) {
                    f.delete();
                }
                XmlStreamWriter w = WriterFactory.newXmlWriter((File)f);
                String replaceRelativePath = null;
                if (model.getParent() != null) {
                    replaceRelativePath = model.getParent().getRelativePath();
                }
                if (model.getParent() != null) {
                    File parentFile = new File(this.project.getBasedir(), model.getParent().getRelativePath()).getCanonicalFile();
                    if (!parentFile.isFile()) {
                        parentFile = new File(parentFile, "pom.xml");
                    }
                    parentFile = parentFile.getCanonicalFile();
                    String relPath = RelativizePath.convertToRelativePath(parentFile, f);
                    model.getParent().setRelativePath(relPath);
                }
                try {
                    PomWriter.write((Writer)w, model, true);
                }
                finally {
                    if (model.getParent() != null) {
                        model.getParent().setRelativePath(replaceRelativePath);
                    }
                    w.close();
                }
                DefaultProjectBuildingRequest projectBuildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
                projectBuildingRequest.setLocalRepository(this.localRepository);
                projectBuildingRequest.setRemoteRepositories(this.remoteArtifactRepositories);
                ProjectBuildingResult result = this.projectBuilder.build(f, (ProjectBuildingRequest)projectBuildingRequest);
                this.getLog().debug((CharSequence)"updateExcludesInDeps()");
                modified = this.updateExcludesInDeps(result.getProject(), dependencies, transitiveDeps);
                ++loopCounter;
            }
            this.project.setFile(this.dependencyReducedPomLocation);
        }
    }

    private void removeSystemScopedDependencies(Set<String> artifactsToRemove, List<Dependency> originalDependencies) {
        for (Dependency dependency : originalDependencies) {
            if (dependency.getScope() == null || !dependency.getScope().equalsIgnoreCase("system")) continue;
            artifactsToRemove.add(this.getId(dependency));
        }
    }

    private void addSystemScopedDependencyFromNonInterpolatedPom(List<Dependency> dependencies, List<Dependency> originalDependencies) {
        for (Dependency dependency : originalDependencies) {
            if (dependency.getScope() == null || !dependency.getScope().equalsIgnoreCase("system")) continue;
            dependencies.add(dependency);
        }
    }

    private Dependency createDependency(Artifact artifact) {
        Dependency dep = new Dependency();
        dep.setArtifactId(artifact.getArtifactId());
        if (artifact.hasClassifier()) {
            dep.setClassifier(artifact.getClassifier());
        }
        dep.setGroupId(artifact.getGroupId());
        dep.setOptional(artifact.isOptional());
        dep.setScope(artifact.getScope());
        dep.setType(artifact.getType());
        if (this.useBaseVersion) {
            dep.setVersion(artifact.getBaseVersion());
        } else {
            dep.setVersion(artifact.getVersion());
        }
        return dep;
    }

    private String getId(Artifact artifact) {
        return this.getId(artifact.getGroupId(), artifact.getArtifactId(), artifact.getType(), artifact.getClassifier());
    }

    private String getId(Dependency dependency) {
        return this.getId(dependency.getGroupId(), dependency.getArtifactId(), dependency.getType(), dependency.getClassifier());
    }

    private String getId(String groupId, String artifactId, String type, String classifier) {
        return groupId + ":" + artifactId + ":" + type + ":" + (classifier != null ? classifier : "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateExcludesInDeps(MavenProject project, List<Dependency> dependencies, List<Dependency> transitiveDeps) throws DependencyGraphBuilderException {
        MavenProject original = this.session.getProjectBuildingRequest().getProject();
        try {
            this.session.getProjectBuildingRequest().setProject(project);
            DependencyNode node = this.dependencyGraphBuilder.buildDependencyGraph(this.session.getProjectBuildingRequest(), null);
            boolean modified = false;
            for (DependencyNode n2 : node.getChildren()) {
                String artifactId2 = this.getId(n2.getArtifact());
                block4: for (DependencyNode n3 : n2.getChildren()) {
                    Artifact artifact3 = n3.getArtifact();
                    String artifactId3 = this.getId(artifact3);
                    boolean found = false;
                    for (Dependency dep : transitiveDeps) {
                        if (!this.getId(dep).equals(artifactId3)) continue;
                        found = true;
                        break;
                    }
                    if (found || "provided".equals(artifact3.getScope())) continue;
                    this.getLog().debug((CharSequence)String.format("dependency %s (scope %s) not found in transitive dependencies", artifactId3, artifact3.getScope()));
                    for (Dependency dep : dependencies) {
                        if (!this.getId(dep).equals(artifactId2) || this.dependencyHasExclusion(dep, artifact3)) continue;
                        this.getLog().debug((CharSequence)String.format("Adding exclusion for dependency %s (scope %s) to %s (scope %s)", artifactId3, artifact3.getScope(), this.getId(dep), dep.getScope()));
                        Exclusion exclusion = new Exclusion();
                        exclusion.setArtifactId(artifact3.getArtifactId());
                        exclusion.setGroupId(artifact3.getGroupId());
                        dep.addExclusion(exclusion);
                        modified = true;
                        continue block4;
                    }
                }
            }
            boolean bl = modified;
            return bl;
        }
        finally {
            this.session.getProjectBuildingRequest().setProject(original);
        }
    }

    private boolean dependencyHasExclusion(Dependency dep, Artifact exclusionToCheck) {
        boolean containsExclusion = false;
        for (Exclusion existingExclusion : dep.getExclusions()) {
            if (!existingExclusion.getGroupId().equals(exclusionToCheck.getGroupId()) || !existingExclusion.getArtifactId().equals(exclusionToCheck.getArtifactId())) continue;
            containsExclusion = true;
            break;
        }
        return containsExclusion;
    }

    private List<ResourceTransformer> toResourceTransformers(String shade, List<ResourceTransformer> resourceTransformers) {
        ArrayList<ResourceTransformer> forShade = new ArrayList<ResourceTransformer>();
        ManifestResourceTransformer lastMt = null;
        for (ResourceTransformer transformer : resourceTransformers) {
            ManifestResourceTransformer mt;
            if (!(transformer instanceof ManifestResourceTransformer)) {
                forShade.add(transformer);
                continue;
            }
            if (!((ManifestResourceTransformer)transformer).isForShade(shade) || (mt = (ManifestResourceTransformer)transformer).isUsedForDefaultShading() && lastMt != null && !lastMt.isUsedForDefaultShading()) continue;
            if (!mt.isUsedForDefaultShading() && lastMt != null && lastMt.isUsedForDefaultShading()) {
                forShade.remove(lastMt);
            } else if (!mt.isUsedForDefaultShading() && lastMt != null) {
                this.getLog().warn((CharSequence)("Ambiguous manifest transformer definition for '" + shade + "': " + mt + " / " + lastMt));
            }
            if (lastMt == null || !mt.isUsedForDefaultShading()) {
                lastMt = mt;
            }
            forShade.add(transformer);
        }
        return forShade;
    }
}

