/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.filter;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.shade.filter.Filter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.IOUtil;
import org.vafer.jdependency.Clazz;
import org.vafer.jdependency.Clazzpath;
import org.vafer.jdependency.ClazzpathUnit;

public class MinijarFilter
implements Filter {
    private Log log;
    private Set removable;
    private int classes_kept;
    private int classes_removed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MinijarFilter(MavenProject project, Log log) throws IOException {
        this.log = log;
        Clazzpath cp = new Clazzpath();
        ClazzpathUnit artifactUnit = cp.addClazzpathUnit((InputStream)new FileInputStream(project.getArtifact().getFile()), project.toString());
        for (Artifact dependency : project.getArtifacts()) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(dependency.getFile());
                cp.addClazzpathUnit((InputStream)is, dependency.toString());
            }
            catch (Throwable throwable) {
                IOUtil.close(is);
                throw throwable;
            }
            IOUtil.close((InputStream)is);
        }
        this.removable = cp.getClazzes();
        this.removePackages(artifactUnit);
        this.removable.removeAll(artifactUnit.getClazzes());
        this.removable.removeAll(artifactUnit.getTransitiveDependencies());
    }

    private void removePackages(ClazzpathUnit artifactUnit) {
        HashSet packageNames = new HashSet();
        this.removePackages(artifactUnit.getClazzes(), packageNames);
        this.removePackages(artifactUnit.getTransitiveDependencies(), packageNames);
    }

    private void removePackages(Set clazzes, Set packageNames) {
        for (Clazz clazz : clazzes) {
            String name = clazz.getName();
            while (name.contains(".")) {
                if (!packageNames.add(name = name.substring(0, name.lastIndexOf(46)))) continue;
                this.removable.remove(new Clazz(name + ".package-info"));
            }
        }
    }

    public boolean canFilter(File jar) {
        return true;
    }

    public boolean isFiltered(String classFile) {
        String className = classFile.replace('/', '.').replaceFirst("\\.class$", "");
        Clazz clazz = new Clazz(className);
        if (this.removable.contains(clazz)) {
            this.log.debug((CharSequence)("Removing " + className));
            ++this.classes_removed;
            return true;
        }
        ++this.classes_kept;
        return false;
    }

    public void finished() {
        int classes_total = this.classes_removed + this.classes_kept;
        this.log.info((CharSequence)("Minimized " + classes_total + " -> " + this.classes_kept + " (" + 100 * this.classes_kept / classes_total + "%)"));
    }
}

